/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.system.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.xpanse.modules.models.common.exceptions.UnsupportedEnumValueException;

public enum DatabaseType {
    H2DB("h2"),
    MYSQL("mysql");

    private final String code;

    private DatabaseType(String code) {
        this.code = code;
    }

    @JsonCreator
    public static DatabaseType getByValue(String code) {
        for (DatabaseType providerType : DatabaseType.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)code, (CharSequence)providerType.code)) continue;
            return providerType;
        }
        throw new UnsupportedEnumValueException(String.format("DatabaseType value %s is not supported.", code));
    }

    @JsonValue
    public String toValue() {
        return this.code;
    }
}

