/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.workflow;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.datatype.jsr310.ser.OffsetDateTimeSerializer;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import lombok.Generated;
import org.eclipse.xpanse.modules.models.workflow.WorkFlowTaskStatus;

public class WorkFlowTask {
    @NotEmpty
    @Schema(description="The id of the ProcessInstance")
    private String processInstanceId;
    @Schema(description="The name of the ProcessInstance")
    private String processInstanceName;
    @NotEmpty
    @Schema(description="The id of the ProcessDefinition")
    private String processDefinitionId;
    @NotEmpty
    @Schema(description="The name of the ProcessDefinition")
    private String processDefinitionName;
    @NotEmpty
    @Schema(description="The execution id of the ProcessInstance")
    private String executionId;
    @NotEmpty
    @Schema(description="The id of the task")
    private String taskId;
    @NotEmpty
    @Schema(description="The name of the task")
    private String taskName;
    @NotEmpty
    @Schema(description="The businessKey of the Process")
    private String businessKey;
    @NotNull
    @Schema(description="The status of the Task")
    private WorkFlowTaskStatus status;
    @NotNull
    @Schema(description="The create time of the task")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss XXX")
    @JsonSerialize(using=OffsetDateTimeSerializer.class)
    private OffsetDateTime createTime;

    @Generated
    public WorkFlowTask() {
    }

    @Generated
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Generated
    public String getProcessInstanceName() {
        return this.processInstanceName;
    }

    @Generated
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @Generated
    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    @Generated
    public String getExecutionId() {
        return this.executionId;
    }

    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Generated
    public String getTaskName() {
        return this.taskName;
    }

    @Generated
    public String getBusinessKey() {
        return this.businessKey;
    }

    @Generated
    public WorkFlowTaskStatus getStatus() {
        return this.status;
    }

    @Generated
    public OffsetDateTime getCreateTime() {
        return this.createTime;
    }

    @Generated
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Generated
    public void setProcessInstanceName(String processInstanceName) {
        this.processInstanceName = processInstanceName;
    }

    @Generated
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Generated
    public void setProcessDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
    }

    @Generated
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @Generated
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Generated
    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    @Generated
    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    @Generated
    public void setStatus(WorkFlowTaskStatus status) {
        this.status = status;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss XXX")
    @Generated
    public void setCreateTime(OffsetDateTime createTime) {
        this.createTime = createTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkFlowTask)) {
            return false;
        }
        WorkFlowTask other = (WorkFlowTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$processInstanceId = this.getProcessInstanceId();
        String other$processInstanceId = other.getProcessInstanceId();
        if (this$processInstanceId == null ? other$processInstanceId != null : !this$processInstanceId.equals(other$processInstanceId)) {
            return false;
        }
        String this$processInstanceName = this.getProcessInstanceName();
        String other$processInstanceName = other.getProcessInstanceName();
        if (this$processInstanceName == null ? other$processInstanceName != null : !this$processInstanceName.equals(other$processInstanceName)) {
            return false;
        }
        String this$processDefinitionId = this.getProcessDefinitionId();
        String other$processDefinitionId = other.getProcessDefinitionId();
        if (this$processDefinitionId == null ? other$processDefinitionId != null : !this$processDefinitionId.equals(other$processDefinitionId)) {
            return false;
        }
        String this$processDefinitionName = this.getProcessDefinitionName();
        String other$processDefinitionName = other.getProcessDefinitionName();
        if (this$processDefinitionName == null ? other$processDefinitionName != null : !this$processDefinitionName.equals(other$processDefinitionName)) {
            return false;
        }
        String this$executionId = this.getExecutionId();
        String other$executionId = other.getExecutionId();
        if (this$executionId == null ? other$executionId != null : !this$executionId.equals(other$executionId)) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        String this$taskName = this.getTaskName();
        String other$taskName = other.getTaskName();
        if (this$taskName == null ? other$taskName != null : !this$taskName.equals(other$taskName)) {
            return false;
        }
        String this$businessKey = this.getBusinessKey();
        String other$businessKey = other.getBusinessKey();
        if (this$businessKey == null ? other$businessKey != null : !this$businessKey.equals(other$businessKey)) {
            return false;
        }
        WorkFlowTaskStatus this$status = this.getStatus();
        WorkFlowTaskStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        OffsetDateTime this$createTime = this.getCreateTime();
        OffsetDateTime other$createTime = other.getCreateTime();
        return !(this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WorkFlowTask;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $processInstanceId = this.getProcessInstanceId();
        result = result * 59 + ($processInstanceId == null ? 43 : $processInstanceId.hashCode());
        String $processInstanceName = this.getProcessInstanceName();
        result = result * 59 + ($processInstanceName == null ? 43 : $processInstanceName.hashCode());
        String $processDefinitionId = this.getProcessDefinitionId();
        result = result * 59 + ($processDefinitionId == null ? 43 : $processDefinitionId.hashCode());
        String $processDefinitionName = this.getProcessDefinitionName();
        result = result * 59 + ($processDefinitionName == null ? 43 : $processDefinitionName.hashCode());
        String $executionId = this.getExecutionId();
        result = result * 59 + ($executionId == null ? 43 : $executionId.hashCode());
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        String $taskName = this.getTaskName();
        result = result * 59 + ($taskName == null ? 43 : $taskName.hashCode());
        String $businessKey = this.getBusinessKey();
        result = result * 59 + ($businessKey == null ? 43 : $businessKey.hashCode());
        WorkFlowTaskStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        OffsetDateTime $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WorkFlowTask(processInstanceId=" + this.getProcessInstanceId() + ", processInstanceName=" + this.getProcessInstanceName() + ", processDefinitionId=" + this.getProcessDefinitionId() + ", processDefinitionName=" + this.getProcessDefinitionName() + ", executionId=" + this.getExecutionId() + ", taskId=" + this.getTaskId() + ", taskName=" + this.getTaskName() + ", businessKey=" + this.getBusinessKey() + ", status=" + String.valueOf((Object)this.getStatus()) + ", createTime=" + String.valueOf(this.getCreateTime()) + ")";
    }
}

