/**
 * Copyright (c) 2013-2017 Lorenzo Bettini.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Lorenzo Bettini - Initial contribution and API
 */
package org.eclipse.xsemantics.runtime.caching;

import java.util.ArrayList;
import org.eclipse.xsemantics.runtime.XsemanticsCacheListener;

/**
 * A utility base class for listening to XsemanticsCache hits and misses
 * 
 * @author Lorenzo Bettini
 * @since 1.5
 */
@SuppressWarnings("all")
public abstract class XsemanticsCacheLoggerListener implements XsemanticsCacheListener {
  private final ArrayList<String> hits = new ArrayList<String>();

  private final ArrayList<String> missed = new ArrayList<String>();

  @Override
  public void reset() {
    this.hits.clear();
    this.missed.clear();
  }

  public ArrayList<String> getHits() {
    return this.hits;
  }

  public ArrayList<String> getMissed() {
    return this.missed;
  }
}
