/**
 * Copyright (c) 2013-2017 Lorenzo Bettini.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Lorenzo Bettini - Initial contribution and API
 */
package org.eclipse.xsemantics.runtime.caching;

import com.google.inject.Inject;
import java.util.ArrayList;
import org.eclipse.xsemantics.runtime.StringRepresentation;
import org.eclipse.xsemantics.runtime.XsemanticsCachedData;
import org.eclipse.xtext.xbase.lib.Extension;

/**
 * A utility class for recording Result strings
 * involved in XsemanticsCache hits and misses
 * 
 * @author Lorenzo Bettini
 * @since 1.5
 */
@SuppressWarnings("all")
public class XsemanticsCacheResultLoggerListener extends XsemanticsCacheLoggerListener {
  @Inject
  @Extension
  private StringRepresentation _stringRepresentation;

  /**
   * @since 1.6
   */
  @Override
  public void cacheHit(final XsemanticsCachedData<?> data) {
    Object _result = data.getResult();
    boolean _tripleNotEquals = (_result != null);
    if (_tripleNotEquals) {
      ArrayList<String> _hits = this.getHits();
      String _resultRepresentation = this.resultRepresentation(data);
      _hits.add(_resultRepresentation);
    }
  }

  /**
   * @since 1.6
   */
  @Override
  public void cacheMissed(final XsemanticsCachedData<?> data) {
    Object _result = data.getResult();
    boolean _tripleNotEquals = (_result != null);
    if (_tripleNotEquals) {
      ArrayList<String> _missed = this.getMissed();
      String _resultRepresentation = this.resultRepresentation(data);
      _missed.add(_resultRepresentation);
    }
  }

  /**
   * @since 1.6
   */
  public String resultRepresentation(final XsemanticsCachedData<?> data) {
    String _name = data.getName();
    String _plus = (_name + ": ");
    String _string = this._stringRepresentation.string(data.getResult());
    return (_plus + _string);
  }
}
