/**
 * Copyright (c) 2013-2017 Lorenzo Bettini.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Lorenzo Bettini - Initial contribution and API
 */
package org.eclipse.xsemantics.runtime.caching;

import com.google.inject.Inject;
import java.util.ArrayList;
import org.eclipse.xsemantics.runtime.RuleApplicationTrace;
import org.eclipse.xsemantics.runtime.TraceUtils;
import org.eclipse.xsemantics.runtime.XsemanticsCachedData;
import org.eclipse.xtext.xbase.lib.Extension;

/**
 * A utility class for recording RuleApplicationTrace strings
 * involved in XsemanticsCache hits and misses
 * 
 * @author Lorenzo Bettini
 * @since 1.5
 */
@SuppressWarnings("all")
public class XsemanticsCacheTraceLoggerListener extends XsemanticsCacheLoggerListener {
  @Inject
  @Extension
  private TraceUtils _traceUtils;

  /**
   * @since 1.6
   */
  @Override
  public void cacheHit(final XsemanticsCachedData<?> data) {
    RuleApplicationTrace _trace = data.getTrace();
    boolean _tripleNotEquals = (_trace != null);
    if (_tripleNotEquals) {
      ArrayList<String> _hits = this.getHits();
      String _dataTraceRepresentation = this.dataTraceRepresentation(data);
      _hits.add(_dataTraceRepresentation);
    }
  }

  /**
   * @since 1.6
   */
  @Override
  public void cacheMissed(final XsemanticsCachedData<?> data) {
    RuleApplicationTrace _trace = data.getTrace();
    boolean _tripleNotEquals = (_trace != null);
    if (_tripleNotEquals) {
      ArrayList<String> _missed = this.getMissed();
      String _dataTraceRepresentation = this.dataTraceRepresentation(data);
      _missed.add(_dataTraceRepresentation);
    }
  }

  /**
   * @since 1.6
   */
  public String dataTraceRepresentation(final XsemanticsCachedData<?> data) {
    return this._traceUtils.removeIndentation(this._traceUtils.lastElementNotTrace(data.getTrace()).toString());
  }
}
