/**
 * Copyright (c) 2013-2017 Lorenzo Bettini.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Lorenzo Bettini - Initial contribution and API
 */
package org.eclipse.xsemantics.runtime.caching.util;

import com.google.common.collect.Iterables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions.Function2;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

/**
 * Utility functions for caching.
 * 
 * @author Lorenzo Bettini
 * 
 * @since 1.8
 */
@SuppressWarnings("all")
public class XsemanticsCacheUtils {
  public Resource getResource(final Object... elements) {
    EObject _head = IterableExtensions.<EObject>head(Iterables.<EObject>filter(((Iterable<?>)Conversions.doWrapArray(elements)), EObject.class));
    Resource _eResource = null;
    if (_head!=null) {
      _eResource=_head.eResource();
    }
    return _eResource;
  }

  public Object getKeys(final Object... elements) {
    final Function2<Object, Object, Object> _function = (Object p1, Object p2) -> {
      return Pair.<Object, Object>of(p1, p2);
    };
    return IterableExtensions.<Object>reduce(((Iterable<?>)Conversions.doWrapArray(elements)), _function);
  }
}
