/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsemantics.runtime;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsemantics.runtime.ErrorInformation;
import org.eclipse.xsemantics.runtime.RuleApplicationTrace;
import org.eclipse.xsemantics.runtime.RuleFailedException;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class TraceUtils {
    public LinkedList<RuleFailedException> failureAsList(RuleFailedException e) {
        LinkedList linkedList = null;
        LinkedList list = CollectionLiterals.newLinkedList((Object[])new RuleFailedException[]{e});
        RuleFailedException ex = e.previous;
        while (ex != null) {
            boolean bl;
            String string = ex.getMessage();
            boolean bl2 = bl = string != null;
            if (bl) {
                list.add(ex);
            }
            ex = ex.previous;
        }
        linkedList = list;
        return linkedList;
    }

    public List<String> failureTraceAsStrings(RuleFailedException e) {
        List list = null;
        StringBuffer indent = new StringBuffer("");
        Functions.Function1 function1 = it -> {
            String string = null;
            String string2 = indent.toString();
            String string3 = this.removeIndentation(it.getMessage());
            String listElem = String.valueOf(string2) + string3;
            indent.append(" ");
            string = listElem;
            return string;
        };
        list = ListExtensions.map(this.failureAsList(e), (Functions.Function1)function1);
        return list;
    }

    public String failureTraceAsString(RuleFailedException e) {
        return IterableExtensions.join(this.failureTraceAsStrings(e), (CharSequence)"\n");
    }

    public LinkedList<String> traceAsStrings(RuleApplicationTrace ruleTrace) {
        LinkedList<String> linkedList = null;
        LinkedList<String> result = new LinkedList<String>();
        for (Object e : ruleTrace.trace) {
            this.buildTrace(result, e, 0);
        }
        linkedList = result;
        return linkedList;
    }

    public void buildTrace(List<String> trace, Object element, int inc) {
        if (element instanceof RuleApplicationTrace) {
            for (Object e : ((RuleApplicationTrace)element).trace) {
                this.buildTrace(trace, e, inc + 1);
            }
        } else {
            String string = this.increment(inc);
            String string2 = this.removeIndentation(element.toString());
            String string3 = String.valueOf(string) + string2;
            trace.add(string3);
        }
    }

    public String traceAsString(RuleApplicationTrace ruleTrace) {
        return IterableExtensions.join(this.traceAsStrings(ruleTrace), (CharSequence)"\n");
    }

    public String increment(int inc) {
        String string = null;
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < inc) {
            buffer.append(" ");
            ++i;
        }
        string = buffer.toString();
        return string;
    }

    public LinkedList<ErrorInformation> allErrorInformation(RuleFailedException e) {
        LinkedList linkedList = null;
        LinkedList list = Lists.newLinkedList(e.errorInformations);
        RuleFailedException ex = e.previous;
        while (ex != null) {
            list.addAll(ex.errorInformations);
            ex = ex.previous;
        }
        linkedList = list;
        return linkedList;
    }

    public List<ErrorInformation> removeDuplicateErrorInformation(Iterable<ErrorInformation> errorInformations) {
        LinkedList<ErrorInformation> linkedList = null;
        LinkedList<ErrorInformation> noDuplicates = new LinkedList<ErrorInformation>();
        for (ErrorInformation errorInformation : errorInformations) {
            boolean bl;
            Functions.Function1 function1 = it -> Objects.equal((Object)it.getSource(), (Object)errorInformation.getSource()) && Objects.equal((Object)it.getFeature(), (Object)errorInformation.getFeature()) && Objects.equal((Object)it.getData(), (Object)errorInformation.getData());
            boolean bl2 = IterableExtensions.exists(noDuplicates, (Functions.Function1)function1);
            boolean bl3 = bl = !bl2;
            if (!bl) continue;
            noDuplicates.add(errorInformation);
        }
        linkedList = noDuplicates;
        return linkedList;
    }

    public LinkedList<ErrorInformation> removeNonNodeModelSources(Iterable<ErrorInformation> errorInformations) {
        Functions.Function1 function1 = it -> {
            ICompositeNode iCompositeNode = NodeModelUtils.getNode((EObject)it.getSource());
            return iCompositeNode != null;
        };
        return Lists.newLinkedList((Iterable)IterableExtensions.filter(errorInformations, (Functions.Function1)function1));
    }

    public LinkedList<ErrorInformation> filteredErrorInformation(RuleFailedException e) {
        return this.removeNonNodeModelSources(this.removeDuplicateErrorInformation(this.allErrorInformation(e)));
    }

    public RuleFailedException innermostRuleFailedExceptionWithNodeModelSources(RuleFailedException e) {
        Functions.Function1 function1 = it -> {
            boolean bl = this.filteredErrorInformation((RuleFailedException)it).isEmpty();
            return !bl;
        };
        return (RuleFailedException)IterableExtensions.findLast(this.failureAsList(e), (Functions.Function1)function1);
    }

    public String removeIndentation(String s) {
        return Strings.removeLeadingWhitespace((String)s);
    }

    public Object lastElementNotTrace(RuleApplicationTrace trace) {
        Functions.Function1 function1 = it -> !(it instanceof RuleApplicationTrace);
        return IterableExtensions.findLast(trace.trace, (Functions.Function1)function1);
    }
}

