/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsemantics.runtime;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xsemantics.runtime.RuleApplicationTrace;
import org.eclipse.xsemantics.runtime.RuleEnvironment;
import org.eclipse.xsemantics.runtime.XsemanticsCache;
import org.eclipse.xsemantics.runtime.XsemanticsCacheListener;
import org.eclipse.xsemantics.runtime.XsemanticsCachedData;
import org.eclipse.xsemantics.runtime.XsemanticsProvider;
import org.eclipse.xsemantics.runtime.caching.util.XsemanticsCacheUtils;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

@Singleton
public class XsemanticsCacheDefaultImpl
implements XsemanticsCache {
    @Inject
    private IResourceScopeCache cache;
    @Inject
    private XsemanticsCacheUtils cacheUtils;
    protected String cachedString = "cached:";
    private List<XsemanticsCacheListener> listeners = new ArrayList<XsemanticsCacheListener>();

    @Override
    public <T> T get(String methodName, RuleEnvironment environment, RuleApplicationTrace trace, XsemanticsProvider<T> provider, Object ... elements) {
        XsemanticsCachedData cached;
        block4: {
            block3: {
                cached = (XsemanticsCachedData)this.internalGet(methodName, provider, elements);
                if (provider.isCalled()) break block3;
                for (XsemanticsCacheListener l : this.listeners) {
                    l.cacheHit(cached);
                }
                if (environment != null && environment != cached.getEnvironment()) {
                    environment.increment(cached.getEnvironment());
                }
                if (trace == null || trace == cached.getTrace()) break block4;
                trace.addToTrace(this.cachedString);
                if (cached.getTrace() == null) break block4;
                trace.addObjectAsSubtrace(this.lastElementNotTrace(cached.getTrace()));
                break block4;
            }
            cached.setName(methodName);
            for (XsemanticsCacheListener l : this.listeners) {
                l.cacheMissed(cached);
            }
        }
        return cached.getResult();
    }

    protected <T> T internalGet(String methodName, Provider<T> provider, Object ... elements) {
        return (T)this.cache.get((Object)Pair.of((Object)methodName, (Object)this.cacheUtils.getKeys(elements)), this.cacheUtils.getResource(elements), provider);
    }

    @Override
    public void addListener(XsemanticsCacheListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListener(XsemanticsCacheListener l) {
        this.listeners.remove(l);
    }

    private Object lastElementNotTrace(RuleApplicationTrace trace) {
        return IterableExtensions.findLast(trace.trace, (Functions.Function1)new Functions.Function1<Object, Boolean>(){

            public Boolean apply(Object it) {
                return !(it instanceof RuleApplicationTrace);
            }
        });
    }
}

