/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.serializer.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.TextRegionAccessBuilder;
import org.eclipse.xtext.ide.serializer.hooks.IEObjectDescriptionProvider;
import org.eclipse.xtext.ide.serializer.hooks.IEObjectSnapshot;
import org.eclipse.xtext.ide.serializer.hooks.IReferenceSnapshot;
import org.eclipse.xtext.ide.serializer.hooks.IResourceSnapshot;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceDescriptionsProvider;
import org.eclipse.xtext.resource.XtextResource;

public class EObjectSnapshotProvider {
    @Inject
    private IEObjectDescriptionProvider descriptionProvider;
    @Inject
    private IResourceDescriptionsProvider resourceDescriptionsProvider;
    @Inject
    private Provider<TextRegionAccessBuilder> textRegionBuilderProvider;

    protected Map<EObject, IEObjectSnapshot> createEObjectSnapshots(Resource resource) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (IEObjectDescription desc : this.descriptionProvider.getEObjectDescriptions(resource)) {
            EObject obj = EcoreUtil.resolve((EObject)desc.getEObjectOrProxy(), (Resource)resource);
            EObjectSnapshot snapshot = this.getOrCreate(result, obj);
            snapshot.descriptions.add(desc);
        }
        ResourceSet resourceSet = resource.getResourceSet();
        IResourceDescriptions descriptions = this.resourceDescriptionsProvider.getResourceDescriptions(resourceSet);
        URI uri = resource.getURI();
        for (IResourceDescription desc : descriptions.getAllResourceDescriptions()) {
            for (IReferenceDescription ref : desc.getReferenceDescriptions()) {
                EObject target;
                URI targetURI = ref.getTargetEObjectUri();
                URI sourceEObjectUri = ref.getSourceEObjectUri();
                EReference reference = ref.getEReference();
                if (targetURI == null || sourceEObjectUri == null || reference == null || !uri.equals(targetURI.trimFragment()) || (target = resource.getEObject(targetURI.fragment())) == null || target.eIsProxy()) continue;
                EObjectSnapshot snapshot = this.getOrCreate(result, target);
                ReferenceSnapshot rd = new ReferenceSnapshot(sourceEObjectUri, snapshot, reference, ref.getIndexInList(), ref.getContainerEObjectURI());
                snapshot.incomingReferences.add(rd);
            }
        }
        return result;
    }

    public IResourceSnapshot createResourceSnapshot(Resource resource, boolean recordReferences) {
        return new ResourceSnapshot(this, resource, recordReferences);
    }

    protected EObjectSnapshot getOrCreate(Map<EObject, IEObjectSnapshot> map, EObject obj) {
        IEObjectSnapshot result = map.get(obj);
        if (result == null) {
            result = new EObjectSnapshot(obj);
            map.put(obj, result);
        }
        return (EObjectSnapshot)result;
    }

    protected ITextRegionAccess getTextRegionAccess(Resource res) {
        if (res instanceof XtextResource) {
            return ((TextRegionAccessBuilder)this.textRegionBuilderProvider.get()).forNodeModel((XtextResource)res).create();
        }
        return null;
    }

    public static class ResourceSnapshot
    implements IResourceSnapshot {
        protected final Map<EObject, IEObjectSnapshot> objects;
        protected final ITextRegionAccess regions;
        protected final Resource resource;
        protected final URI uri;

        public ResourceSnapshot(EObjectSnapshotProvider strategy, Resource resource, boolean recordReferences) {
            this.resource = resource;
            this.regions = strategy.getTextRegionAccess(resource);
            this.objects = recordReferences ? strategy.createEObjectSnapshots(resource) : Collections.emptyMap();
            this.uri = resource.getURI();
        }

        @Override
        public Map<EObject, IEObjectSnapshot> getObjects() {
            return this.objects;
        }

        @Override
        public ITextRegionAccess getRegions() {
            return this.regions;
        }

        @Override
        public Resource getResource() {
            return this.resource;
        }

        @Override
        public URI getURI() {
            return this.uri;
        }

        public String toString() {
            ArrayList result = Lists.newArrayList();
            result.add(this.getClass().getSimpleName() + ": " + this.uri);
            for (IEObjectSnapshot obj : this.objects.values()) {
                String value = obj.toString();
                if (value.contains("\n")) {
                    result.add("{\n  " + value.replace("\n", "\n  ") + "\n}");
                    continue;
                }
                result.add(value);
            }
            return Joiner.on((String)"\n").join((Iterable)result);
        }
    }

    public static class ReferenceSnapshot
    implements IReferenceSnapshot {
        private URI containerEObjectURI;
        private EReference eReference;
        private int indexInList = -1;
        private URI sourceEObjectUri;
        private IEObjectSnapshot targetEObject;

        public ReferenceSnapshot(URI sourceEObjectUri, IEObjectSnapshot targetEObject, EReference eReference, int indexInList, URI containerEObjectURI) {
            this.indexInList = indexInList;
            this.sourceEObjectUri = sourceEObjectUri;
            this.targetEObject = targetEObject;
            this.eReference = eReference;
            this.containerEObjectURI = containerEObjectURI;
        }

        @Override
        public URI getContainerEObjectURI() {
            return this.containerEObjectURI;
        }

        @Override
        public EReference getEReference() {
            return this.eReference;
        }

        @Override
        public int getIndexInList() {
            return this.indexInList;
        }

        @Override
        public URI getSourceEObjectUri() {
            return this.sourceEObjectUri;
        }

        @Override
        public IEObjectSnapshot getTarget() {
            return this.targetEObject;
        }

        public String toString() {
            String cls = this.eReference.getEContainingClass().getName();
            String ref = cls + "." + this.eReference.getName() + ":" + this.eReference.getEReferenceType().getName();
            List<IEObjectDescription> descs = this.targetEObject.getDescriptions();
            Object target = descs.size() == 0 ? EcoreUtil.getURI((EObject)this.targetEObject.getObject()).toString() : (descs.size() == 1 ? descs.get(0).toString() : "[" + Joiner.on((String)", ").join(descs) + "]");
            return ref + " @ " + this.sourceEObjectUri + " -> " + (String)target;
        }
    }

    public static class EObjectSnapshot
    implements IEObjectSnapshot {
        protected List<IEObjectDescription> descriptions = Lists.newArrayList();
        protected List<IReferenceSnapshot> incomingReferences = Lists.newArrayList();
        protected final EObject object;

        public EObjectSnapshot(EObject object) {
            this.object = object;
        }

        @Override
        public List<IEObjectDescription> getDescriptions() {
            return this.descriptions;
        }

        @Override
        public List<IReferenceSnapshot> getIncomingReferences() {
            return this.incomingReferences;
        }

        @Override
        public EObject getObject() {
            return this.object;
        }

        public String toString() {
            ArrayList result = Lists.newArrayList();
            for (IEObjectDescription desc : this.descriptions) {
                result.add(desc.toString());
            }
            for (IReferenceSnapshot ref : this.incomingReferences) {
                EReference eRef = ref.getEReference();
                String cls = eRef.getEContainingClass().getName();
                String refString = cls + "." + eRef.getName() + ":" + eRef.getEReferenceType().getName();
                result.add("<- " + refString + " @ " + ref.getSourceEObjectUri());
            }
            Collections.sort(result);
            return Joiner.on((String)"\n").join((Iterable)result);
        }
    }
}

