/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.ui;

import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringUI;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.xtext.ui.refactoring.impl.Messages;
import org.eclipse.xtext.ui.refactoring.ui.SyncUtil;
import org.eclipse.xtext.ui.refactoring.ui.WorkbenchRunnableAdapter;

public class RenameRefactoringExecuter {
    @Inject
    private IWorkspace workspace;
    @Inject
    private SyncUtil syncUtil;
    private static final Logger LOG = Logger.getLogger(RenameRefactoringExecuter.class);

    protected boolean isApplicable(Shell parent, ProcessorBasedRefactoring refactoring) {
        block3: {
            if (!refactoring.isApplicable()) break block3;
            return true;
        }
        try {
            this.showFatalErrorMessage(parent, "Refactoring is not applicable");
        }
        catch (CoreException e) {
            LOG.error((Object)"Error detecting applicability of refactoring", (Throwable)e);
            this.showFatalErrorMessage(parent, "Cannot apply refactoring. See log for details.");
        }
        return false;
    }

    public void execute(IEditorPart editor, ProcessorBasedRefactoring refactoring) throws InterruptedException {
        Assert.isTrue((Display.getCurrent() != null ? 1 : 0) != 0);
        IWorkbenchWindow window = editor.getSite().getWorkbenchWindow();
        IWorkbench workbench = window.getWorkbench();
        Shell shell = editor.getSite().getShell();
        if (!this.isApplicable(shell, refactoring)) {
            return;
        }
        final IJobManager manager = Job.getJobManager();
        IWorkspaceRoot rule = this.workspace.getRoot();
        try {
            try {
                Runnable r = new Runnable((ISchedulingRule)rule){
                    private final /* synthetic */ ISchedulingRule val$rule;
                    {
                        this.val$rule = iSchedulingRule;
                    }

                    @Override
                    public void run() {
                        manager.beginRule(this.val$rule, null);
                    }
                };
                BusyIndicator.showWhile((Display)shell.getDisplay(), (Runnable)r);
            }
            catch (OperationCanceledException operationCanceledException) {
                manager.endRule((ISchedulingRule)rule);
                refactoring.setValidationContext(null);
                return;
            }
            CheckConditionsAndCreateChangeRunnable checkConditionsRunnable = new CheckConditionsAndCreateChangeRunnable(shell, refactoring);
            refactoring.setValidationContext((Object)shell);
            window.run(false, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(checkConditionsRunnable, (ISchedulingRule)rule, true));
            PerformChangeOperation performChangeOperation = checkConditionsRunnable.getPerformChangeOperation();
            if (performChangeOperation != null) {
                window.run(false, false, (IRunnableWithProgress)new WorkbenchRunnableAdapter((IWorkspaceRunnable)performChangeOperation, (ISchedulingRule)rule, true));
                RefactoringStatus validationStatus = performChangeOperation.getValidationStatus();
                if (validationStatus != null && validationStatus.hasFatalError()) {
                    MessageDialog.openError((Shell)shell, (String)refactoring.getName(), (String)Messages.format("Cannot execute refactoring", validationStatus.getMessageMatchingSeverity(4)));
                    return;
                }
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            throw new InterruptedException();
        }
        catch (InvocationTargetException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            manager.endRule((ISchedulingRule)rule);
            refactoring.setValidationContext(null);
        }
        this.syncUtil.yieldToQueuedDisplayJobs((IProgressMonitor)new NullProgressMonitor());
        this.syncUtil.reconcileAllEditors(workbench, false, (IProgressMonitor)new NullProgressMonitor());
    }

    private void showFatalErrorMessage(Shell parent, String message) {
        MessageDialog.openInformation((Shell)parent, (String)"Rename refactoring", (String)message);
    }

    protected static class CheckConditionsAndCreateChangeRunnable
    implements IWorkspaceRunnable {
        private final Shell shell;
        private final ProcessorBasedRefactoring refactoring;
        private PerformChangeOperation performChangeOperation;

        public CheckConditionsAndCreateChangeRunnable(Shell shell, ProcessorBasedRefactoring refactoring) {
            this.shell = shell;
            this.refactoring = refactoring;
        }

        public void run(IProgressMonitor pm) throws CoreException {
            try {
                pm.beginTask("", 11);
                pm.subTask("");
                final RefactoringStatus status = this.refactoring.checkAllConditions((IProgressMonitor)new SubProgressMonitor(pm, 4, 4));
                if (status.getSeverity() >= 2) {
                    final boolean[] canceled = new boolean[1];
                    this.shell.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            canceled[0] = CheckConditionsAndCreateChangeRunnable.this.showStatusDialog(status);
                        }
                    });
                    if (canceled[0]) {
                        throw new OperationCanceledException();
                    }
                }
                Change change = this.refactoring.createChange((IProgressMonitor)new SubProgressMonitor(pm, 2, 4));
                change.initializeValidationData((IProgressMonitor)new SubProgressMonitor(pm, 1, 4));
                this.performChangeOperation = new PerformChangeOperation(change);
                this.performChangeOperation.setUndoManager(RefactoringCore.getUndoManager(), this.refactoring.getName());
                this.performChangeOperation.setSchedulingRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            }
            finally {
                pm.done();
            }
        }

        protected boolean showStatusDialog(RefactoringStatus status) {
            Dialog dialog = RefactoringUI.createRefactoringStatusDialog((RefactoringStatus)status, (Shell)this.shell, (String)this.refactoring.getName(), (boolean)false);
            return dialog.open() == 1;
        }

        public PerformChangeOperation getPerformChangeOperation() {
            return this.performChangeOperation;
        }
    }
}

