/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lib.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

@Beta
public class ReflectExtensions {
    public void set(Object receiver, String fieldName, Object value) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Preconditions.checkNotNull((Object)receiver, (Object)"receiver");
        Preconditions.checkNotNull((Object)fieldName, (Object)"fieldName");
        Class<?> clazz = receiver.getClass();
        Field f = this.getDeclaredField(clazz, fieldName);
        if (!f.canAccess(receiver)) {
            f.setAccessible(true);
        }
        f.set(receiver, value);
    }

    public <T> T get(Object receiver, String fieldName) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Preconditions.checkNotNull((Object)receiver, (Object)"receiver");
        Preconditions.checkNotNull((Object)fieldName, (Object)"fieldName");
        Class<?> clazz = receiver.getClass();
        Field f = this.getDeclaredField(clazz, fieldName);
        if (!f.canAccess(receiver)) {
            f.setAccessible(true);
        }
        return (T)f.get(receiver);
    }

    private Field getDeclaredField(Class<?> clazz, String name) throws NoSuchFieldException {
        NoSuchFieldException initialException = null;
        while (true) {
            try {
                Field f = clazz.getDeclaredField(name);
                return f;
            }
            catch (NoSuchFieldException noSuchField) {
                if (initialException != null) continue;
                initialException = noSuchField;
                if ((clazz = clazz.getSuperclass()) != null) continue;
                throw initialException;
            }
            break;
        }
    }

    public Object invoke(Object receiver, String methodName, Object ... args) throws SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Preconditions.checkNotNull((Object)receiver, (Object)"receiver");
        Preconditions.checkNotNull((Object)methodName, (Object)"methodName");
        Object[] arguments = args == null ? new Object[1] : args;
        Class<?> clazz = receiver.getClass();
        Method compatible = null;
        do {
            Method[] methodArray = clazz.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method candidate = methodArray[n2];
                if (candidate != null && !candidate.isBridge() && this.isCompatible(candidate, methodName, arguments)) {
                    if (compatible != null) {
                        throw new IllegalStateException("Ambiguous methods to invoke. Both " + compatible + " and  " + candidate + " would be compatible choices.");
                    }
                    compatible = candidate;
                }
                ++n2;
            }
        } while (compatible == null && (clazz = clazz.getSuperclass()) != null);
        if (compatible != null) {
            boolean isStatic = Modifier.isStatic(compatible.getModifiers());
            if (isStatic) {
                if (!compatible.canAccess(null)) {
                    compatible.setAccessible(true);
                }
            } else if (!compatible.canAccess(receiver)) {
                compatible.setAccessible(true);
            }
            return compatible.invoke(receiver, arguments);
        }
        Class[] paramTypes = new Class[arguments.length];
        int i = 0;
        while (i < arguments.length) {
            paramTypes[i] = arguments[i] == null ? Object.class : arguments[i].getClass();
            ++i;
        }
        Method method = receiver.getClass().getMethod(methodName, paramTypes);
        return method.invoke(receiver, arguments);
    }

    private boolean isCompatible(Method candidate, String featureName, Object ... args) {
        if (!candidate.getName().equals(featureName)) {
            return false;
        }
        if (candidate.getParameterTypes().length != args.length) {
            return false;
        }
        int i = 0;
        while (i < candidate.getParameterTypes().length) {
            Object param = args[i];
            Class<?> class1 = candidate.getParameterTypes()[i];
            if (class1.isPrimitive()) {
                class1 = this.wrapperTypeFor(class1);
            }
            if (param != null && !class1.isInstance(param)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private Class<?> wrapperTypeFor(Class<?> primitive) {
        Preconditions.checkNotNull(primitive);
        if (primitive == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitive == Byte.TYPE) {
            return Byte.class;
        }
        if (primitive == Character.TYPE) {
            return Character.class;
        }
        if (primitive == Short.TYPE) {
            return Short.class;
        }
        if (primitive == Integer.TYPE) {
            return Integer.class;
        }
        if (primitive == Long.TYPE) {
            return Long.class;
        }
        if (primitive == Float.TYPE) {
            return Float.class;
        }
        if (primitive == Double.TYPE) {
            return Double.class;
        }
        if (primitive == Void.TYPE) {
            return Void.class;
        }
        throw new IllegalArgumentException(primitive + " is not a primitive");
    }
}

