/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend2.lib;

import com.google.common.annotations.GwtCompatible;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtend2.lib.DefaultLineDelimiter;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtend2.lib.WhitespaceMatcher;

@GwtCompatible
public class StringConcatenation
implements CharSequence {
    public static final String DEFAULT_LINE_DELIMITER = DefaultLineDelimiter.get();
    private final ArrayList<String> segments;
    private String cachedToString;
    private final String lineDelimiter;

    public StringConcatenation() {
        this(DEFAULT_LINE_DELIMITER);
    }

    public StringConcatenation(String lineDelimiter) {
        if (lineDelimiter == null || lineDelimiter.length() == 0) {
            throw new IllegalArgumentException("lineDelimiter must not be null or empty");
        }
        this.lineDelimiter = lineDelimiter;
        this.segments = new ArrayList(50);
    }

    public void append(Object object) {
        this.append(object, this.segments.size());
    }

    protected void append(Object object, int index) {
        if (object == null) {
            return;
        }
        if (object instanceof StringConcatenation) {
            StringConcatenation other = (StringConcatenation)object;
            this.appendSegments(index, other.getSignificantContent(), other.lineDelimiter);
            return;
        }
        if (object instanceof StringConcatenationClient) {
            StringConcatenationClient other = (StringConcatenationClient)object;
            other.appendTo(new SimpleTarget(this, index, null, null));
            return;
        }
        String value = this.getStringRepresentation(object);
        List<String> newSegments = this.splitLinesAndNewLines(value);
        this.appendSegments(index, newSegments, this.lineDelimiter);
    }

    public void append(Object object, String indentation) {
        this.append(object, indentation, this.segments.size());
    }

    protected void append(Object object, String indentation, int index) {
        if (indentation.length() == 0) {
            this.append(object, index);
            return;
        }
        if (object == null) {
            return;
        }
        if (object instanceof StringConcatenation) {
            StringConcatenation other = (StringConcatenation)object;
            List<String> otherSegments = other.getSignificantContent();
            this.appendSegments(indentation, index, otherSegments, other.lineDelimiter);
        } else if (object instanceof StringConcatenationClient) {
            StringConcatenationClient other = (StringConcatenationClient)object;
            other.appendTo(new IndentedTarget(this, indentation, index));
        } else {
            String value = this.getStringRepresentation(object);
            List<String> newSegments = this.splitLinesAndNewLines(value);
            this.appendSegments(indentation, index, newSegments, this.lineDelimiter);
        }
    }

    protected String getStringRepresentation(Object object) {
        return object.toString();
    }

    public void appendImmediate(Object object, String indentation) {
        int i = this.segments.size() - 1;
        while (i >= 0) {
            String segment = this.segments.get(i);
            int j = 0;
            while (j < segment.length()) {
                if (!WhitespaceMatcher.isWhitespace(segment.charAt(j))) {
                    this.append(object, indentation, i + 1);
                    return;
                }
                ++j;
            }
            --i;
        }
        this.append(object, indentation, 0);
    }

    protected void appendSegments(String indentation, int index, List<String> otherSegments, String otherDelimiter) {
        if (otherSegments.isEmpty()) {
            return;
        }
        for (String otherSegment : otherSegments) {
            if (otherDelimiter.equals(otherSegment)) {
                this.segments.add(index++, this.lineDelimiter);
                this.segments.add(index++, indentation);
                continue;
            }
            this.segments.add(index++, otherSegment);
        }
        this.cachedToString = null;
    }

    protected void appendSegments(int index, List<String> otherSegments, String otherDelimiter) {
        if (otherDelimiter.equals(this.lineDelimiter)) {
            this.appendSegments(index, otherSegments);
        } else {
            if (otherSegments.isEmpty()) {
                return;
            }
            this.segments.ensureCapacity(index + otherSegments.size());
            for (String otherSegment : otherSegments) {
                if (otherDelimiter.equals(otherSegment)) {
                    this.segments.add(index++, this.lineDelimiter);
                    continue;
                }
                this.segments.add(index++, otherSegment);
            }
            this.cachedToString = null;
        }
    }

    protected void appendSegments(int index, List<String> otherSegments) {
        if (this.segments.addAll(index, otherSegments)) {
            this.cachedToString = null;
        }
    }

    public void newLine() {
        this.segments.add(this.lineDelimiter);
        this.cachedToString = null;
    }

    public void newLineIfNotEmpty() {
        int i = this.segments.size() - 1;
        while (i >= 0) {
            String segment = this.segments.get(i);
            if (this.lineDelimiter.equals(segment)) {
                this.segments.subList(i + 1, this.segments.size()).clear();
                this.cachedToString = null;
                return;
            }
            int j = 0;
            while (j < segment.length()) {
                if (!WhitespaceMatcher.isWhitespace(segment.charAt(j))) {
                    this.newLine();
                    return;
                }
                ++j;
            }
            --i;
        }
        this.segments.clear();
        this.cachedToString = null;
    }

    @Override
    public String toString() {
        if (this.cachedToString != null) {
            return this.cachedToString;
        }
        List<String> significantContent = this.getSignificantContent();
        StringBuilder builder = new StringBuilder(significantContent.size() * 4);
        for (String segment : significantContent) {
            builder.append(segment);
        }
        this.cachedToString = builder.toString();
        return this.cachedToString;
    }

    protected final List<String> getContent() {
        return this.segments;
    }

    protected List<String> getSignificantContent() {
        int i = this.segments.size() - 1;
        while (i >= 0) {
            String segment = this.segments.get(i);
            if (this.lineDelimiter.equals(segment)) {
                return this.segments.subList(0, i + 1);
            }
            int j = 0;
            while (j < segment.length()) {
                if (!WhitespaceMatcher.isWhitespace(segment.charAt(j))) {
                    return this.segments;
                }
                ++j;
            }
            --i;
        }
        return this.segments;
    }

    protected String getLineDelimiter() {
        return this.lineDelimiter;
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    protected List<String> splitLinesAndNewLines(String text) {
        if (text == null) {
            return Collections.emptyList();
        }
        int length = text.length();
        int nextLineOffset = 0;
        int idx = 0;
        while (idx < length) {
            char currentChar = text.charAt(idx);
            if (currentChar == '\r' || currentChar == '\n') break;
            ++idx;
        }
        if (idx == length) {
            return Collections.singletonList(text);
        }
        ArrayList<String> result = new ArrayList<String>(5);
        while (idx < length) {
            char currentChar = text.charAt(idx);
            if (currentChar == '\r') {
                int delimiterLength = 1;
                if (idx + 1 < length && text.charAt(idx + 1) == '\n') {
                    ++delimiterLength;
                    ++idx;
                }
                int lineLength = idx - delimiterLength - nextLineOffset + 1;
                result.add(text.substring(nextLineOffset, nextLineOffset + lineLength));
                result.add(this.lineDelimiter);
                nextLineOffset = idx + 1;
            } else if (currentChar == '\n') {
                int lineLength = idx - nextLineOffset;
                result.add(text.substring(nextLineOffset, nextLineOffset + lineLength));
                result.add(this.lineDelimiter);
                nextLineOffset = idx + 1;
            }
            ++idx;
        }
        if (nextLineOffset != length) {
            int lineLength = length - nextLineOffset;
            result.add(text.substring(nextLineOffset, nextLineOffset + lineLength));
        }
        return result;
    }

    private static class IndentedTarget
    extends SimpleTarget {
        private final String indentation;

        private IndentedTarget(StringConcatenation target, String indentation, int index) {
            super(target, index);
            this.indentation = indentation;
        }

        @Override
        public void newLineIfNotEmpty() {
            super.newLineIfNotEmpty();
            super.append(this.indentation);
        }

        @Override
        public void newLine() {
            super.newLine();
            super.append(this.indentation);
        }

        @Override
        public void appendImmediate(Object object, String indentation) {
            super.appendImmediate(object, String.valueOf(this.indentation) + indentation);
        }

        @Override
        public void append(Object object, String indentation) {
            super.append(object, String.valueOf(this.indentation) + indentation);
        }

        @Override
        public void append(Object object) {
            super.append(object, this.indentation);
        }
    }

    private static class SimpleTarget
    implements StringConcatenationClient.TargetStringConcatenation {
        private final StringConcatenation target;
        private final int offsetFixup;

        private SimpleTarget(StringConcatenation target, int index) {
            this.target = target;
            this.offsetFixup = target.segments.size() - index;
        }

        @Override
        public int length() {
            return this.target.length();
        }

        @Override
        public char charAt(int index) {
            return this.target.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.target.subSequence(start, end);
        }

        @Override
        public void newLineIfNotEmpty() {
            this.target.newLineIfNotEmpty();
        }

        @Override
        public void newLine() {
            this.target.newLine();
        }

        @Override
        public void appendImmediate(Object object, String indentation) {
            this.target.appendImmediate(object, indentation);
        }

        @Override
        public void append(Object object, String indentation) {
            if (this.offsetFixup == 0) {
                this.target.append(object, indentation);
            } else {
                this.target.append(object, indentation, this.target.segments.size() - this.offsetFixup);
            }
        }

        @Override
        public void append(Object object) {
            this.target.append(object, this.target.segments.size() - this.offsetFixup);
        }

        /* synthetic */ SimpleTarget(StringConcatenation stringConcatenation, int n, SimpleTarget simpleTarget, SimpleTarget simpleTarget2) {
            this(stringConcatenation, n);
        }
    }
}

