/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmBooleanAnnotationValue;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.access.TypeResource;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.util.XExpressionHelper;
import org.eclipse.xtext.xbase.validation.NotResolvedFeatureException;

public class ConstantExpressionValidator {
    @Inject
    @Extension
    private TypeReferences _typeReferences;
    @Inject
    @Extension
    private Primitives _primitives;
    @Inject
    @Extension
    private XExpressionHelper _xExpressionHelper;
    @Inject
    @Extension
    private ILogicalContainerProvider _iLogicalContainerProvider;

    protected boolean _isConstant(XExpression expression) {
        return false;
    }

    protected boolean _isConstant(XStringLiteral expression) {
        return true;
    }

    protected boolean _isConstant(XTypeLiteral expression) {
        return true;
    }

    protected boolean _isConstant(XNumberLiteral expression) {
        return true;
    }

    protected boolean _isConstant(XBooleanLiteral expression) {
        return true;
    }

    protected boolean _isConstant(XCastedExpression expression) {
        return this._primitives.isPrimitive(expression.getType()) || this._typeReferences.is(expression.getType(), String.class);
    }

    protected boolean _isConstant(XAbstractFeatureCall expression) {
        boolean _eIsProxy;
        JvmIdentifiableElement _feature;
        JvmIdentifiableElement feature = _feature = expression.getFeature();
        boolean _matched = false;
        if (feature instanceof JvmEnumerationLiteral) {
            _matched = true;
            return true;
        }
        if (!_matched && feature instanceof JvmField) {
            boolean potentiallyConstant;
            _matched = true;
            boolean _isSetConstant = ((JvmField)feature).isSetConstant();
            if (_isSetConstant) {
                return ((JvmField)feature).isConstant();
            }
            boolean bl = potentiallyConstant = ((JvmField)feature).isStatic() && ((JvmField)feature).isFinal();
            if (potentiallyConstant) {
                Resource _eResource = ((JvmField)feature).eResource();
                if (_eResource instanceof TypeResource) {
                    return true;
                }
                XExpression _associatedExpression = this._iLogicalContainerProvider.getAssociatedExpression(feature);
                return this.isConstantExpression(_associatedExpression);
            }
            return false;
        }
        if (!_matched && feature instanceof JvmOperation) {
            Functions.Function1 _function;
            _matched = true;
            JvmAnnotationReference annotationReference = this._xExpressionHelper.findInlineAnnotation(expression);
            if (annotationReference == null) {
                return false;
            }
            EList _values = annotationReference.getValues();
            Iterable _filter = Iterables.filter((Iterable)_values, JvmBooleanAnnotationValue.class);
            boolean _exists = IterableExtensions.exists((Iterable)_filter, (Functions.Function1)(_function = it -> Objects.equal((Object)it.getValueName(), (Object)"constantExpression") && (Boolean)IterableExtensions.head((Iterable)it.getValues()) != false));
            if (_exists) {
                boolean _tripleEquals;
                boolean _xifexpression = false;
                XExpression _actualReceiver = expression.getActualReceiver();
                boolean bl = _tripleEquals = _actualReceiver == null;
                if (_tripleEquals) {
                    _xifexpression = true;
                } else {
                    XExpression _actualReceiver_1 = expression.getActualReceiver();
                    _xifexpression = this.isConstant(_actualReceiver_1);
                }
                boolean receiverConstant = _xifexpression;
                return receiverConstant && IterableExtensions.forall(expression.getActualArguments(), it -> this.isConstant((XExpression)it));
            }
        }
        if (!_matched && feature instanceof XVariableDeclaration) {
            _matched = true;
            return !((XVariableDeclaration)feature).isWriteable() && this.isConstantExpression(((XVariableDeclaration)feature).getRight());
        }
        if (!_matched && feature instanceof XSwitchExpression) {
            _matched = true;
            XExpression _switch = ((XSwitchExpression)feature).getSwitch();
            return this.isConstantExpression(_switch);
        }
        if (!_matched && feature instanceof EObject && (_eIsProxy = feature.eIsProxy())) {
            _matched = true;
            throw new NotResolvedFeatureException();
        }
        return false;
    }

    protected boolean _isConstantExpression(Void it) {
        return false;
    }

    protected boolean _isConstantExpression(XExpression it) {
        return this.isConstant(it);
    }

    protected boolean _isConstantExpression(XAbstractFeatureCall it) {
        boolean _switchResult = false;
        JvmIdentifiableElement _feature = it.getFeature();
        boolean _matched = false;
        if (_feature instanceof JvmEnumerationLiteral) {
            _matched = true;
            _switchResult = false;
        }
        if (!_matched) {
            _switchResult = this.isConstant(it);
        }
        return _switchResult;
    }

    public boolean isConstant(XExpression expression) {
        if (expression instanceof XAbstractFeatureCall) {
            return this._isConstant((XAbstractFeatureCall)expression);
        }
        if (expression instanceof XBooleanLiteral) {
            return this._isConstant((XBooleanLiteral)expression);
        }
        if (expression instanceof XCastedExpression) {
            return this._isConstant((XCastedExpression)expression);
        }
        if (expression instanceof XNumberLiteral) {
            return this._isConstant((XNumberLiteral)expression);
        }
        if (expression instanceof XStringLiteral) {
            return this._isConstant((XStringLiteral)expression);
        }
        if (expression instanceof XTypeLiteral) {
            return this._isConstant((XTypeLiteral)expression);
        }
        if (expression != null) {
            return this._isConstant(expression);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expression).toString());
    }

    public boolean isConstantExpression(XExpression it) {
        if (it instanceof XAbstractFeatureCall) {
            return this._isConstantExpression((XAbstractFeatureCall)it);
        }
        if (it != null) {
            return this._isConstantExpression(it);
        }
        if (it == null) {
            return this._isConstantExpression((Void)null);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }
}

