/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class UniqueClassNameValidator
extends AbstractDeclarativeValidator {
    @Inject
    private ResourceDescriptionsProvider resourceDescriptionsProvider;
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private IJvmModelAssociations associations;

    public void register(EValidatorRegistrar registrar) {
    }

    @Inject
    protected void register(EValidatorRegistrar registrar, IGrammarAccess grammarAccess) {
        Grammar _grammar = grammarAccess.getGrammar();
        EList _rules = _grammar.getRules();
        AbstractRule entryRule = (AbstractRule)IterableExtensions.head((Iterable)_rules);
        if (entryRule instanceof ParserRule) {
            TypeRef _type = ((ParserRule)entryRule).getType();
            EClassifier _classifier = _type.getClassifier();
            EPackage _ePackage = _classifier.getEPackage();
            registrar.register(_ePackage, (EValidator)this);
        }
    }

    @Check
    public void checkUniqueName(EObject root) {
        Resource resource;
        EList _contents;
        EObject _head;
        boolean _equals;
        boolean _tripleEquals;
        EObject _eContainer = root.eContainer();
        boolean bl = _tripleEquals = _eContainer == null;
        if (_tripleEquals && (_equals = Objects.equal((Object)(_head = (EObject)IterableExtensions.head((Iterable)(_contents = (resource = root.eResource()).getContents()))), (Object)root))) {
            EList _contents_1 = resource.getContents();
            Iterable _filter = Iterables.filter((Iterable)_contents_1, JvmDeclaredType.class);
            Consumer<JvmDeclaredType> _function = it -> this.doCheckUniqueName((JvmDeclaredType)it);
            _filter.forEach(_function);
        }
    }

    protected void doCheckUniqueName(JvmDeclaredType type) {
        QualifiedName name;
        boolean _tripleEquals;
        EObject _eContainer = type.eContainer();
        boolean bl = _tripleEquals = _eContainer == null;
        if (_tripleEquals && (name = this.qualifiedNameProvider.getFullyQualifiedName((EObject)type)) != null) {
            this.doCheckUniqueName(name, type);
        }
    }

    protected boolean doCheckUniqueName(QualifiedName name, JvmDeclaredType type) {
        Resource _eResource = type.eResource();
        IResourceDescriptions index = this.resourceDescriptionsProvider.getResourceDescriptions(_eResource);
        Iterable others = index.getExportedObjects(TypesPackage.Literals.JVM_DECLARED_TYPE, name, false);
        return this.checkUniqueInIndex(type, others);
    }

    protected boolean checkUniqueInIndex(JvmDeclaredType type, Iterable<IEObjectDescription> descriptions) {
        boolean _greaterThan;
        Functions.Function1 _function = it -> {
            URI _eObjectURI = it.getEObjectURI();
            return _eObjectURI.trimFragment();
        };
        Iterable _map = IterableExtensions.map(descriptions, (Functions.Function1)_function);
        Set resourceURIs = IterableExtensions.toSet((Iterable)_map);
        int _size = resourceURIs.size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            Functions.Function1 _function_1 = it -> {
                Resource _eResource = type.eResource();
                URI _uRI = _eResource.getURI();
                return !Objects.equal((Object)it, (Object)_uRI);
            };
            Iterable _filter = IterableExtensions.filter((Iterable)resourceURIs, (Functions.Function1)_function_1);
            URI _head = (URI)IterableExtensions.head((Iterable)_filter);
            String _lastSegment = _head.lastSegment();
            this.addIssue(type, _lastSegment);
            return false;
        }
        return true;
    }

    protected void addIssue(JvmDeclaredType type, String fileName) {
        EObject sourceElement = this.associations.getPrimarySourceElement((EObject)type);
        if (sourceElement == null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("The type ");
            String _simpleName = type.getSimpleName();
            _builder.append(_simpleName, "");
            _builder.append(" is already defined in ");
            _builder.append(fileName, "");
            _builder.append(".");
            this.addIssue(_builder.toString(), (EObject)type, "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_type");
        } else {
            EClass _eClass = sourceElement.eClass();
            EStructuralFeature feature = _eClass.getEStructuralFeature("name");
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("The type ");
            String _simpleName_1 = type.getSimpleName();
            _builder_1.append(_simpleName_1, "");
            _builder_1.append(" is already defined in ");
            _builder_1.append(fileName, "");
            _builder_1.append(".");
            this.addIssue(_builder_1.toString(), sourceElement, feature, "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_type", new String[0]);
        }
    }
}

