/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationValue;
import org.eclipse.xtext.common.types.JvmBooleanAnnotationValue;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmStringAnnotationValue;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeAnnotationValue;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVoid;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.util.ITypeArgumentContext;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.TypeArgumentContextProvider;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.LocationData;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.TextRegionWithLineInformation;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XUnaryOperation;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.compiler.Later;
import org.eclipse.xtext.xbase.compiler.LiteralsCompiler;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.featurecalls.IdentifiableSimpleNameProvider;
import org.eclipse.xtext.xbase.impl.FeatureCallToJavaMapping;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typing.JvmOnlyTypeConformanceComputer;
import org.eclipse.xtext.xbase.typing.XbaseTypeArgumentContextProvider;
import org.eclipse.xtext.xbase.util.XExpressionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class FeatureCallCompiler
extends LiteralsCompiler {
    @Inject
    private FeatureCallToJavaMapping featureCallToJavaMapping;
    @Inject
    private IdentifiableSimpleNameProvider featureNameProvider;
    @Inject
    private XExpressionHelper expressionHelper;
    @Inject
    private JvmOnlyTypeConformanceComputer jvmConformance;
    @Inject
    private Primitives primitives;
    @Inject
    private ILogicalContainerProvider contextProvider;
    @Inject
    private ILocationInFileProvider locationInFileProvider;
    private Pattern pattern = Pattern.compile("\\$(\\$|[0-9]+)");
    @Inject
    IBatchTypeResolver batchTypeResolver;

    @Override
    protected void internalToConvertedExpression(XExpression obj, ITreeAppendable appendable) {
        if (obj instanceof XAbstractFeatureCall) {
            this._toJavaExpression((XAbstractFeatureCall)obj, appendable);
        } else {
            super.internalToConvertedExpression(obj, appendable);
        }
    }

    @Override
    protected void doInternalToJavaStatement(XExpression obj, ITreeAppendable appendable, boolean isReferenced) {
        if (obj instanceof XFeatureCall) {
            this._toJavaStatement((XFeatureCall)obj, appendable, isReferenced);
        } else if (obj instanceof XAbstractFeatureCall) {
            this._toJavaStatement((XAbstractFeatureCall)obj, appendable, isReferenced);
        } else {
            super.doInternalToJavaStatement(obj, appendable, isReferenced);
        }
    }

    protected boolean nullSafeMemberFeatureCallExpressionNeedsPreparation(XExpression argument, ITreeAppendable b) {
        if (b.hasName(argument)) {
            return false;
        }
        return !(argument instanceof JvmField) && !(argument instanceof JvmFormalParameter);
    }

    protected List<XExpression> normalizeBlockExpression(Collection<XExpression> expr) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)expr.size());
        for (XExpression e : expr) {
            result.add(this.normalizeBlockExpression(e));
        }
        return result;
    }

    protected XExpression normalizeBlockExpression(XExpression expr) {
        XBlockExpression block;
        if (expr instanceof XBlockExpression && (block = (XBlockExpression)expr).getExpressions().size() == 1) {
            return this.normalizeBlockExpression((XExpression)block.getExpressions().get(0));
        }
        return expr;
    }

    protected void _toJavaStatement(final XAbstractFeatureCall expr, ITreeAppendable b, boolean isReferenced) {
        if (expr.isTypeLiteral()) {
            this.generateComment(new Later(){

                public void exec(ITreeAppendable appendable) {
                    FeatureCallCompiler.this.internalToJavaExpression(expr, appendable);
                }
            }, b, isReferenced);
        } else if (this.expressionHelper.isShortCircuitOperation(expr)) {
            this.generateShortCircuitInvocation(expr, b);
        } else if (expr instanceof XMemberFeatureCall && ((XMemberFeatureCall)expr).isNullSafe()) {
            this.compileNullSafeFeatureCall((XMemberFeatureCall)expr, b, isReferenced);
        } else {
            XExpression receiver = this.getActualReceiver(expr);
            if (receiver != null) {
                this.prepareExpression(receiver, b);
            }
            for (XExpression arg : this.getActualArguments(expr)) {
                this.prepareExpression(arg, b);
            }
            if (!isReferenced) {
                b.newLine();
                if (!this.expressionHelper.hasSideEffects(expr, false)) {
                    b.append("/* ");
                }
                try {
                    this.featureCalltoJavaExpression(expr, b, false);
                    b.append(";");
                }
                finally {
                    if (!this.expressionHelper.hasSideEffects(expr, false)) {
                        b.append(" */");
                    }
                }
            } else if (this.isVariableDeclarationRequired(expr, b)) {
                Later later = new Later(){

                    public void exec(ITreeAppendable appendable) {
                        FeatureCallCompiler.this.featureCalltoJavaExpression(expr, appendable, true);
                    }
                };
                this.declareFreshLocalVariable(expr, b, later);
            }
        }
    }

    private void compileNullSafeFeatureCall(final XMemberFeatureCall expr, ITreeAppendable b, boolean isReferenced) {
        XExpression memberCallTarget = this.normalizeBlockExpression(expr.getMemberCallTarget());
        if (!isReferenced) {
            if (!this.expressionHelper.hasSideEffects(expr, false)) {
                b.append("/* ");
            }
            try {
                if (this.nullSafeMemberFeatureCallExpressionNeedsPreparation(memberCallTarget, b)) {
                    this.prepareExpression(memberCallTarget, b);
                }
                b.newLine().append("if (");
                this.internalToJavaExpression(memberCallTarget, b);
                b.append("!=null) {").increaseIndentation();
                for (XExpression arg : this.getActualArguments(expr)) {
                    if (!this.nullSafeMemberFeatureCallExpressionNeedsPreparation(arg, b)) continue;
                    this.prepareExpression(arg, b);
                }
                b.newLine();
                this.featureCalltoJavaExpression(expr, b, false);
                b.append(";");
            }
            finally {
                b.decreaseIndentation().newLine().append("}");
                if (!this.expressionHelper.hasSideEffects(expr, false)) {
                    b.append(" */");
                }
            }
        }
        if (this.isVariableDeclarationRequired(expr, b)) {
            Later later = new Later(){

                public void exec(ITreeAppendable appendable) {
                    FeatureCallCompiler.this.appendNullValueUntyped(FeatureCallCompiler.this.getTypeForVariableDeclaration(expr), expr, appendable);
                }
            };
            if (this.nullSafeMemberFeatureCallExpressionNeedsPreparation(memberCallTarget, b)) {
                this.prepareExpression(memberCallTarget, b);
            }
            this.declareFreshLocalVariable(expr, b, later);
            b.newLine().append("if (");
            this.internalToJavaExpression(memberCallTarget, b);
            b.append("!=null) {").increaseIndentation();
            try {
                for (XExpression arg : this.getActualArguments(expr)) {
                    if (!this.nullSafeMemberFeatureCallExpressionNeedsPreparation(arg, b)) continue;
                    this.prepareExpression(arg, b);
                }
                b.newLine();
                b.append(b.getName(expr));
                b.append("=");
                this.featureCalltoJavaExpression(expr, b, true);
                b.append(";");
            }
            finally {
                b.decreaseIndentation().newLine().append("}");
            }
        }
    }

    protected List<XExpression> getActualArguments(XAbstractFeatureCall expr) {
        return this.featureCallToJavaMapping.getActualArguments(expr);
    }

    @Nullable
    protected XExpression getActualReceiver(XAbstractFeatureCall expr) {
        return this.featureCallToJavaMapping.getActualReceiver(expr);
    }

    protected void _toJavaStatement(XFeatureCall expr, ITreeAppendable b, boolean isReferenced) {
        if (expr.getFeature() instanceof JvmConstructor) {
            b.newLine();
            this.featureCalltoJavaExpression(expr, b, false);
            b.append(";");
        } else {
            this._toJavaStatement((XAbstractFeatureCall)expr, b, isReferenced);
        }
    }

    protected void generateShortCircuitInvocation(XAbstractFeatureCall featureCall, ITreeAppendable b) {
        XBinaryOperation binaryOperation = (XBinaryOperation)featureCall;
        XExpression leftOperand = binaryOperation.getLeftOperand();
        XExpression rightOperand = binaryOperation.getRightOperand();
        if (!this.isPreparationRequired(leftOperand, b) && !this.isPreparationRequired(rightOperand, b)) {
            return;
        }
        this.declareSyntheticVariable(binaryOperation, b);
        boolean isElvis = binaryOperation.getConcreteSyntaxFeatureName().equals(this.expressionHelper.getElvisOperator());
        this.prepareExpression(leftOperand, b);
        if (isElvis) {
            b.newLine().append("if (");
            this.toJavaExpression(leftOperand, b);
            b.append(" != null) {").increaseIndentation();
            b.newLine().append(b.getName(binaryOperation)).append(" = ");
            this.toJavaExpression(leftOperand, b);
            b.append(";");
        } else {
            b.newLine().append("if (");
            if (binaryOperation.getConcreteSyntaxFeatureName().equals(this.expressionHelper.getAndOperator())) {
                b.append("!");
            }
            this.toJavaExpression(leftOperand, b);
            b.append(") {").increaseIndentation();
            b.newLine().append(b.getName(binaryOperation)).append(" = ");
            b.append(Boolean.toString(binaryOperation.getConcreteSyntaxFeatureName().equals(this.expressionHelper.getOrOperator()))).append(";");
        }
        b.decreaseIndentation().newLine().append("} else {").increaseIndentation();
        if (binaryOperation.getImplicitReceiver() != null) {
            this.internalToJavaStatement(binaryOperation.getImplicitReceiver(), b, true);
        }
        this.prepareExpression(rightOperand, b);
        b.newLine().append(b.getName(binaryOperation)).append(" = ");
        this.toJavaExpression(rightOperand, b);
        b.append(";");
        b.decreaseIndentation().newLine().append("}");
    }

    @Override
    protected boolean internalCanCompileToJavaExpression(XExpression expression, ITreeAppendable appendable) {
        if (expression instanceof XAbstractFeatureCall) {
            XAbstractFeatureCall featureCall = (XAbstractFeatureCall)expression;
            for (XExpression arg : featureCall.getActualArguments()) {
                if (this.internalCanCompileToJavaExpression(arg, appendable)) continue;
                return false;
            }
            if (featureCall.getActualReceiver() != null && !this.internalCanCompileToJavaExpression(featureCall.getActualReceiver(), appendable)) {
                return false;
            }
            if (featureCall instanceof XMemberFeatureCall) {
                return !((XMemberFeatureCall)featureCall).isNullSafe();
            }
            return true;
        }
        if (expression instanceof XConstructorCall) {
            XConstructorCall constructorCall = (XConstructorCall)expression;
            for (XExpression arg : constructorCall.getArguments()) {
                if (this.internalCanCompileToJavaExpression(arg, appendable)) continue;
                return false;
            }
            return true;
        }
        return super.internalCanCompileToJavaExpression(expression, appendable);
    }

    protected boolean isVariableDeclarationRequired(XMemberFeatureCall expr, ITreeAppendable b) {
        return expr.isNullSafe();
    }

    @Override
    protected boolean isVariableDeclarationRequired(XExpression expr, ITreeAppendable b) {
        if (expr instanceof XAssignment) {
            return true;
        }
        if (expr.eContainingFeature() == XbasePackage.Literals.XMEMBER_FEATURE_CALL__MEMBER_CALL_TARGET && ((XMemberFeatureCall)expr.eContainer()).isNullSafe()) {
            if (expr instanceof XFeatureCall) {
                JvmIdentifiableElement feature = ((XFeatureCall)expr).getFeature();
                if (feature instanceof JvmField || feature instanceof JvmFormalParameter) {
                    return false;
                }
                return !b.hasName(feature);
            }
            return !b.hasName(expr);
        }
        if (expr instanceof XAbstractFeatureCall) {
            XAbstractFeatureCall featureCall = (XAbstractFeatureCall)expr;
            if (featureCall.isTypeLiteral() || featureCall.isPackageFragment()) {
                return false;
            }
            if (featureCall instanceof XBinaryOperation || featureCall instanceof XUnaryOperation) {
                JvmAnnotationReference inlineAnnotation = this.expressionHelper.findInlineAnnotation(featureCall);
                if (inlineAnnotation == null) {
                    return true;
                }
                for (XExpression argument : featureCall.getActualArguments()) {
                    if (!this.isVariableDeclarationRequired(argument, b)) continue;
                    return true;
                }
                for (JvmAnnotationValue value : inlineAnnotation.getValues()) {
                    EList values;
                    if (!(value instanceof JvmBooleanAnnotationValue) || !value.getValueName().equals("constantExpression") || (values = ((JvmBooleanAnnotationValue)value).getValues()).isEmpty()) continue;
                    return (Boolean)values.get(0) == false;
                }
                return true;
            }
            if (featureCall instanceof XMemberFeatureCall && this.isVariableDeclarationRequired((XMemberFeatureCall)featureCall, b)) {
                return true;
            }
            JvmIdentifiableElement feature = featureCall.getFeature();
            if (feature instanceof JvmField || feature instanceof JvmFormalParameter) {
                return false;
            }
            return !b.hasName(feature);
        }
        return super.isVariableDeclarationRequired(expr, b);
    }

    protected void prepareExpression(XExpression arg, ITreeAppendable b) {
        if (arg instanceof XAbstractFeatureCall && !(((XAbstractFeatureCall)arg).getFeature() instanceof JvmField) && !this.isVariableDeclarationRequired(arg, b)) {
            XAbstractFeatureCall featureCall = (XAbstractFeatureCall)arg;
            if (featureCall.getFeature() instanceof XVariableDeclaration) {
                XVariableDeclaration variableDeclaration = (XVariableDeclaration)featureCall.getFeature();
                if (!variableDeclaration.isWriteable()) {
                    this.internalToJavaStatement(arg, b, true);
                    return;
                }
            } else if (featureCall.getFeature() instanceof JvmFormalParameter) {
                this.internalToJavaStatement(arg, b, true);
                return;
            }
            JvmTypeReference expectedType = this.getTypeProvider().getExpectedType(arg);
            JvmTypeReference type = this.getType(arg);
            if (expectedType != null && !this.jvmConformance.isConformant(expectedType, type)) {
                String varName = this.getVarName(((XAbstractFeatureCall)arg).getFeature(), b);
                String finalVariable = b.declareSyntheticVariable(arg, "_converted_" + varName);
                b.newLine().append("final ");
                this.serialize(type, arg, b);
                b.append(" ").append(finalVariable).append(" = ").append("(");
                this.serialize(type, arg, b);
                b.append(")").append(varName).append(";");
            }
        } else {
            this.internalToJavaStatement(arg, b, true);
        }
    }

    protected boolean isPreparationRequired(XExpression arg, ITreeAppendable b) {
        if (arg instanceof XAbstractFeatureCall && !(((XAbstractFeatureCall)arg).getFeature() instanceof JvmField) && !this.isVariableDeclarationRequired(arg, b)) {
            XVariableDeclaration variableDeclaration;
            XAbstractFeatureCall featureCall = (XAbstractFeatureCall)arg;
            if (featureCall.getFeature() instanceof XVariableDeclaration ? !(variableDeclaration = (XVariableDeclaration)featureCall.getFeature()).isWriteable() : featureCall.getFeature() instanceof JvmFormalParameter) {
                return true;
            }
            JvmTypeReference expectedType = this.getTypeProvider().getExpectedType(arg);
            JvmTypeReference type = this.getType(arg);
            return expectedType != null && !this.jvmConformance.isConformant(expectedType, type);
        }
        return true;
    }

    protected void _toJavaExpression(XAbstractFeatureCall call, ITreeAppendable b) {
        if (call.isTypeLiteral()) {
            b.append((JvmType)call.getFeature()).append(".class");
        } else {
            if (this.isPrimitiveVoid(call)) {
                throw new IllegalArgumentException("feature yields 'void'");
            }
            String referenceName = this.getReferenceName(call, b);
            if (referenceName != null) {
                if (call instanceof XFeatureCall || call instanceof XMemberFeatureCall) {
                    b.trace(call, (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, 0).append(referenceName);
                } else {
                    b.trace(call, false).append(referenceName);
                }
            } else {
                this.featureCalltoJavaExpression(call, b, true);
            }
        }
    }

    protected void featureCalltoJavaExpression(XAbstractFeatureCall call, ITreeAppendable b, boolean isExpressionContext) {
        if (call instanceof XAssignment) {
            this.assignmentToJavaExpression((XAssignment)call, b, isExpressionContext);
        } else {
            boolean hasReceiver = this.appendReceiver(call, b, isExpressionContext);
            if (hasReceiver) {
                b.append(".");
                b = this.appendTypeArguments(call, b);
            }
            this.appendFeatureCall(call, b);
        }
    }

    protected ITreeAppendable appendTypeArguments(final XAbstractFeatureCall call, ITreeAppendable original) {
        JvmExecutable executable;
        ITreeAppendable completeFeatureCallAppendable;
        ILocationData completeLocationData = this.getLocationWithTypeArguments(call);
        ITreeAppendable iTreeAppendable = completeFeatureCallAppendable = completeLocationData != null ? original.trace(completeLocationData) : original;
        if (!call.getTypeArguments().isEmpty()) {
            ILocationData argumentsLocationData = null;
            if (completeLocationData != null) {
                argumentsLocationData = this.getLocationOfTypeArguments(call);
            }
            ITreeAppendable typeArgumentsAppendable = argumentsLocationData != null ? completeFeatureCallAppendable.trace(argumentsLocationData) : completeFeatureCallAppendable;
            typeArgumentsAppendable.append("<");
            int i = 0;
            while (i < call.getTypeArguments().size()) {
                if (i != 0) {
                    typeArgumentsAppendable.append(", ");
                }
                JvmTypeReference typeArgument = (JvmTypeReference)call.getTypeArguments().get(i);
                ITreeAppendable singleTypeArgumentAppendable = typeArgumentsAppendable.trace((EObject)typeArgument, false);
                this.serialize(typeArgument, call, singleTypeArgumentAppendable);
                ++i;
            }
            typeArgumentsAppendable.append(">");
            ILocationData featureAndArgumentLocation = null;
            if (completeLocationData != null && argumentsLocationData != null) {
                featureAndArgumentLocation = this.getLocationWithoutTypeArguments(call);
            }
            ITreeAppendable result = featureAndArgumentLocation != null ? completeFeatureCallAppendable.trace(featureAndArgumentLocation) : completeFeatureCallAppendable;
            return result;
        }
        if (call.getFeature() instanceof JvmExecutable && !(executable = (JvmExecutable)call.getFeature()).getTypeParameters().isEmpty()) {
            XExpression receiver = this.getActualReceiver(call);
            final JvmTypeReference receiverType = receiver != null ? this.getType(receiver) : null;
            final JvmTypeReference expectedType = this.getTypeProvider().getExpectedType(call);
            final ArrayList argumentTypes = Lists.newArrayList();
            for (XExpression argument : this.getActualArguments(call)) {
                argumentTypes.add(this.getTypeProvider().getType(argument));
            }
            ITypeArgumentContext typeArgumentContext = this.getContextProvider().getTypeArgumentContext((TypeArgumentContextProvider.Request)new XbaseTypeArgumentContextProvider.AbstractFeatureCallRequest(){

                public JvmFeature getFeature() {
                    return executable;
                }

                @Override
                public XAbstractFeatureCall getFeatureCall() {
                    return call;
                }

                @Nullable
                public JvmTypeParameterDeclarator getNearestDeclarator() {
                    XAbstractFeatureCall context = call;
                    JvmTypeParameterDeclarator result = null;
                    while (context != null && result == null) {
                        if (context instanceof JvmTypeParameterDeclarator) {
                            result = (JvmTypeParameterDeclarator)context;
                            continue;
                        }
                        JvmIdentifiableElement logicalContainer = FeatureCallCompiler.this.contextProvider.getLogicalContainer(context);
                        context = logicalContainer != null ? logicalContainer : context.eContainer();
                    }
                    return result;
                }

                @Nullable
                public JvmTypeReference getDeclaredType() {
                    if (executable instanceof JvmOperation) {
                        return ((JvmOperation)executable).getReturnType();
                    }
                    return null;
                }

                @Nullable
                public JvmTypeReference getReceiverType() {
                    return receiverType;
                }

                public JvmTypeReference getExpectedType() {
                    return expectedType;
                }

                public List<JvmTypeReference> getArgumentTypes() {
                    return argumentTypes;
                }

                public String toString() {
                    return "FeatureCallCompiler.featureCalltoJavaExpression [call=" + call + "]";
                }
            });
            ArrayList resolvedTypeArguments = Lists.newArrayList();
            boolean containedUnresolved = false;
            int i = 0;
            while (i < executable.getTypeParameters().size() && !containedUnresolved) {
                JvmTypeParameter typeParameter = (JvmTypeParameter)executable.getTypeParameters().get(i);
                JvmTypeReference typeArgument = typeArgumentContext.getBoundArgument(typeParameter);
                if (typeArgument != null) {
                    if (this.isReferenceToForeignTypeParameter(typeArgument, call)) {
                        containedUnresolved = true;
                    } else if (typeArgument instanceof JvmWildcardTypeReference) {
                        containedUnresolved = true;
                    } else {
                        typeArgument = this.getPrimitives().asWrapperTypeIfPrimitive(typeArgument);
                        if (typeArgument == null) {
                            throw new IllegalStateException("typeArgument may not be null");
                        }
                        typeArgument = this.resolveMultiType(typeArgument, call);
                        resolvedTypeArguments.add(typeArgument);
                    }
                } else {
                    containedUnresolved = true;
                }
                ++i;
            }
            if (!containedUnresolved) {
                completeFeatureCallAppendable.append("<");
                i = 0;
                while (i < resolvedTypeArguments.size()) {
                    if (i != 0) {
                        completeFeatureCallAppendable.append(", ");
                    }
                    JvmTypeReference typeArgument = (JvmTypeReference)resolvedTypeArguments.get(i);
                    this.serialize(typeArgument, call, completeFeatureCallAppendable);
                    ++i;
                }
                completeFeatureCallAppendable.append(">");
            }
        }
        return completeFeatureCallAppendable;
    }

    @Nullable
    protected ILocationData getLocationWithoutTypeArguments(XAbstractFeatureCall call) {
        ICompositeNode startNode = NodeModelUtils.getNode((EObject)call);
        if (startNode != null) {
            ArrayList resultNodes = Lists.newArrayList();
            if (call instanceof XFeatureCall || call instanceof XMemberFeatureCall) {
                boolean featureReferenceSeen = false;
                for (INode child : startNode.getChildren()) {
                    Assignment assignment;
                    if (featureReferenceSeen) {
                        resultNodes.add(child);
                        continue;
                    }
                    EObject grammarElement = child.getGrammarElement();
                    if (!(grammarElement instanceof CrossReference) || (assignment = GrammarUtil.containingAssignment((EObject)grammarElement)) == null || !"feature".equals(assignment.getFeature())) continue;
                    featureReferenceSeen = true;
                    resultNodes.add(child);
                }
            }
            return this.toLocationData(resultNodes);
        }
        return null;
    }

    @Nullable
    protected ILocationData getLocationWithTypeArguments(XAbstractFeatureCall call) {
        ICompositeNode startNode = NodeModelUtils.getNode((EObject)call);
        if (startNode != null) {
            ArrayList resultNodes = Lists.newArrayList();
            if (call instanceof XFeatureCall) {
                for (INode child : startNode.getChildren()) {
                    resultNodes.add(child);
                }
            } else if (call instanceof XMemberFeatureCall) {
                boolean keywordSeen = false;
                for (INode child : startNode.getChildren()) {
                    if (keywordSeen) {
                        resultNodes.add(child);
                        continue;
                    }
                    EObject grammarElement = child.getGrammarElement();
                    if (!(grammarElement instanceof Keyword)) continue;
                    keywordSeen = true;
                }
            }
            return this.toLocationData(resultNodes);
        }
        return null;
    }

    @Nullable
    protected ILocationData getLocationOfTypeArguments(XAbstractFeatureCall call) {
        ICompositeNode startNode = NodeModelUtils.getNode((EObject)call);
        if (startNode != null) {
            ArrayList resultNodes = Lists.newArrayList();
            if (call instanceof XFeatureCall) {
                for (INode child : startNode.getChildren()) {
                    if (!(child.getGrammarElement() instanceof CrossReference)) {
                        resultNodes.add(child);
                        continue;
                    }
                    break;
                }
            } else if (call instanceof XMemberFeatureCall) {
                boolean keywordSeen = false;
                for (INode child : startNode.getChildren()) {
                    if (keywordSeen) {
                        if (!(child.getGrammarElement() instanceof CrossReference)) {
                            resultNodes.add(child);
                            continue;
                        }
                        break;
                    }
                    EObject grammarElement = child.getGrammarElement();
                    if (!(grammarElement instanceof Keyword)) continue;
                    keywordSeen = true;
                }
            }
            return this.toLocationData(resultNodes);
        }
        return null;
    }

    @Nullable
    protected ILocationData toLocationData(List<INode> nodes) {
        ITextRegionWithLineInformation result = ITextRegionWithLineInformation.EMPTY_REGION;
        for (INode node : nodes) {
            ITextRegionWithLineInformation region;
            if (this.isHidden(node) || (region = node.getTextRegionWithLineInformation()).getLength() == 0) continue;
            result = result.merge((ITextRegionWithLineInformation)new TextRegionWithLineInformation(region.getOffset(), region.getLength(), region.getLineNumber() - 1, region.getEndLineNumber() - 1));
        }
        if (result.getLength() == 0) {
            return null;
        }
        return new LocationData(result.getOffset(), result.getLength(), result.getLineNumber(), result.getEndLineNumber(), null);
    }

    protected boolean isHidden(INode node) {
        return node instanceof ILeafNode && ((ILeafNode)node).isHidden();
    }

    protected boolean appendReceiver(XAbstractFeatureCall call, ITreeAppendable b, boolean isExpressionContext) {
        if (call.isStatic()) {
            XMemberFeatureCall memberFeatureCall;
            if (this.expressionHelper.findInlineAnnotation(call) != null) {
                return false;
            }
            if (call instanceof XMemberFeatureCall && (memberFeatureCall = (XMemberFeatureCall)call).isStaticWithDeclaringType()) {
                XAbstractFeatureCall target = (XAbstractFeatureCall)memberFeatureCall.getMemberCallTarget();
                JvmType declaringType = (JvmType)target.getFeature();
                b.trace(target, false).append(declaringType);
                return true;
            }
            b.append((JvmType)((JvmFeature)call.getFeature()).getDeclaringType());
            return true;
        }
        XExpression receiver = this.getActualReceiver(call);
        if (receiver != null) {
            this.internalToJavaExpression(receiver, b);
            return true;
        }
        return false;
    }

    protected void appendNullValue(JvmTypeReference type, EObject context, ITreeAppendable b) {
        if (!this.primitives.isPrimitive(type)) {
            if (!(type.getType() instanceof JvmVoid)) {
                b.append("(");
                this.serialize(type, context, b);
                b.append(")");
            }
            b.append("null");
        } else {
            b.append(this.getDefaultLiteral((JvmPrimitiveType)type.getType()));
        }
    }

    protected void appendNullValueUntyped(JvmTypeReference type, EObject context, ITreeAppendable b) {
        if (!this.primitives.isPrimitive(type)) {
            b.append("null");
        } else {
            b.append(this.getDefaultLiteral((JvmPrimitiveType)type.getType()));
        }
    }

    protected String getDefaultLiteral(JvmPrimitiveType primitiveType) {
        String name = primitiveType.getIdentifier();
        if (Boolean.TYPE.getName().equals(name)) {
            return "false";
        }
        if (Integer.TYPE.getName().equals(name)) {
            return "0";
        }
        if (Byte.TYPE.getName().equals(name)) {
            return "(byte) 0";
        }
        if (Short.TYPE.getName().equals(name)) {
            return "(short) 0";
        }
        if (Character.TYPE.getName().equals(name)) {
            return "(char) 0";
        }
        if (Long.TYPE.getName().equals(name)) {
            return "0l";
        }
        if (Float.TYPE.getName().equals(name)) {
            return "0f";
        }
        if (Double.TYPE.getName().equals(name)) {
            return "0.0";
        }
        throw new IllegalArgumentException("Unkown primitive " + name);
    }

    protected boolean isMemberCall(XAbstractFeatureCall call) {
        return this.featureCallToJavaMapping.isTargetsMemberSyntaxCall(call, call.getFeature(), call.getImplicitReceiver());
    }

    protected void assignmentToJavaExpression(XAssignment expr, ITreeAppendable b, boolean isExpressionContext) {
        JvmIdentifiableElement feature = expr.getFeature();
        if (feature instanceof JvmOperation) {
            boolean appendReceiver = this.appendReceiver(expr, b, isExpressionContext);
            if (appendReceiver) {
                b.append(".");
            }
            this.appendFeatureCall(expr, b);
        } else {
            if (feature instanceof JvmField) {
                boolean appendReceiver = this.appendReceiver(expr, b, isExpressionContext);
                if (appendReceiver) {
                    b.append(".");
                }
                this.appendFeatureCall(expr, b);
            } else {
                String name = b.getName(expr.getFeature());
                b.append(name);
            }
            b.append(" = ");
            this.internalToJavaExpression(expr.getValue(), b);
        }
    }

    protected void appendFeatureCall(XAbstractFeatureCall call, ITreeAppendable b) {
        String name;
        if (this.expressionHelper.isInlined(call)) {
            this.appendInlineFeatureCall(call, b);
            return;
        }
        JvmIdentifiableElement feature = call.getFeature();
        if (feature instanceof JvmConstructor) {
            JvmDeclaredType constructorContainer = ((JvmConstructor)feature).getDeclaringType();
            JvmIdentifiableElement logicalContainer = this.contextProvider.getNearestLogicalContainer(call);
            JvmDeclaredType contextType = ((JvmMember)logicalContainer).getDeclaringType();
            name = contextType == constructorContainer ? "this" : "super";
        } else {
            name = b.hasName(feature) ? b.getName(feature) : this.featureNameProvider.getSimpleName(feature);
        }
        if (name == null) {
            name = "/* name is null */";
        }
        b.trace(call, (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, 0).append(name);
        if (feature instanceof JvmExecutable) {
            b.append("(");
            List<XExpression> arguments = this.getActualArguments(call);
            if (!arguments.isEmpty()) {
                XExpression receiver = null;
                if (call instanceof XMemberFeatureCall) {
                    receiver = ((XMemberFeatureCall)call).getMemberCallTarget();
                } else if (call instanceof XAssignment) {
                    receiver = ((XAssignment)call).getAssignable();
                }
                boolean shouldBreakFirstArgument = receiver == null || arguments.get(0) != receiver;
                this.appendArguments(arguments, b, shouldBreakFirstArgument);
            }
            b.append(")");
        }
    }

    protected void appendInlineFeatureCall(XAbstractFeatureCall call, ITreeAppendable b) {
        JvmAnnotationReference inlineAnnotation = this.expressionHelper.findInlineAnnotation(call);
        String formatString = null;
        ArrayList importedTypes = Lists.newArrayListWithCapacity((int)2);
        for (JvmAnnotationValue annotationValue : inlineAnnotation.getValues()) {
            if ("value".equals(annotationValue.getValueName())) {
                formatString = (String)((JvmStringAnnotationValue)annotationValue).getValues().get(0);
                continue;
            }
            if (!"imported".equals(annotationValue.getValueName())) continue;
            JvmTypeAnnotationValue typeAnnotationValue = (JvmTypeAnnotationValue)annotationValue;
            importedTypes.addAll(typeAnnotationValue.getValues());
        }
        if (formatString == null) {
            throw new IllegalStateException();
        }
        IResolvedTypes resolvedTypes = this.batchTypeResolver.resolveTypes(call);
        List<XExpression> arguments = this.getActualArguments(call);
        Matcher matcher = this.pattern.matcher(formatString);
        int prevEnd = 0;
        while (matcher.find()) {
            String indexOrDollar;
            int start = matcher.start();
            if (start != prevEnd) {
                b.append(formatString.substring(prevEnd, start));
            }
            if ("$".equals(indexOrDollar = matcher.group(1))) {
                b.append("$");
            } else {
                int index = Integer.parseInt(indexOrDollar) - 1;
                int numberImports = importedTypes.size();
                int numberArguments = arguments.size();
                if (index > numberArguments + numberImports) {
                    List<LightweightTypeReference> typeArguments = resolvedTypes.getActualTypeArguments(call);
                    LightweightTypeReference typeArgument = typeArguments.get(index - (numberArguments + numberImports + 1));
                    this.serialize(typeArgument.getUpperBoundSubstitute().toTypeReference(), call, b);
                } else if (index >= numberArguments && index < numberArguments + numberImports) {
                    this.serialize((JvmTypeReference)importedTypes.get(index - numberArguments), call, b);
                } else if (index == numberArguments + numberImports) {
                    this.appendTypeArguments(call, b);
                } else {
                    XExpression argument = arguments.get(index);
                    this.appendArgument(argument, b, index > 0);
                }
            }
            prevEnd = matcher.end();
        }
        if (prevEnd != formatString.length()) {
            b.append(formatString.substring(prevEnd));
        }
    }

    protected void appendArguments(List<? extends XExpression> arguments, ITreeAppendable b) {
        this.appendArguments(arguments, b, true);
    }

    protected void appendArguments(List<? extends XExpression> arguments, ITreeAppendable b, boolean shouldWrapLine) {
        int i = 0;
        while (i < arguments.size()) {
            XExpression argument = arguments.get(i);
            this.appendArgument(argument, b, shouldWrapLine || i > 0);
            if (i + 1 < arguments.size()) {
                b.append(", ");
            }
            ++i;
        }
    }

    protected void appendArgument(XExpression argument, ITreeAppendable b) {
        this.appendArgument(argument, b, true);
    }

    protected void appendArgument(XExpression argument, ITreeAppendable b, boolean doLineWrappingIfSourceWasWrapped) {
        boolean needsNewLine;
        String referenceName = this.getReferenceName(argument, b);
        boolean bl = needsNewLine = doLineWrappingIfSourceWasWrapped && referenceName == null && this.isDeclaredInNewLine(argument);
        if (needsNewLine) {
            b.increaseIndentation();
            b.newLine();
        }
        if (referenceName == null && this.isVariableDeclarationRequired(argument, b)) {
            JvmTypeReference type = this.getTypeProvider().getExpectedType(argument);
            if (type == null) {
                type = this.getTypeProvider().getType(argument);
            }
            this.compileAsJavaExpression(argument, b, type);
        } else {
            this.internalToJavaExpression(argument, b);
        }
        if (needsNewLine) {
            b.decreaseIndentation();
        }
    }

    protected boolean isDeclaredInNewLine(XExpression obj) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)obj);
        if (node != null) {
            int line = -1;
            for (ILeafNode n : node.getLeafNodes()) {
                if (n.isHidden() && line == -1) {
                    line = n.getStartLine();
                }
                if (n.isHidden() || line == -1) continue;
                return line != n.getStartLine();
            }
        }
        return false;
    }

    protected JvmTypeReference getUpperBound(XAbstractFeatureCall call, EList<JvmTypeConstraint> constraints) {
        JvmTypeReference typeArg = constraints.isEmpty() ? this.getTypeReferences().getTypeForName(Object.class, (Notifier)call, new JvmTypeReference[0]) : ((JvmTypeConstraint)constraints.get(0)).getTypeReference();
        return typeArg;
    }

    protected ILogicalContainerProvider getLogicalContainerProvider() {
        return this.contextProvider;
    }

    protected ILocationInFileProvider getLocationInFileProvider() {
        return this.locationInFileProvider;
    }
}

