/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.imports;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.SuperTypeCollector;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.common.types.util.VisibilityService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonOverridableTypesProvider {
    @Inject
    private SuperTypeCollector superTypeCollector;
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private VisibilityService visibilityService;
    private Map<JvmMember, Map<String, JvmIdentifiableElement>> visibleElements = Maps.newHashMap();

    public JvmIdentifiableElement getVisibleType(JvmMember context, String name) {
        if (context == null) {
            return null;
        }
        Map<String, JvmIdentifiableElement> map = this.visibleElements.get(context);
        if (map == null) {
            map = this.create(context);
        }
        return map.get(name);
    }

    protected Map<String, JvmIdentifiableElement> create(JvmMember context) {
        HashMap result = Maps.newHashMap();
        this.process(context, result);
        return result;
    }

    protected void process(JvmMember context, Map<String, JvmIdentifiableElement> result) {
        JvmDeclaredType declaringType;
        if (context instanceof JvmDeclaredType) {
            if (!result.containsKey(context.getSimpleName())) {
                result.put(context.getSimpleName(), (JvmIdentifiableElement)context);
            }
            JvmDeclaredType contextType = (JvmDeclaredType)context;
            this.addInnerTypes(contextType, "", contextType, result);
            JvmParameterizedTypeReference contextTypeRef = this.typeReferences.createTypeRef((JvmType)contextType, new JvmTypeReference[0]);
            for (JvmType superType : this.superTypeCollector.collectSuperTypesAsRawTypes((JvmTypeReference)contextTypeRef)) {
                if (!(superType instanceof JvmDeclaredType)) continue;
                this.addInnerTypes((JvmDeclaredType)superType, "", contextType, result);
            }
        }
        if (context instanceof JvmTypeParameterDeclarator) {
            this.addTypeParameters((JvmTypeParameterDeclarator)context, result);
        }
        if ((declaringType = context.getDeclaringType()) != null) {
            this.process((JvmMember)declaringType, result);
        }
    }

    protected void addInnerTypes(JvmDeclaredType type, String prefix, JvmDeclaredType contextType, Map<String, JvmIdentifiableElement> result) {
        for (JvmMember member : type.getMembers()) {
            if (!(member instanceof JvmDeclaredType) || !this.visibilityService.isVisible(member, contextType)) continue;
            String localName = String.valueOf(prefix) + member.getSimpleName();
            if (!result.containsKey(localName)) {
                result.put(localName, (JvmIdentifiableElement)member);
            }
            this.addInnerTypes((JvmDeclaredType)member, String.valueOf(prefix) + member.getSimpleName() + ".", contextType, result);
        }
    }

    protected void addTypeParameters(JvmTypeParameterDeclarator context, Map<String, JvmIdentifiableElement> result) {
        for (JvmTypeParameter typeParameter : context.getTypeParameters()) {
            if (result.containsKey(typeParameter.getName())) continue;
            result.put(typeParameter.getName(), (JvmIdentifiableElement)typeParameter);
        }
    }
}

