/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.linking.impl.IllegalNodeException;
import org.eclipse.xtext.linking.impl.LinkingHelper;
import org.eclipse.xtext.linking.lazy.LazyURIEncoder;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.IIdentifiableElementDescription;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.computation.IConstructorLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.IFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.AppliedFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.NullConstructorLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.NullFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeProviderAccess {
    @Inject
    private LinkingHelper linkingHelper;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private LazyURIEncoder encoder;

    protected IFeatureLinkingCandidate getKnownFeature(XAbstractFeatureCall featureCall, AbstractTypeComputationState state, ResolvedTypes resolvedTypes) {
        JvmIdentifiableElement feature;
        IFeatureLinkingCandidate result = resolvedTypes.getFeature(featureCall);
        if (result != null) {
            return new AppliedFeatureLinkingCandidate(result);
        }
        EObject proxyOrResolved = (EObject)featureCall.eGet((EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, false);
        if (proxyOrResolved == null) {
            return new NullFeatureLinkingCandidate(featureCall, state);
        }
        if (!proxyOrResolved.eIsProxy()) {
            return state.createResolvedLink(featureCall, (JvmIdentifiableElement)proxyOrResolved);
        }
        if (!this.encoder.isCrossLinkFragment(featureCall.eResource(), EcoreUtil.getURI((EObject)proxyOrResolved).fragment()) && !(feature = featureCall.getFeature()).eIsProxy()) {
            return state.createResolvedLink(featureCall, feature);
        }
        return null;
    }

    protected IConstructorLinkingCandidate getKnownConstructor(XConstructorCall constructorCall, AbstractTypeComputationState state, ResolvedTypes resolvedTypes) {
        JvmConstructor constructor;
        IConstructorLinkingCandidate result = resolvedTypes.getConstructor(constructorCall);
        if (result != null) {
            return result;
        }
        EObject proxyOrResolved = (EObject)constructorCall.eGet((EStructuralFeature)XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR, false);
        if (proxyOrResolved == null) {
            result = new NullConstructorLinkingCandidate(constructorCall, state);
            return result;
        }
        if (!proxyOrResolved.eIsProxy()) {
            result = state.createResolvedLink(constructorCall, (JvmConstructor)proxyOrResolved);
            return result;
        }
        if (!this.encoder.isCrossLinkFragment(constructorCall.eResource(), EcoreUtil.getURI((EObject)proxyOrResolved).fragment()) && !(constructor = constructorCall.getConstructor()).eIsProxy()) {
            return state.createResolvedLink(constructorCall, constructor);
        }
        return null;
    }

    public Iterable<IEObjectDescription> getCandidateDescriptions(XExpression expression, EReference reference, EObject toBeLinked, IFeatureScopeSession session, IResolvedTypes types) throws IllegalNodeException {
        if (toBeLinked == null) {
            return Collections.emptyList();
        }
        if (!toBeLinked.eIsProxy()) {
            throw new IllegalStateException(expression + " was already linked to " + toBeLinked);
        }
        URI uri = EcoreUtil.getURI((EObject)toBeLinked);
        String fragment = uri.fragment();
        if (this.encoder.isCrossLinkFragment(expression.eResource(), fragment)) {
            INode node = this.encoder.getNode((EObject)expression, fragment);
            EClass requiredType = reference.getEReferenceType();
            if (requiredType == null) {
                return Collections.emptyList();
            }
            String crossRefString = this.linkingHelper.getCrossRefNodeAsString(node, true);
            if (crossRefString != null && !crossRefString.equals("")) {
                QualifiedName qualifiedLinkName = this.qualifiedNameConverter.toQualifiedName(crossRefString);
                if (!qualifiedLinkName.isEmpty()) {
                    IScope scope = session.getScope(expression, reference, types);
                    Iterable descriptions = scope.getElements(qualifiedLinkName);
                    if (Iterables.isEmpty((Iterable)descriptions)) {
                        INode errorNode = this.getErrorNode(expression, node);
                        if (errorNode != node) {
                            qualifiedLinkName = this.getErrorName(errorNode);
                        }
                        return Collections.singletonList(new ErrorDescription(this.getErrorNode(expression, node), qualifiedLinkName));
                    }
                    return descriptions;
                }
                return Collections.singletonList(new ErrorDescription(null));
            }
            return Collections.emptyList();
        }
        throw new IllegalStateException(expression + " uses unsupported uri fragment " + uri);
    }

    private QualifiedName getErrorName(INode errorNode) {
        ArrayList segments = Lists.newArrayListWithCapacity((int)4);
        for (ILeafNode leaf : errorNode.getLeafNodes()) {
            String text;
            if (leaf.isHidden() || (text = leaf.getText()).equals("(") || text.equals(")") || text.equals(".") || text.equals("::")) continue;
            if (text.charAt(0) == '^') {
                segments.add(text.substring(1));
                continue;
            }
            segments.add(text);
        }
        return QualifiedName.create((List)segments);
    }

    private INode getErrorNode(XExpression expression, INode node) {
        if (expression instanceof XFeatureCall) {
            boolean explicitStatic;
            XMemberFeatureCall outerMost;
            XMemberFeatureCall container;
            XFeatureCall featureCall = (XFeatureCall)expression;
            if (!this.canBeTypeLiteral(featureCall)) {
                return node;
            }
            if (featureCall.eContainingFeature() == XbasePackage.Literals.XMEMBER_FEATURE_CALL__MEMBER_CALL_TARGET && this.canBeTypeLiteral(container = (XMemberFeatureCall)featureCall.eContainer()) && (outerMost = this.getLongestTypeLiteralCandidate(container, explicitStatic = container.isExplicitStatic())) != null) {
                return NodeModelUtils.getNode((EObject)outerMost);
            }
        }
        return node;
    }

    private XMemberFeatureCall getLongestTypeLiteralCandidate(XMemberFeatureCall current, boolean mustBeStatic) {
        XMemberFeatureCall container;
        if (current.eContainingFeature() == XbasePackage.Literals.XMEMBER_FEATURE_CALL__MEMBER_CALL_TARGET && this.canBeTypeLiteral(container = (XMemberFeatureCall)current.eContainer())) {
            if (!mustBeStatic && !container.isExplicitStatic()) {
                return null;
            }
            if (mustBeStatic != container.isExplicitStatic()) {
                return current;
            }
            if (mustBeStatic && container.eContainingFeature() != XbasePackage.Literals.XMEMBER_FEATURE_CALL__MEMBER_CALL_TARGET) {
                return current;
            }
            return this.getLongestTypeLiteralCandidate(container, mustBeStatic);
        }
        if (mustBeStatic) {
            return null;
        }
        if (!mustBeStatic && !current.isExplicitStatic()) {
            return null;
        }
        return current;
    }

    private boolean canBeTypeLiteral(XAbstractFeatureCall featureCall) {
        return !featureCall.isExplicitOperationCallOrBuilderSyntax() && featureCall.getTypeArguments().isEmpty();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ErrorDescription
    implements IIdentifiableElementDescription {
        private final QualifiedName name;
        private final INode node;
        private final boolean followUp;
        private final LightweightTypeReference syntacticReceiverType;

        public ErrorDescription(INode node, QualifiedName name) {
            this.node = node;
            this.name = name;
            this.followUp = false;
            this.syntacticReceiverType = null;
        }

        public ErrorDescription(LightweightTypeReference syntacticReceiverType) {
            this.node = null;
            this.name = null;
            this.followUp = true;
            this.syntacticReceiverType = syntacticReceiverType;
        }

        public boolean isFollowUpError() {
            return this.followUp;
        }

        public QualifiedName getName() {
            return this.name;
        }

        public INode getNode() {
            return this.node;
        }

        public QualifiedName getQualifiedName() {
            return this.name;
        }

        public EObject getEObjectOrProxy() {
            return null;
        }

        public URI getEObjectURI() {
            return null;
        }

        public EClass getEClass() {
            return null;
        }

        public String getUserData(String key) {
            return null;
        }

        public String[] getUserDataKeys() {
            return Strings.EMPTY_ARRAY;
        }

        @Override
        public JvmIdentifiableElement getElementOrProxy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getShadowingKey() {
            return "ErrorDescription";
        }

        @Override
        public int getBucketId() {
            return 0;
        }

        @Override
        public LightweightTypeReference getImplicitReceiverType() {
            return null;
        }

        @Override
        public XExpression getImplicitReceiver() {
            return null;
        }

        @Override
        public Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> getImplicitReceiverTypeParameterMapping() {
            return Collections.emptyMap();
        }

        @Override
        public EnumSet<ConformanceHint> getImplicitReceiverConformanceHints() {
            return EnumSet.noneOf(ConformanceHint.class);
        }

        @Override
        public LightweightTypeReference getSyntacticReceiverType() {
            return this.syntacticReceiverType;
        }

        @Override
        public XExpression getSyntacticReceiver() {
            return null;
        }

        @Override
        public boolean isSyntacticReceiverPossibleArgument() {
            return false;
        }

        @Override
        public Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> getSyntacticReceiverTypeParameterMapping() {
            return Collections.emptyMap();
        }

        @Override
        public EnumSet<ConformanceHint> getSyntacticReceiverConformanceHints() {
            return EnumSet.noneOf(ConformanceHint.class);
        }

        @Override
        public XExpression getImplicitFirstArgument() {
            return null;
        }

        @Override
        public LightweightTypeReference getImplicitFirstArgumentType() {
            return null;
        }

        public Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> getImplicitFirstArgumentTypeParameterMapping() {
            return Collections.emptyMap();
        }

        public EnumSet<ConformanceHint> getImplicitFirstArgumentConformanceHints() {
            return EnumSet.noneOf(ConformanceHint.class);
        }

        @Override
        public boolean isVisible() {
            return true;
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public boolean isExtension() {
            return false;
        }

        @Override
        public boolean isTypeLiteral() {
            return false;
        }

        @Override
        public boolean isAnonymousClassConstructorCall() {
            return false;
        }

        @Override
        public int getNumberOfIrrelevantParameters() {
            return 0;
        }

        @Override
        public int getNumberOfParameters() {
            return 0;
        }

        @Override
        public boolean isValidStaticState() {
            return false;
        }
    }
}

