/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import com.google.common.collect.Lists;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.scoping.batch.AbstractStaticImportsScope;
import org.eclipse.xtext.xbase.scoping.batch.BucketedEObjectDescription;
import org.eclipse.xtext.xbase.scoping.batch.ExtensionScopeHelper;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.StaticExtensionFeatureDescription;
import org.eclipse.xtext.xbase.scoping.batch.StaticExtensionFeatureDescriptionWithImplicitFirstArgument;
import org.eclipse.xtext.xbase.scoping.batch.TypeBucket;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticExtensionImportsScope
extends AbstractStaticImportsScope {
    private final ExtensionScopeHelper helper;
    private final XExpression receiver;
    private final LightweightTypeReference receiverType;
    private final boolean implicit;

    public StaticExtensionImportsScope(IScope parent, IFeatureScopeSession session, XExpression receiver, LightweightTypeReference receiverType, boolean implicit, XAbstractFeatureCall context, OperatorMapping operatorMapping) {
        super(parent, session, context, operatorMapping);
        this.receiver = receiver;
        this.receiverType = receiverType;
        this.implicit = implicit;
        this.helper = new ExtensionScopeHelper(receiverType);
    }

    @Override
    protected List<TypeBucket> getBuckets() {
        return this.getSession().getStaticallyImportedExtensionTypes();
    }

    @Override
    protected List<IEObjectDescription> getAllLocalElements() {
        List<TypeBucket> buckets = this.getBuckets();
        if (buckets.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.receiverType != null && !this.receiverType.isResolved()) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        for (TypeBucket bucket : buckets) {
            if (bucket.isRestrictingNames()) {
                for (Map.Entry entry : bucket.getTypesToNames().entrySet()) {
                    JvmType type = (JvmType)entry.getKey();
                    if (!(type instanceof JvmDeclaredType)) continue;
                    Iterable features = ((JvmDeclaredType)type).getAllFeatures();
                    for (JvmFeature feature : features) {
                        if (!feature.isStatic() || !((Set)entry.getValue()).contains(feature.getSimpleName()) || !this.helper.isPossibleExtension(feature) || !this.helper.isMatchingFirstParameter((JvmOperation)feature)) continue;
                        this.fastAddDescriptions(feature, bucket, result);
                    }
                }
                continue;
            }
            for (JvmType jvmType : bucket.getTypes()) {
                if (!(jvmType instanceof JvmDeclaredType)) continue;
                Iterable features = ((JvmDeclaredType)jvmType).getAllFeatures();
                for (JvmFeature feature : features) {
                    if (!feature.isStatic() || !this.helper.isPossibleExtension(feature) || !this.helper.isMatchingFirstParameter((JvmOperation)feature)) continue;
                    this.fastAddDescriptions(feature, bucket, result);
                }
            }
        }
        return result;
    }

    @Override
    protected BucketedEObjectDescription createDescription(QualifiedName name, JvmFeature feature, TypeBucket bucket) {
        if (!this.helper.isPossibleExtension(feature)) {
            return null;
        }
        if (!this.helper.isMatchingFirstParameter((JvmOperation)feature)) {
            return null;
        }
        return this.doCreateDescription(name, feature, bucket);
    }

    protected BucketedEObjectDescription doCreateDescription(QualifiedName name, JvmFeature feature, TypeBucket bucket) {
        if (this.implicit) {
            return new StaticExtensionFeatureDescriptionWithImplicitFirstArgument(name, feature, this.receiver, this.receiverType, bucket.getId(), this.getSession().isVisible((JvmMember)feature));
        }
        return new StaticExtensionFeatureDescription(name, feature, this.receiver, this.receiverType, bucket.getId(), this.getSession().isVisible((JvmMember)feature));
    }

    protected void fastAddDescriptions(JvmFeature feature, TypeBucket bucket, List<IEObjectDescription> result) {
        QualifiedName operator;
        String simpleName = feature.getSimpleName();
        QualifiedName featureName = QualifiedName.create((String)simpleName);
        BucketedEObjectDescription description = this.doCreateDescription(featureName, feature, bucket);
        result.add(description);
        String propertyName = this.toProperty(simpleName, feature);
        if (propertyName != null) {
            result.add(this.createDescription(QualifiedName.create((String)propertyName), feature, bucket));
        }
        if (!this.implicit && (operator = this.getOperatorMapping().getOperator(featureName)) != null) {
            result.add(this.createDescription(operator, feature, bucket));
        }
    }

    @Override
    protected void addDescriptions(JvmFeature feature, TypeBucket bucket, List<IEObjectDescription> result) {
        String simpleName = feature.getSimpleName();
        QualifiedName featureName = QualifiedName.create((String)simpleName);
        BucketedEObjectDescription description = this.createDescription(featureName, feature, bucket);
        if (description != null) {
            QualifiedName operator;
            result.add(description);
            String propertyName = this.toProperty(simpleName, feature);
            if (propertyName != null) {
                result.add(this.doCreateDescription(QualifiedName.create((String)propertyName), feature, bucket));
            }
            if (!this.implicit && (operator = this.getOperatorMapping().getOperator(featureName)) != null) {
                result.add(this.doCreateDescription(operator, feature, bucket));
            }
        }
    }

    @Override
    protected String toProperty(String methodName, JvmFeature feature) {
        if (feature instanceof JvmOperation) {
            JvmOperation operation = (JvmOperation)feature;
            if (methodName.length() > 3 && (methodName.startsWith("get") && operation.getParameters().size() == 1 || methodName.startsWith("set") && operation.getParameters().size() == 2) && Character.isUpperCase(methodName.charAt(3))) {
                return Introspector.decapitalize(methodName.substring(3));
            }
            if (methodName.length() > 3 && methodName.startsWith("is") && Character.isUpperCase(methodName.charAt(2)) && operation.getParameters().size() == 1) {
                return Introspector.decapitalize(methodName.substring(2));
            }
        }
        return null;
    }
}

