/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractMetamodelDeclaration;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Annotation;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CharacterRange;
import org.eclipse.xtext.CompoundElement;
import org.eclipse.xtext.Conjunction;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.Disjunction;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.NamedArgument;
import org.eclipse.xtext.NegatedToken;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.UnorderedGroup;
import org.eclipse.xtext.UntilToken;
import org.eclipse.xtext.Wildcard;
import org.eclipse.xtext.formatting2.AbstractJavaFormatter;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.xbase.lib.Procedures;

public class XtextFormatterJava
extends AbstractJavaFormatter {
    protected void format(Grammar grammar, IFormattableDocument doc) {
        doc.prepend(this.regionFor(grammar).keyword("("), (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.noSpace()));
        this.formatParens(grammar, doc);
        this.regionFor(grammar).keywords(",").forEach(s -> doc.prepend(s, (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.noSpace())));
        this.regionFor(grammar).keywords(",").forEach(s -> doc.append(s, (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.oneSpace())));
        boolean first = true;
        for (AbstractMetamodelDeclaration decl : grammar.getMetamodelDeclarations()) {
            doc.set(this.previousHiddenRegion(decl), (Procedures.Procedure1<? super IHiddenRegionFormatter>)(first ? it -> it.setNewLines(2) : it -> it.setNewLines(1)));
            first = false;
            doc.format(decl);
        }
        for (AbstractRule rule : grammar.getRules()) {
            doc.set(this.previousHiddenRegion(rule), (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.setNewLines(2)));
            doc.format(rule);
        }
        doc.set(this.nextHiddenRegion(grammar), (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.setNewLines(0, 0, 1)));
    }

    protected void format(ParserRule rule, IFormattableDocument doc) {
        doc.prepend(this.regionFor(rule).keyword("<"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.oneSpace()));
        doc.append(this.regionFor(rule).keyword("<"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.noSpace()));
        doc.prepend(this.regionFor(rule).keyword(">"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.noSpace()));
        rule.getParameters().forEach(p -> doc.format(p));
        this.formatRule(rule, doc);
        this.formatParens(rule, doc);
    }

    protected void format(TerminalRule rule, IFormattableDocument doc) {
        this.formatRule(rule, doc);
    }

    protected void format(EnumRule rule, IFormattableDocument doc) {
        this.formatRule(rule, doc);
    }

    protected void format(EnumLiteralDeclaration decl, IFormattableDocument doc) {
        doc.surround(this.regionFor(decl).keyword("="), (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.noSpace()));
    }

    protected void format(Alternatives alternatives, IFormattableDocument doc) {
        this.regionFor(alternatives).keywords("|").forEach(r -> {
            doc.surround(r, (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.autowrap()));
            doc.surround(r, (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.setNewLines(0, 0, 1)));
            doc.surround(r, (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.oneSpace()));
        });
        this.formatParens(alternatives, doc);
        this.formatCardinality(alternatives, doc);
        this.formatGroupElements(alternatives, doc);
    }

    protected void format(Assignment assignment, IFormattableDocument doc) {
        this.regionFor(assignment).keywords("=", "+=", "?=").forEach(r -> doc.surround(r, (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.noSpace())));
        this.regionFor(assignment).keywords("->", "=>").forEach(k -> doc.append(k, (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.noSpace())));
        this.formatParens(assignment, doc);
        this.formatCardinality(assignment, doc);
        doc.format(assignment.getTerminal());
    }

    protected void format(Group group, IFormattableDocument doc) {
        doc.append(this.regionFor(group).keyword("<"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.noSpace()));
        doc.format(group.getGuardCondition());
        doc.prepend(this.regionFor(group).keyword(">"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.noSpace()));
        this.formatParens(group, doc);
        this.formatCardinality(group, doc);
        this.formatGroupElements(group, doc);
    }

    protected void format(UnorderedGroup group, IFormattableDocument doc) {
        this.regionFor(group).keywords("&").forEach(r -> doc.surround(r, (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.oneSpace())));
        this.formatParens(group, doc);
        this.formatGroupElements(group, doc);
    }

    protected void format(Conjunction conjunction, IFormattableDocument doc) {
        this.regionFor(conjunction).keywords("&").forEach(r -> doc.surround(r, (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.oneSpace())));
        this.formatParens(conjunction, doc);
        doc.format(conjunction.getRight());
    }

    protected void format(Disjunction disjunction, IFormattableDocument doc) {
        this.regionFor(disjunction).keywords("|").forEach(r -> doc.surround(r, (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.oneSpace())));
        this.formatParens(disjunction, doc);
        doc.format(disjunction.getRight());
    }

    protected void format(Wildcard wildcard, IFormattableDocument doc) {
        doc.surround(this.regionFor(wildcard).keyword(":"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.oneSpace()));
    }

    protected void format(CharacterRange range, IFormattableDocument doc) {
        doc.surround(this.regionFor(range).keyword(".."), (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.noSpace()));
        this.formatParens(range, doc);
        this.formatCardinality(range, doc);
        doc.format(range.getLeft());
        doc.format(range.getRight());
    }

    protected void format(RuleCall call, IFormattableDocument doc) {
        doc.append(call, (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.autowrap()));
        doc.surround(this.regionFor(call).keyword("<"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.noSpace()));
        doc.prepend(this.regionFor(call).keyword(">"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.noSpace()));
        this.regionFor(call).keywords(",").forEach(r -> doc.prepend(r, (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.noSpace())));
        this.regionFor(call).keywords(",").forEach(r -> doc.append(r, (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.oneSpace())));
        this.formatParens(call, doc);
        this.formatCardinality(call, doc);
        call.getArguments().forEach(a -> doc.format(a));
    }

    protected void format(Keyword keyword, IFormattableDocument doc) {
        doc.surround(keyword, (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.autowrap()));
        this.regionFor(keyword).keywords("->", "=>").forEach(k -> doc.append(k, (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.noSpace())));
        this.formatParens(keyword, doc);
        this.formatCardinality(keyword, doc);
    }

    protected void format(NegatedToken token, IFormattableDocument doc) {
        doc.append(this.regionFor(token).keyword("!"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.noSpace()));
        this.formatParens(token, doc);
        this.formatCardinality(token, doc);
        doc.format(token.getTerminal());
    }

    protected void format(UntilToken token, IFormattableDocument doc) {
        doc.surround(this.regionFor(token).keyword("->"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.noSpace()));
        doc.format(token.getTerminal());
    }

    protected void format(Action action, IFormattableDocument doc) {
        doc.prepend(this.regionFor(action).keyword("{"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.autowrap()));
        doc.append(this.regionFor(action).keyword("{"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.noSpace()));
        doc.prepend(this.regionFor(action).keyword("}"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.noSpace()));
        doc.append(this.regionFor(action).keyword("}"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.autowrap()));
        doc.surround(this.regionFor(action).keyword("."), (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.noSpace()));
        this.regionFor(action).keywords("=", "+=").forEach(k -> doc.surround(k, (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.noSpace())));
        doc.format(action.getType());
    }

    protected void format(CrossReference ref, IFormattableDocument doc) {
        doc.append(this.regionFor(ref).keyword("["), (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.noSpace()));
        doc.prepend(this.regionFor(ref).keyword("]"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.noSpace()));
        doc.surround(this.regionFor(ref).keyword("|"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.noSpace()));
        doc.format(ref.getType());
    }

    protected void format(Parameter param, IFormattableDocument doc) {
    }

    protected void format(NamedArgument param, IFormattableDocument doc) {
        this.regionFor(param).keywords("=").forEach(k -> doc.surround(k, (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.noSpace())));
    }

    protected void format(TypeRef ref, IFormattableDocument doc) {
        doc.surround(this.regionFor(ref).keyword("::"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.noSpace()));
    }

    protected void format(Annotation annotation, IFormattableDocument doc) {
        doc.surround(this.regionFor(annotation).keyword("@"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.noSpace()));
        doc.append(annotation, (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.newLine()));
    }

    private void formatGroupElements(CompoundElement group, IFormattableDocument doc) {
        boolean first = true;
        EList<AbstractElement> elements = group.getElements();
        int size = elements.size();
        for (int index = 0; index < elements.size(); ++index) {
            boolean last = index + 1 == size;
            AbstractElement element = (AbstractElement)elements.get(index);
            AbstractElement next = null;
            if (!last) {
                next = (AbstractElement)elements.get(index + 1);
            }
            if (first && !last) {
                if (this.elementsAreSeperatedBySpace(element, next)) {
                    doc.append(element, (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.oneSpace()));
                }
            } else if (!first && !last) {
                doc.prepend(element, (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.setNewLines(0, 0, 1)));
                if (this.elementsAreSeperatedBySpace(element, next)) {
                    doc.surround(element, (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.oneSpace()));
                }
            } else if (!first && last) {
                doc.prepend(element, (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.setNewLines(0, 0, 1)));
            }
            first = false;
            doc.format(element);
        }
    }

    private boolean elementsAreSeperatedBySpace(AbstractElement element, AbstractElement next) {
        return !(element instanceof UntilToken) && !(element instanceof Group) && !(next instanceof UntilToken);
    }

    private void formatRule(AbstractRule rule, IFormattableDocument doc) {
        doc.surround(this.regionFor(rule).keyword("returns"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.oneSpace()));
        doc.prepend(this.regionFor(rule).keyword("hidden"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.oneSpace()));
        doc.append(this.regionFor(rule).keyword("hidden"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.noSpace()));
        this.regionFor(rule).keywords(",").forEach(r -> doc.prepend(r, (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.noSpace())));
        this.regionFor(rule).keywords(",").forEach(r -> doc.append(r, (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.oneSpace())));
        doc.prepend(this.regionFor(rule).keyword(":"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.noSpace()));
        doc.append(this.regionFor(rule).keyword(":"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.newLine()));
        doc.prepend(this.regionFor(rule).keyword(";"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.noSpace()));
        doc.append(this.regionFor(rule).keyword(";"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.noSpace()));
        doc.interior(this.regionFor(rule).keyword(":"), this.regionFor(rule).keyword(";"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.indent()));
        rule.getAnnotations().forEach(a -> doc.format(a));
        doc.format(rule.getType());
        doc.format(rule.getAlternatives());
    }

    private void formatParens(EObject element, IFormattableDocument doc) {
        doc.prepend(this.regionFor(element).keyword("("), (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.autowrap()));
        doc.append(this.regionFor(element).keyword("("), (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.noSpace()));
        doc.prepend(this.regionFor(element).keyword(")"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.noSpace()));
        doc.append(this.regionFor(element).keyword(")"), (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.autowrap()));
    }

    private void formatCardinality(EObject element, IFormattableDocument doc) {
        this.regionFor(element).keywords("?", "*", "+").forEach(r -> doc.prepend(r, (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.noSpace())));
        this.regionFor(element).keywords("?", "*", "+").forEach(r -> doc.append(r, (Procedures.Procedure1<? super IHiddenRegionFormatter>)((Procedures.Procedure1)it -> it.autowrap())));
    }
}

