/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.scoping.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.containers.FilterUriContainer;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractGlobalScopeProvider;
import org.eclipse.xtext.scoping.impl.DelegatingEventSource;
import org.eclipse.xtext.scoping.impl.SelectableBasedScope;
import org.eclipse.xtext.util.OnChangeEvictingCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGlobalScopeProvider
extends AbstractGlobalScopeProvider {
    @Inject
    private IContainer.Manager containerManager;
    @Inject
    private IResourceDescription.Manager descriptionManager;

    protected IScope getScope(IScope parent, Resource context, boolean ignoreCase, EClass type, Predicate<IEObjectDescription> filter) {
        IScope result = parent;
        if (context == null || context.getResourceSet() == null) {
            return result;
        }
        ArrayList containers = Lists.newArrayList(this.getVisibleContainers(context));
        Collections.reverse(containers);
        for (IContainer container : containers) {
            result = this.createContainerScopeWithContext(context, result, container, filter, type, ignoreCase);
        }
        return result;
    }

    @Override
    protected IScope getScope(Resource context, boolean ignoreCase, EClass type, Predicate<IEObjectDescription> filter) {
        return this.getScope(IScope.NULLSCOPE, context, ignoreCase, type, filter);
    }

    protected List<IContainer> getVisibleContainers(Resource resource) {
        IResourceDescription description = this.descriptionManager.getResourceDescription(resource);
        IResourceDescriptions resourceDescriptions = this.getResourceDescriptions(resource);
        String cacheKey = this.getCacheKey("VisibleContainers", resource.getResourceSet());
        OnChangeEvictingCache.CacheAdapter cache = new OnChangeEvictingCache().getOrCreate(resource);
        List<IContainer> result = null;
        result = (List<IContainer>)cache.get(cacheKey);
        if (result == null) {
            result = this.containerManager.getVisibleContainers(description, resourceDescriptions);
            if (resourceDescriptions instanceof IResourceDescription.Event.Source) {
                IResourceDescription.Event.Source eventSource = (IResourceDescription.Event.Source)((Object)resourceDescriptions);
                DelegatingEventSource delegatingEventSource = new DelegatingEventSource(eventSource);
                delegatingEventSource.addListeners(Lists.newArrayList((Iterable)Iterables.filter(result, IResourceDescription.Event.Listener.class)));
                delegatingEventSource.initialize();
                cache.addCacheListener(delegatingEventSource);
            }
            cache.set(cacheKey, result);
        }
        return result;
    }

    protected String getCacheKey(String base, ResourceSet context) {
        Map loadOptions = context.getLoadOptions();
        if (loadOptions.containsKey("org.eclipse.xtext.scoping.namespaces.DefaultGlobalScopeProvider.BUILDER_SCOPE")) {
            return String.valueOf(base) + "@" + "org.eclipse.xtext.scoping.namespaces.DefaultGlobalScopeProvider.BUILDER_SCOPE";
        }
        return String.valueOf(base) + "@DEFAULT_SCOPE";
    }

    protected IScope createContainerScopeWithContext(Resource eResource, IScope parent, IContainer container, Predicate<IEObjectDescription> filter, EClass type, boolean ignoreCase) {
        URI uriToFilter;
        if (eResource != null && container.hasResourceDescription(uriToFilter = eResource.getURI())) {
            container = new FilterUriContainer(uriToFilter, container);
        }
        return this.createContainerScope(parent, container, filter, type, ignoreCase);
    }

    protected IScope createContainerScope(IScope parent, IContainer container, Predicate<IEObjectDescription> filter, EClass type, boolean ignoreCase) {
        return SelectableBasedScope.createScope(parent, container, filter, type, ignoreCase);
    }
}

