/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ITraceRegionProvider;
import org.eclipse.xtext.generator.trace.LocationData;
import org.eclipse.xtext.generator.trace.TraceRegion;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.Strings;

@NonNullByDefault
public class CharSequenceTraceWrapper {
    @Inject
    private ILocationInFileProvider locationInFileProvider;

    public CharSequence wrapWithTraceData(CharSequence sequence, EObject origin) {
        ITextRegionWithLineInformation location = (ITextRegionWithLineInformation)this.locationInFileProvider.getSignificantTextRegion(origin);
        return this.wrapWithTraceData(sequence, origin.eResource().getURI(), location.getOffset(), location.getLength(), location.getLineNumber(), location.getEndLineNumber());
    }

    public CharSequence wrapWithTraceData(CharSequence sequence, URI originResourceURI, int originOffset, int originLength, int originLineNumber, int originEndLineNumber) {
        if (!originResourceURI.isPlatformResource()) {
            throw new IllegalArgumentException("URI has to be a platform resource uri but was: " + originResourceURI + ". Use #wrapWithTraceData(CharSequence, URI, String, int, int) instead.");
        }
        return this.wrapWithTraceData(sequence, originResourceURI, originResourceURI.segment(1), originOffset, originLength, originLineNumber, originEndLineNumber);
    }

    public CharSequence wrapWithTraceData(CharSequence sequence, URI originURI, @Nullable String originProject, int originOffset, int originLength, int originLineNumber, int originEndLineNumber) {
        return new CharSequenceBasedTraceRegionProvider(sequence, originURI, originOffset, originLength, originLineNumber, originEndLineNumber);
    }

    protected static class CharSequenceBasedTraceRegionProvider
    implements ITraceRegionProvider,
    CharSequence {
        private final CharSequence delegate;
        private final URI originURI;
        private final int originOffset;
        private final int originLength;
        private final int originLineNumber;
        private final int originEndLineNumber;

        public CharSequenceBasedTraceRegionProvider(CharSequence delegate, URI originURI, int originOffset, int originLength, int originLineNumber, int originEndLineNumber) {
            this.delegate = delegate;
            this.originURI = originURI;
            this.originOffset = originOffset;
            this.originLength = originLength;
            this.originLineNumber = originLineNumber;
            this.originEndLineNumber = originEndLineNumber;
        }

        public int length() {
            return this.delegate.length();
        }

        public char charAt(int index) {
            return this.delegate.charAt(index);
        }

        public CharSequence subSequence(int start, int end) {
            return this.delegate.subSequence(start, end);
        }

        public String toString() {
            return this.delegate.toString();
        }

        public AbstractTraceRegion getTraceRegion() {
            LocationData locationData = new LocationData(this.originOffset, this.originLength, this.originLineNumber, this.originEndLineNumber, this.originURI);
            TraceRegion result = new TraceRegion(0, this.delegate.length(), 0, Strings.countLineBreaks(this.delegate), locationData, null);
            return result;
        }
    }
}

