/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parser.antlr;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.xtext.parser.antlr.IAntlrTokenFileProvider;
import org.eclipse.xtext.parser.antlr.ITokenDefProvider;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class AntlrTokenDefProvider
implements ITokenDefProvider {
    private static final Logger log = Logger.getLogger(AntlrTokenDefProvider.class);
    @Inject
    private IAntlrTokenFileProvider antlrTokenFileProvider;
    protected volatile Map<Integer, String> tokenDefMap;

    @Override
    public Map<Integer, String> getTokenDefMap() {
        if (this.antlrTokenFileProvider == null) {
            return Collections.emptyMap();
        }
        if (this.tokenDefMap == null) {
            InputStream tokenFile = this.antlrTokenFileProvider.getAntlrTokenFile();
            try {
                try {
                    BufferedReader br = new BufferedReader(new InputStreamReader(tokenFile));
                    HashMap<Integer, String> tokenDefMap = new HashMap<Integer, String>();
                    String line = br.readLine();
                    Pattern pattern = Pattern.compile("(.*)=(\\d+)");
                    while (line != null) {
                        Matcher m = pattern.matcher(line);
                        if (!m.matches()) {
                            throw new IllegalStateException("Couldn't match line : '" + line + "'");
                        }
                        int antlrTokenType = Integer.parseInt(m.group(2));
                        String antlrTokenDef = m.group(1);
                        if (antlrTokenDef.startsWith("'")) {
                            antlrTokenDef = antlrTokenDef.substring(1, antlrTokenDef.length() - 1);
                            antlrTokenDef = Strings.convertFromJavaString(antlrTokenDef, true);
                            antlrTokenDef = "'" + antlrTokenDef + "'";
                            tokenDefMap.put(antlrTokenType, antlrTokenDef);
                        } else if (antlrTokenDef.startsWith("RULE_") || antlrTokenDef.startsWith("KEYWORD_")) {
                            tokenDefMap.put(antlrTokenType, antlrTokenDef);
                        }
                        line = br.readLine();
                    }
                    this.setTokenDefMap(tokenDefMap);
                }
                catch (Exception e) {
                    log.error((Object)e, (Throwable)e);
                    this.tokenDefMap = null;
                    throw new WrappedException(e);
                }
            }
            finally {
                try {
                    tokenFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this.tokenDefMap;
    }

    protected void setTokenDefMap(Map<Integer, String> tokenDefMap) {
        this.tokenDefMap = ImmutableMap.copyOf(tokenDefMap);
    }

    public void setAntlrTokenFileProvider(IAntlrTokenFileProvider antlrTokenFileProvider) {
        this.antlrTokenFileProvider = antlrTokenFileProvider;
    }

    public IAntlrTokenFileProvider getAntlrTokenFileProvider() {
        return this.antlrTokenFileProvider;
    }
}

