/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.resource.DerivedStateAwareResource;
import org.eclipse.xtext.resource.IDefaultResourceDescriptionStrategy;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionManager;
import org.eclipse.xtext.resource.impl.EObjectDescriptionLookUp;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.util.RuntimeIOException;

@Singleton
public class DerivedStateAwareResourceDescriptionManager
extends DefaultResourceDescriptionManager {
    private static final Logger log = Logger.getLogger(DerivedStateAwareResourceDescriptionManager.class);
    @Inject
    private IResourceScopeCache cache = IResourceScopeCache.NullImpl.INSTANCE;

    protected IResourceDescription internalGetResourceDescription(Resource resource, IDefaultResourceDescriptionStrategy strategy) {
        DerivedStateAwareResource res = (DerivedStateAwareResource)resource;
        if (!res.isLoaded()) {
            try {
                res.load(res.getResourceSet().getLoadOptions());
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
        boolean isInitialized = res.fullyInitialized || res.isInitializing;
        try {
            if (!isInitialized) {
                res.eSetDeliver(false);
                res.installDerivedState(true);
            }
            IResourceDescription description = this.createResourceDescription(resource, strategy);
            if (!isInitialized) {
                for (IEObjectDescription desc : description.getExportedObjects()) {
                    desc.getEObjectURI();
                }
            }
            IResourceDescription iResourceDescription = description;
            return iResourceDescription;
        }
        finally {
            if (!isInitialized) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Discarding inferred state for " + resource.getURI()));
                }
                res.discardDerivedState();
                res.eSetDeliver(true);
            }
        }
    }

    protected IResourceDescription createResourceDescription(Resource resource, IDefaultResourceDescriptionStrategy strategy) {
        return new DefaultResourceDescription(resource, strategy, this.cache){

            protected EObjectDescriptionLookUp getLookUp() {
                if (this.lookup == null) {
                    this.lookup = new EObjectDescriptionLookUp(this.computeExportedObjects());
                }
                return this.lookup;
            }
        };
    }
}

