/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parsetree.reconstr.IHiddenTokenHelper;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.ILocationInFileProviderExtension;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.TextRegionWithLineInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLocationInFileProvider
implements ILocationInFileProvider,
ILocationInFileProviderExtension {
    @Inject(optional=true)
    private IHiddenTokenHelper hiddenTokenHelper;

    @Override
    public ITextRegion getSignificantTextRegion(EObject obj) {
        return this.getTextRegion(obj, true);
    }

    @Override
    public ITextRegion getFullTextRegion(EObject obj) {
        return this.getTextRegion(obj, false);
    }

    protected ITextRegion getTextRegion(EObject obj, boolean isSignificant) {
        return this.doGetTextRegion(obj, isSignificant ? ILocationInFileProviderExtension.RegionDescription.SIGNIFICANT : ILocationInFileProviderExtension.RegionDescription.FULL);
    }

    @Override
    public ITextRegion getTextRegion(EObject object, ILocationInFileProviderExtension.RegionDescription query) {
        switch (query) {
            case SIGNIFICANT: {
                return this.getSignificantTextRegion(object);
            }
            case FULL: {
                return this.getFullTextRegion(object);
            }
        }
        return this.doGetTextRegion(object, query);
    }

    protected ITextRegion doGetTextRegion(EObject obj, ILocationInFileProviderExtension.RegionDescription query) {
        ICompositeNode node = this.findNodeFor(obj);
        if (node == null) {
            if (obj.eContainer() == null) {
                return ITextRegion.EMPTY_REGION;
            }
            return this.getTextRegion(obj.eContainer(), query);
        }
        List<INode> nodes = null;
        if (query == ILocationInFileProviderExtension.RegionDescription.SIGNIFICANT) {
            nodes = this.getLocationNodes(obj);
        }
        if (nodes == null || nodes.isEmpty()) {
            nodes = Collections.singletonList(node);
        }
        return this.createRegion(nodes, query);
    }

    @Override
    public ITextRegion getSignificantTextRegion(EObject owner, EStructuralFeature feature, int indexInList) {
        return this.getTextRegion(owner, feature, indexInList, true);
    }

    @Override
    public ITextRegion getFullTextRegion(EObject owner, EStructuralFeature feature, int indexInList) {
        return this.getTextRegion(owner, feature, indexInList, false);
    }

    @Override
    public ITextRegion getTextRegion(EObject object, EStructuralFeature feature, int indexInList, ILocationInFileProviderExtension.RegionDescription query) {
        switch (query) {
            case SIGNIFICANT: {
                return this.getSignificantTextRegion(object, feature, indexInList);
            }
            case FULL: {
                return this.getFullTextRegion(object, feature, indexInList);
            }
        }
        return this.doGetTextRegion(object, feature, indexInList, query);
    }

    private ITextRegion getTextRegion(EObject owner, EStructuralFeature feature, int indexInList, boolean isSignificant) {
        if (feature instanceof EAttribute) {
            return this.getLocationOfAttribute(owner, (EAttribute)feature, indexInList, isSignificant);
        }
        if (feature instanceof EReference) {
            EReference reference = (EReference)feature;
            if (reference.isContainment() || reference.isContainer()) {
                return this.getLocationOfContainmentReference(owner, reference, indexInList, isSignificant);
            }
            return this.getLocationOfCrossReference(owner, reference, indexInList, isSignificant);
        }
        return null;
    }

    private ITextRegion doGetTextRegion(EObject owner, EStructuralFeature feature, int indexInList, ILocationInFileProviderExtension.RegionDescription query) {
        if (feature == null) {
            return null;
        }
        if (feature instanceof EAttribute) {
            return this.doGetLocationOfFeature(owner, feature, indexInList, query);
        }
        if (feature instanceof EReference) {
            EReference reference = (EReference)feature;
            if (reference.isContainment() || reference.isContainer()) {
                return this.getLocationOfContainmentReference(owner, reference, indexInList, query);
            }
            return this.doGetLocationOfFeature(owner, (EStructuralFeature)reference, indexInList, query);
        }
        return null;
    }

    protected ITextRegion getLocationOfContainmentReference(EObject owner, EReference feature, int indexInList, boolean isSignificant) {
        return this.getLocationOfContainmentReference(owner, feature, indexInList, isSignificant ? ILocationInFileProviderExtension.RegionDescription.SIGNIFICANT : ILocationInFileProviderExtension.RegionDescription.FULL);
    }

    protected ITextRegion getLocationOfContainmentReference(EObject owner, EReference feature, int indexInList, ILocationInFileProviderExtension.RegionDescription query) {
        List values;
        Object referencedElement = null;
        referencedElement = feature.isMany() ? (indexInList >= (values = (List)owner.eGet((EStructuralFeature)feature)).size() ? owner : values.get(indexInList)) : owner.eGet((EStructuralFeature)feature);
        return this.getTextRegion((EObject)referencedElement, query);
    }

    protected ITextRegion getLocationOfCrossReference(EObject owner, EReference reference, int indexInList, boolean isSignificant) {
        return this.doGetLocationOfFeature(owner, (EStructuralFeature)reference, indexInList, isSignificant);
    }

    protected ITextRegion getLocationOfAttribute(EObject owner, EAttribute attribute, int indexInList, boolean isSignificant) {
        return this.doGetLocationOfFeature(owner, (EStructuralFeature)attribute, indexInList, isSignificant);
    }

    protected ITextRegion doGetLocationOfFeature(EObject owner, EStructuralFeature feature, int indexInList, boolean isSignificant) {
        return this.doGetLocationOfFeature(owner, feature, indexInList, isSignificant ? ILocationInFileProviderExtension.RegionDescription.SIGNIFICANT : ILocationInFileProviderExtension.RegionDescription.FULL);
    }

    protected ITextRegion doGetLocationOfFeature(EObject owner, EStructuralFeature feature, int indexInList, ILocationInFileProviderExtension.RegionDescription query) {
        if (!feature.isMany()) {
            indexInList = 0;
        }
        if (indexInList >= 0) {
            List<INode> findNodesForFeature = NodeModelUtils.findNodesForFeature(owner, feature);
            if (indexInList < findNodesForFeature.size()) {
                INode node = findNodesForFeature.get(indexInList);
                return this.createRegion(Collections.singletonList(node), query);
            }
            return this.getTextRegion(owner, query);
        }
        return null;
    }

    protected List<INode> getLocationNodes(EObject obj) {
        List<INode> result;
        EStructuralFeature nameFeature = this.getIdentifierFeature(obj);
        if (nameFeature != null && !(result = NodeModelUtils.findNodesForFeature(obj, nameFeature)).isEmpty()) {
            return result;
        }
        ArrayList resultNodes = Lists.newArrayList();
        ICompositeNode startNode = this.findNodeFor(obj);
        INode keywordNode = null;
        for (INode child : startNode.getChildren()) {
            EObject grammarElement = child.getGrammarElement();
            if (grammarElement instanceof RuleCall) {
                RuleCall ruleCall = (RuleCall)grammarElement;
                String ruleName = ruleCall.getRule().getName();
                if (!ruleName.equals("ID")) continue;
                resultNodes.add(child);
                continue;
            }
            if (!(grammarElement instanceof Keyword) || keywordNode != null || !this.useKeyword((Keyword)grammarElement, obj)) continue;
            keywordNode = child;
        }
        if (resultNodes.isEmpty() && keywordNode != null) {
            resultNodes.add(keywordNode);
        }
        return resultNodes;
    }

    protected boolean useKeyword(Keyword keyword, EObject context) {
        return true;
    }

    protected EStructuralFeature getIdentifierFeature(EObject obj) {
        EClass eClass = obj.eClass();
        EStructuralFeature result = eClass.getEStructuralFeature("name");
        return result != null ? result : eClass.getEStructuralFeature("id");
    }

    protected ITextRegion createRegion(List<INode> nodes) {
        ITextRegion result = ITextRegion.EMPTY_REGION;
        for (INode node : nodes) {
            ITextRegionWithLineInformation region;
            if (this.isHidden(node) || (region = node.getTextRegionWithLineInformation()).getLength() == 0) continue;
            result = result.merge(this.toZeroBasedRegion(region));
        }
        return result;
    }

    protected ITextRegion createRegion(List<INode> nodes, ILocationInFileProviderExtension.RegionDescription query) {
        if (query == ILocationInFileProviderExtension.RegionDescription.FULL || query == ILocationInFileProviderExtension.RegionDescription.SIGNIFICANT) {
            return this.createRegion(nodes);
        }
        ITextRegion result = ITextRegion.EMPTY_REGION;
        for (INode node : nodes) {
            for (INode iNode : node.getLeafNodes()) {
                ITextRegionWithLineInformation region;
                if (this.isHidden(iNode, query) || (region = iNode.getTextRegionWithLineInformation()).getLength() == 0) continue;
                result = result.merge(this.toZeroBasedRegion(region));
            }
        }
        return result;
    }

    protected TextRegionWithLineInformation toZeroBasedRegion(ITextRegionWithLineInformation region) {
        return new TextRegionWithLineInformation(region.getOffset(), region.getLength(), region.getLineNumber() - 1, region.getEndLineNumber() - 1);
    }

    protected boolean isHidden(INode node, ILocationInFileProviderExtension.RegionDescription query) {
        if (query == ILocationInFileProviderExtension.RegionDescription.INCLUDING_WHITESPACE) {
            return false;
        }
        if (node instanceof ILeafNode && ((ILeafNode)node).isHidden()) {
            if (query == ILocationInFileProviderExtension.RegionDescription.INCLUDING_COMMENTS) {
                if (this.hiddenTokenHelper != null && node.getGrammarElement() instanceof AbstractRule) {
                    boolean result = this.hiddenTokenHelper.isWhitespace((AbstractRule)node.getGrammarElement());
                    return result;
                }
                boolean result = node.getText().trim().length() == 0;
                return result;
            }
            return true;
        }
        return false;
    }

    protected boolean isHidden(INode node) {
        return node instanceof ILeafNode && ((ILeafNode)node).isHidden();
    }

    protected ICompositeNode findNodeFor(EObject semanticObject) {
        ICompositeNode result = NodeModelUtils.getNode(semanticObject);
        if (result != null) {
            ICompositeNode node = result;
            while (GrammarUtil.containingAssignment(node.getGrammarElement()) == null && node.getParent() != null && !node.getParent().hasDirectSemanticElement()) {
                ICompositeNode parent = node.getParent();
                if (node.hasSiblings()) {
                    for (INode sibling : parent.getChildren()) {
                        EObject grammarElement = sibling.getGrammarElement();
                        if (grammarElement == null || GrammarUtil.containingAssignment(grammarElement) == null) continue;
                        result = parent;
                    }
                }
                node = parent;
            }
        }
        return result;
    }
}

