/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.validation;

import com.google.common.base.Function;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.util.Exceptions;
import org.eclipse.xtext.util.SimpleCache;
import org.eclipse.xtext.validation.AbstractInjectableValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.ComposedChecks;
import org.eclipse.xtext.validation.FeatureBasedDiagnostic;
import org.eclipse.xtext.validation.GuardException;
import org.eclipse.xtext.validation.IssueSeverities;
import org.eclipse.xtext.validation.IssueSeveritiesProvider;
import org.eclipse.xtext.validation.RangeBasedDiagnostic;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDeclarativeValidator
extends AbstractInjectableValidator
implements ValidationMessageAcceptor {
    @Inject
    private IssueSeveritiesProvider issueSeveritiesProvider;
    private static final Logger log = Logger.getLogger(AbstractDeclarativeValidator.class);
    private static final GuardException guardException = new GuardException();
    private volatile Set<MethodWrapper> checkMethods = null;
    private ValidationMessageAcceptor messageAcceptor;
    @Inject
    private Injector injector;
    private final SimpleCache<Class<?>, List<MethodWrapper>> methodsForType = new SimpleCache(new Function<Class<?>, List<MethodWrapper>>(){

        public List<MethodWrapper> apply(Class<?> param) {
            ArrayList<MethodWrapper> result = new ArrayList<MethodWrapper>();
            for (MethodWrapper mw : AbstractDeclarativeValidator.this.checkMethods) {
                if (!mw.isMatching(param)) continue;
                result.add(mw);
            }
            return result;
        }
    });
    private final ThreadLocal<State> state = new ThreadLocal();

    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    public AbstractDeclarativeValidator() {
        this.messageAcceptor = this;
    }

    private List<MethodWrapper> collectMethods(Class<? extends AbstractDeclarativeValidator> clazz) {
        ArrayList<MethodWrapper> checkMethods = new ArrayList<MethodWrapper>();
        HashSet visitedClasses = new HashSet(4);
        this.collectMethods(this, clazz, visitedClasses, checkMethods);
        return checkMethods;
    }

    private void collectMethods(AbstractDeclarativeValidator instance, Class<? extends AbstractDeclarativeValidator> clazz, Collection<Class<?>> visitedClasses, Collection<MethodWrapper> result) {
        if (visitedClasses.contains(clazz)) {
            return;
        }
        this.collectMethodsImpl(instance, clazz, visitedClasses, result);
        Class<? extends AbstractDeclarativeValidator> k = clazz;
        while (k != null) {
            ComposedChecks checks = k.getAnnotation(ComposedChecks.class);
            if (checks != null) {
                Class<? extends AbstractDeclarativeValidator>[] classArray = checks.validators();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<? extends AbstractDeclarativeValidator> external = classArray[n2];
                    this.collectMethods(null, external, visitedClasses, result);
                    ++n2;
                }
            }
            k = this.getSuperClass(k);
        }
    }

    private Class<? extends AbstractDeclarativeValidator> getSuperClass(Class<? extends AbstractDeclarativeValidator> clazz) {
        Class<AbstractDeclarativeValidator> superClass;
        block3: {
            try {
                superClass = clazz.getSuperclass().asSubclass(AbstractDeclarativeValidator.class);
                if (!AbstractDeclarativeValidator.class.equals(superClass)) break block3;
                return null;
            }
            catch (ClassCastException e) {
                return null;
            }
        }
        return superClass;
    }

    private void collectMethodsImpl(AbstractDeclarativeValidator instance, Class<? extends AbstractDeclarativeValidator> clazz, Collection<Class<?>> visitedClasses, Collection<MethodWrapper> result) {
        Method[] methods;
        if (!visitedClasses.add(clazz)) {
            return;
        }
        AbstractDeclarativeValidator instanceToUse = instance;
        if (instanceToUse == null) {
            instanceToUse = this.newInstance(clazz);
        }
        Method[] methodArray = methods = clazz.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getAnnotation(Check.class) != null && method.getParameterTypes().length == 1) {
                result.add(this.createMethodWrapper(instanceToUse, method));
            }
            ++n2;
        }
        Class<? extends AbstractDeclarativeValidator> superClass = this.getSuperClass(clazz);
        if (superClass != null) {
            this.collectMethodsImpl(instanceToUse, superClass, visitedClasses, result);
        }
    }

    protected MethodWrapper createMethodWrapper(AbstractDeclarativeValidator instanceToUse, Method method) {
        return new MethodWrapper(instanceToUse, method);
    }

    protected AbstractDeclarativeValidator newInstance(Class<? extends AbstractDeclarativeValidator> clazz) {
        if (this.injector == null) {
            throw new IllegalStateException("the class is not configured with an injector.");
        }
        AbstractDeclarativeValidator instanceToUse = (AbstractDeclarativeValidator)this.injector.getInstance(clazz);
        return instanceToUse;
    }

    protected EObject getCurrentObject() {
        return this.state.get().currentObject;
    }

    protected Method getCurrentMethod() {
        return this.state.get().currentMethod;
    }

    protected DiagnosticChain getChain() {
        return this.state.get().chain;
    }

    protected CheckMode getCheckMode() {
        return this.state.get().checkMode;
    }

    protected Map<Object, Object> getContext() {
        return this.state.get().context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean internalValidate(EClass class1, EObject object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (this.checkMethods == null) {
            AbstractDeclarativeValidator abstractDeclarativeValidator = this;
            synchronized (abstractDeclarativeValidator) {
                if (this.checkMethods == null) {
                    LinkedHashSet checkMethods = Sets.newLinkedHashSet();
                    checkMethods.addAll(this.collectMethods(this.getClass()));
                    this.checkMethods = checkMethods;
                }
            }
        }
        CheckMode checkMode = CheckMode.getCheckMode(context);
        State state = new State();
        state.chain = diagnostics;
        state.currentObject = object;
        state.checkMode = checkMode;
        state.context = context;
        for (MethodWrapper method : this.methodsForType.get(object.getClass())) {
            method.invoke(state);
        }
        return !state.hasErrors;
    }

    protected void info(String message, EStructuralFeature feature) {
        this.info(message, feature, -1, null, new String[0]);
    }

    protected void info(String message, EStructuralFeature feature, int index) {
        this.info(message, feature, index, null, new String[0]);
    }

    protected void info(String message, EStructuralFeature feature, int index, String code, String ... issueData) {
        this.info(message, this.state.get().currentObject, feature, index, code, issueData);
    }

    protected void info(String message, EStructuralFeature feature, String code, String ... issueData) {
        this.info(message, this.state.get().currentObject, feature, -1, code, issueData);
    }

    protected void info(String message, EObject source, EStructuralFeature feature) {
        this.info(message, source, feature, -1, null, new String[0]);
    }

    protected void info(String message, EObject source, EStructuralFeature feature, int index) {
        this.info(message, source, feature, index, null, new String[0]);
    }

    protected void info(String message, EObject source, EStructuralFeature feature, int index, String code, String ... issueData) {
        this.getMessageAcceptor().acceptInfo(message, source, feature, index, code, issueData);
    }

    protected void info(String message, EObject source, EStructuralFeature feature, String code, String ... issueData) {
        this.getMessageAcceptor().acceptInfo(message, source, feature, -1, code, issueData);
    }

    protected void warning(String message, EStructuralFeature feature) {
        this.warning(message, feature, -1, null, new String[0]);
    }

    protected void warning(String message, EStructuralFeature feature, int index) {
        this.warning(message, feature, index, null, new String[0]);
    }

    protected void warning(String message, EStructuralFeature feature, String code, String ... issueData) {
        this.warning(message, this.state.get().currentObject, feature, -1, code, issueData);
    }

    protected void warning(String message, EStructuralFeature feature, int index, String code, String ... issueData) {
        this.warning(message, this.state.get().currentObject, feature, index, code, issueData);
    }

    protected void warning(String message, EObject source, EStructuralFeature feature) {
        this.warning(message, source, feature, -1);
    }

    protected void warning(String message, EObject source, EStructuralFeature feature, int index) {
        this.warning(message, source, feature, index, null, new String[0]);
    }

    protected void warning(String message, EObject source, EStructuralFeature feature, int index, String code, String ... issueData) {
        this.getMessageAcceptor().acceptWarning(message, source, feature, index, code, issueData);
    }

    protected void warning(String message, EObject source, EStructuralFeature feature, String code, String ... issueData) {
        this.getMessageAcceptor().acceptWarning(message, source, feature, -1, code, issueData);
    }

    protected void error(String message, EStructuralFeature feature) {
        this.error(message, feature, -1, null, new String[0]);
    }

    protected void error(String message, EStructuralFeature feature, int index) {
        this.error(message, feature, index, null, new String[0]);
    }

    protected void error(String message, EStructuralFeature feature, String code, String ... issueData) {
        this.error(message, feature, -1, code, issueData);
    }

    protected void error(String message, EStructuralFeature feature, int index, String code, String ... issueData) {
        this.error(message, this.state.get().currentObject, feature, index, code, issueData);
    }

    protected void error(String message, EObject source, EStructuralFeature feature) {
        this.error(message, source, feature, -1);
    }

    protected void error(String message, EObject source, EStructuralFeature feature, int index) {
        this.error(message, source, feature, index, null, new String[0]);
    }

    protected void error(String message, EObject source, EStructuralFeature feature, String code, String ... issueData) {
        this.getMessageAcceptor().acceptError(message, source, feature, -1, code, issueData);
    }

    protected void error(String message, EObject source, EStructuralFeature feature, int index, String code, String ... issueData) {
        this.getMessageAcceptor().acceptError(message, source, feature, index, code, issueData);
    }

    protected void addIssueToState(String issueCode, String message, EStructuralFeature feature) {
        this.addIssue(message, this.state.get().currentObject, feature, issueCode, null);
    }

    protected void addIssue(String message, EObject source, String issueCode) {
        this.addIssue(message, source, null, issueCode, null);
    }

    protected void addIssue(String message, EObject source, EStructuralFeature feature, String issueCode, String ... issueData) {
        this.addIssue(message, source, feature, -1, issueCode, issueData);
    }

    protected void addIssue(String message, EObject source, EStructuralFeature feature, int index, String issueCode, String ... issueData) {
        Severity severity = this.getIssueSeverities(this.getContext(), this.getCurrentObject()).getSeverity(issueCode);
        if (severity != null) {
            switch (severity) {
                case WARNING: {
                    this.getMessageAcceptor().acceptWarning(message, source, feature, index, issueCode, issueData);
                    break;
                }
                case INFO: {
                    this.getMessageAcceptor().acceptInfo(message, source, feature, index, issueCode, issueData);
                    break;
                }
                case ERROR: {
                    this.getMessageAcceptor().acceptError(message, source, feature, index, issueCode, issueData);
                    break;
                }
            }
        }
    }

    protected void addIssue(String message, EObject source, int offset, int length, String issueCode) {
        this.addIssue(message, source, offset, length, issueCode, null);
    }

    protected void addIssue(String message, EObject source, int offset, int length, String issueCode, String ... issueData) {
        Severity severity = this.getIssueSeverities(this.getContext(), this.getCurrentObject()).getSeverity(issueCode);
        if (severity != null) {
            switch (severity) {
                case WARNING: {
                    this.getMessageAcceptor().acceptWarning(message, source, offset, length, issueCode, issueData);
                    break;
                }
                case INFO: {
                    this.getMessageAcceptor().acceptInfo(message, source, offset, length, issueCode, issueData);
                    break;
                }
                case ERROR: {
                    this.getMessageAcceptor().acceptError(message, source, offset, length, issueCode, issueData);
                    break;
                }
            }
        }
    }

    protected boolean isIgnored(String issueCode) {
        IssueSeverities severities = this.getIssueSeverities(this.getContext(), this.getCurrentObject());
        return severities.isIgnored(issueCode);
    }

    protected IssueSeverities getIssueSeverities(Map<Object, Object> context, EObject eObject) {
        if (context.containsKey(ISSUE_SEVERITIES)) {
            return (IssueSeverities)context.get(ISSUE_SEVERITIES);
        }
        IssueSeverities issueSeverities = this.issueSeveritiesProvider.getIssueSeverities(eObject.eResource());
        context.put(ISSUE_SEVERITIES, issueSeverities);
        return issueSeverities;
    }

    protected void guard(boolean guardExpression) {
        if (!guardExpression) {
            throw guardException;
        }
    }

    protected void checkDone() {
        throw guardException;
    }

    @Override
    public void acceptError(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
        this.checkIsFromCurrentlyCheckedResource(object);
        this.state.get().hasErrors = true;
        this.state.get().chain.add(this.createDiagnostic(Severity.ERROR, message, object, feature, index, code, issueData));
    }

    protected void checkIsFromCurrentlyCheckedResource(EObject object) {
        if (object != null && this.state.get() != null && this.state.get().currentObject != null && object.eResource() != this.state.get().currentObject.eResource()) {
            URI uriGiven = null;
            if (object.eResource() != null) {
                uriGiven = object.eResource().getURI();
            }
            URI uri = null;
            if (this.state.get().currentObject.eResource() != null) {
                uri = this.state.get().currentObject.eResource().getURI();
            }
            throw new IllegalArgumentException("You can only add issues for EObjects contained in the currently validated resource '" + uri + "'. But the given EObject was contained in '" + uriGiven + "'");
        }
    }

    @Override
    public void acceptWarning(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
        this.checkIsFromCurrentlyCheckedResource(object);
        this.state.get().chain.add(this.createDiagnostic(Severity.WARNING, message, object, feature, index, code, issueData));
    }

    @Override
    public void acceptInfo(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
        this.checkIsFromCurrentlyCheckedResource(object);
        this.state.get().chain.add(this.createDiagnostic(Severity.INFO, message, object, feature, index, code, issueData));
    }

    @Override
    public void acceptError(String message, EObject object, int offset, int length, String code, String ... issueData) {
        this.checkIsFromCurrentlyCheckedResource(object);
        this.state.get().hasErrors = true;
        this.state.get().chain.add(this.createDiagnostic(Severity.ERROR, message, object, offset, length, code, issueData));
    }

    @Override
    public void acceptWarning(String message, EObject object, int offset, int length, String code, String ... issueData) {
        this.checkIsFromCurrentlyCheckedResource(object);
        this.state.get().chain.add(this.createDiagnostic(Severity.WARNING, message, object, offset, length, code, issueData));
    }

    @Override
    public void acceptInfo(String message, EObject object, int offset, int length, String code, String ... issueData) {
        this.checkIsFromCurrentlyCheckedResource(object);
        this.state.get().chain.add(this.createDiagnostic(Severity.INFO, message, object, offset, length, code, issueData));
    }

    protected Diagnostic createDiagnostic(Severity severity, String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
        int diagnosticSeverity = this.toDiagnosticSeverity(severity);
        FeatureBasedDiagnostic result = new FeatureBasedDiagnostic(diagnosticSeverity, message, object, feature, index, this.state.get().currentCheckType, code, issueData);
        return result;
    }

    protected Diagnostic createDiagnostic(Severity severity, String message, EObject object, int offset, int length, String code, String ... issueData) {
        int diagnosticSeverity = this.toDiagnosticSeverity(severity);
        RangeBasedDiagnostic result = new RangeBasedDiagnostic(diagnosticSeverity, message, object, offset, length, this.state.get().currentCheckType, code, issueData);
        return result;
    }

    protected int toDiagnosticSeverity(Severity severity) {
        int diagnosticSeverity = -1;
        switch (severity) {
            case ERROR: {
                diagnosticSeverity = 4;
                break;
            }
            case WARNING: {
                diagnosticSeverity = 2;
                break;
            }
            case INFO: {
                diagnosticSeverity = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow severity " + (Object)((Object)severity));
            }
        }
        return diagnosticSeverity;
    }

    public StateAccess setMessageAcceptor(ValidationMessageAcceptor messageAcceptor) {
        this.messageAcceptor = messageAcceptor;
        return new StateAccess(this);
    }

    public ValidationMessageAcceptor getMessageAcceptor() {
        return this.messageAcceptor;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MethodWrapper {
        private final Method method;
        private final String s;
        private final AbstractDeclarativeValidator instance;

        protected MethodWrapper(AbstractDeclarativeValidator instance, Method m) {
            this.instance = instance;
            this.method = m;
            this.s = String.valueOf(m.getName()) + ":" + m.getParameterTypes()[0].getName();
        }

        public int hashCode() {
            return this.s.hashCode() ^ this.instance.hashCode();
        }

        public boolean isMatching(Class<?> param) {
            return this.method.getParameterTypes()[0].isAssignableFrom(param);
        }

        public void invoke(State state) {
            boolean wasNull;
            if (this.instance.state.get() != null && this.instance.state.get() != state) {
                throw new IllegalStateException("State is already assigned.");
            }
            boolean bl = wasNull = this.instance.state.get() == null;
            if (wasNull) {
                this.instance.state.set(state);
            }
            try {
                Check annotation = this.method.getAnnotation(Check.class);
                if (!state.checkMode.shouldCheck(annotation.value())) {
                    return;
                }
                try {
                    state.currentMethod = this.method;
                    state.currentCheckType = annotation.value();
                    this.method.setAccessible(true);
                    this.method.invoke((Object)this.instance, state.currentObject);
                }
                catch (IllegalArgumentException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    Throwable targetException = e.getTargetException();
                    this.handleInvocationTargetException(targetException, state);
                }
            }
            finally {
                if (wasNull) {
                    this.instance.state.set(null);
                }
            }
        }

        protected void handleInvocationTargetException(Throwable targetException, State state) {
            if (!(targetException instanceof GuardException) && !(targetException instanceof NullPointerException)) {
                Exceptions.throwUncheckedException(targetException);
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MethodWrapper)) {
                return false;
            }
            MethodWrapper mw = (MethodWrapper)obj;
            return this.s.equals(mw.s) && this.instance == mw.instance;
        }

        public AbstractDeclarativeValidator getInstance() {
            return this.instance;
        }

        public Method getMethod() {
            return this.method;
        }
    }

    public static class State {
        public DiagnosticChain chain = null;
        public EObject currentObject = null;
        public Method currentMethod = null;
        public CheckMode checkMode = null;
        public CheckType currentCheckType = null;
        public boolean hasErrors = false;
        public Map<Object, Object> context;
    }

    public static class StateAccess {
        private AbstractDeclarativeValidator validator;

        private StateAccess(AbstractDeclarativeValidator validator) {
            this.validator = validator;
        }

        public State getState() {
            State result = (State)this.validator.state.get();
            if (result == null) {
                result = new State();
                this.validator.state.set(result);
            }
            return result;
        }
    }
}

