/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit4.smoketest;

import com.google.common.annotations.Beta;
import com.google.common.collect.Iterables;
import java.io.InputStream;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.junit4.smoketest.DeltaScenarioProcessor;
import org.eclipse.xtext.junit4.smoketest.ScenarioProcessor;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.util.StringInputStream;
import org.junit.Assert;

@Beta
public enum Scenario {
    SkipLastCharacters{

        @Override
        public void processInput(String input, DeltaScenarioProcessor tester) throws Exception {
            String data = "";
            tester.processFile(input, data, 0, 0, "");
            int i = 0;
            while (i < input.length()) {
                data = tester.processFile(input, data, data.length(), 0, input.charAt(i));
                ++i;
            }
        }
    }
    ,
    SkipFirstCharacters{

        @Override
        public void processInput(String input, DeltaScenarioProcessor tester) throws Exception {
            String data = input;
            tester.processFile(input, data, 0, 0, "");
            int i = 0;
            while (i < input.length()) {
                data = tester.processFile(input, data, 0, 1, "");
                ++i;
            }
        }
    }
    ,
    SkipCharacterInBetween{

        @Override
        public void processInput(String input, DeltaScenarioProcessor tester) throws Exception {
            if (input.length() > 1) {
                String data = input.substring(1);
                int i = 0;
                while (i < input.length() - 1) {
                    data = tester.processFile(input, data, i, 1, input.charAt(i));
                    ++i;
                }
            }
        }
    }
    ,
    SkipTokensInBetween{

        @Override
        public void processInput(String input, DeltaScenarioProcessor tester) throws Exception {
            XtextResource resource = tester.get(XtextResource.class);
            resource.setURI(URI.createURI((String)"dummy.uri"));
            try {
                resource.load((InputStream)new StringInputStream(input, "UTF-8"), Collections.singletonMap(XtextResource.OPTION_ENCODING, "UTF-8"));
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
            ICompositeNode rootNode = resource.getParseResult().getRootNode();
            for (ILeafNode token : rootNode.getLeafNodes()) {
                int start = token.getTotalOffset();
                int length = token.getTotalLength();
                if (length <= 1 || length == 3) continue;
                tester.processFile(input, input, start, length, "");
            }
        }
    }
    ,
    SkipNodesInBetween{

        @Override
        public void processInput(String input, DeltaScenarioProcessor tester) throws Exception {
            XtextResource resource = tester.get(XtextResource.class);
            resource.setURI(URI.createURI((String)"dummy.uri"));
            try {
                resource.load((InputStream)new StringInputStream(input, "UTF-8"), Collections.singletonMap(XtextResource.OPTION_ENCODING, "UTF-8"));
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
            ICompositeNode rootNode = resource.getParseResult().getRootNode();
            ReplaceRegion region = null;
            for (INode node : rootNode.getAsTreeIterable()) {
                int offset = node.getTotalOffset();
                int length = node.getTotalLength();
                if (length == 0 || region != null && region.getOffset() == offset && region.getLength() == length) continue;
                region = new ReplaceRegion(offset, length, "");
                if (Iterables.size(node.getLeafNodes()) <= 1 || length <= 1 || length == 3) continue;
                tester.processFile(input, input, offset, length, "");
            }
        }
    }
    ,
    SkipThreeCharactersInBetween{

        @Override
        public void processInput(String input, DeltaScenarioProcessor tester) throws Exception {
            if (input.length() > 3) {
                String data = input.substring(3);
                tester.processFile(input, data, 0, 0, "");
                int i = 0;
                while (i < input.length() - 3) {
                    data = tester.processFile(input, data, i, 1, input.charAt(i));
                    ++i;
                }
            }
        }
    };


    private Scenario() {
    }

    public void processInput(String input, ScenarioProcessor tester) throws Exception {
        if (tester instanceof DeltaScenarioProcessor) {
            this.processInput(input, (DeltaScenarioProcessor)tester);
        } else {
            this.processInput(input, new DeltaScenarioProcessor.Adapter(tester));
        }
    }

    public abstract void processInput(String var1, DeltaScenarioProcessor var2) throws Exception;

    /* synthetic */ Scenario(String string, int n, Scenario scenario) {
        this();
    }
}

