/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit4.formatter;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.LinkedHashMap;
import org.eclipse.xtext.formatting2.FormatterRequest;
import org.eclipse.xtext.preferences.ITypedPreferenceValues;
import org.eclipse.xtext.preferences.MapBasedPreferenceValues;
import org.eclipse.xtext.xbase.lib.Procedures;

public class FormatterTestRequest {
    boolean allowSyntaxErrors = false;
    private CharSequence expectation;
    private FormatterRequest request;
    private CharSequence toBeFormatted;

    public CharSequence getExpectation() {
        return this.expectation;
    }

    public CharSequence getExpectationOrToBeFormatted() {
        if (this.expectation != null) {
            return this.expectation;
        }
        return this.toBeFormatted;
    }

    public MapBasedPreferenceValues getOrCreateMapBasedPreferences() {
        ITypedPreferenceValues preferences = this.request.getPreferences();
        if (preferences instanceof MapBasedPreferenceValues) {
            return (MapBasedPreferenceValues)preferences;
        }
        LinkedHashMap newMap = Maps.newLinkedHashMap();
        MapBasedPreferenceValues result = new MapBasedPreferenceValues(preferences, newMap);
        this.request.setPreferences(result);
        return result;
    }

    public FormatterRequest getRequest() {
        return this.request;
    }

    public CharSequence getToBeFormatted() {
        return this.toBeFormatted;
    }

    public boolean isAllowSyntaxErrors() {
        return this.allowSyntaxErrors;
    }

    public FormatterTestRequest preferences(Procedures.Procedure1<MapBasedPreferenceValues> preferences) {
        MapBasedPreferenceValues map = this.getOrCreateMapBasedPreferences();
        preferences.apply((Object)map);
        return this;
    }

    public FormatterTestRequest setAllowSyntaxErrors(boolean allowSyntaxErrors) {
        this.allowSyntaxErrors = allowSyntaxErrors;
        return this;
    }

    public FormatterTestRequest setExpectation(CharSequence expectation) {
        this.expectation = expectation;
        return this;
    }

    @Inject
    public FormatterTestRequest setRequest(FormatterRequest request) {
        this.request = request;
        return this;
    }

    public FormatterTestRequest setToBeFormatted(CharSequence toBeFormatted) {
        this.toBeFormatted = toBeFormatted;
        return this;
    }
}

