/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.logging.Logger;
import javax.json.bind.JsonbException;
import javax.json.bind.serializer.JsonbSerializer;
import javax.json.bind.serializer.SerializationContext;
import javax.json.stream.JsonGenerationException;
import javax.json.stream.JsonGenerator;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.ProcessingContext;
import org.eclipse.yasson.internal.model.JsonBindingModel;
import org.eclipse.yasson.internal.model.JsonContext;
import org.eclipse.yasson.internal.model.JsonbPropertyInfo;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.AbstractValueTypeSerializer;
import org.eclipse.yasson.internal.serializer.ContainerModel;
import org.eclipse.yasson.internal.serializer.ContainerSerializerProvider;
import org.eclipse.yasson.internal.serializer.SerializerBuilder;

public class Marshaller
extends ProcessingContext
implements SerializationContext {
    private static final Logger logger = Logger.getLogger(Marshaller.class.getName());
    private Type runtimeType;

    public Marshaller(JsonbContext jsonbContext, Type rootRuntimeType) {
        super(jsonbContext);
        this.runtimeType = rootRuntimeType;
    }

    public Marshaller(JsonbContext jsonbContext) {
        super(jsonbContext);
        this.runtimeType = null;
    }

    public void marshall(Object object, JsonGenerator jsonGenerator) {
        try {
            ContainerModel model = new ContainerModel(this.runtimeType != null ? this.runtimeType : object.getClass(), null, JsonContext.ROOT, null);
            this.serializeRoot(object, jsonGenerator, model);
        }
        catch (JsonbException e) {
            logger.severe(e.getMessage());
            throw e;
        }
        finally {
            try {
                jsonGenerator.close();
            }
            catch (JsonGenerationException jge) {
                logger.severe(jge.getMessage());
            }
        }
    }

    public <T> void serialize(String key, T object, JsonGenerator generator) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(object);
        ContainerModel model = new ContainerModel(object.getClass(), null, JsonContext.JSON_OBJECT, key);
        this.serializeRoot(object, generator, model);
    }

    public <T> void serialize(T object, JsonGenerator generator) {
        Objects.requireNonNull(object);
        ContainerModel model = new ContainerModel(object.getClass(), null, JsonContext.JSON_ARRAY, null);
        this.serializeRoot(object, generator, model);
    }

    public <T> void serializeRoot(T root, JsonGenerator generator, JsonBindingModel model) {
        JsonbSerializer<?> rootSerializer = this.getRootSerializer(root.getClass(), model);
        if (this.jsonbContext.getConfigProperties().isStrictIJson() && rootSerializer instanceof AbstractValueTypeSerializer) {
            throw new JsonbException(Messages.getMessage(MessageKeys.IJSON_ENABLED_SINGLE_VALUE, new Object[0]));
        }
        rootSerializer.serialize(root, generator, (SerializationContext)this);
    }

    private JsonbSerializer<?> getRootSerializer(Class<?> rootClazz, JsonBindingModel model) {
        ContainerSerializerProvider serializerProvider = this.getMappingContext().getSerializerProvider(rootClazz);
        if (serializerProvider != null) {
            return serializerProvider.provideSerializer(new JsonbPropertyInfo().withRuntimeType(this.runtimeType).withClassModel(this.getMappingContext().getClassModel(rootClazz)).withJsonBindingModel(model));
        }
        return ((SerializerBuilder)((SerializerBuilder)new SerializerBuilder(this.jsonbContext).withObjectClass(rootClazz).withType(model.getType())).withModel(model)).build();
    }
}

