/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.lang.reflect.Type;
import javax.json.bind.JsonbException;
import javax.json.bind.serializer.DeserializationContext;
import javax.json.bind.serializer.JsonbDeserializer;
import javax.json.stream.JsonParser;
import org.eclipse.yasson.internal.Unmarshaller;
import org.eclipse.yasson.internal.components.AdapterBinding;
import org.eclipse.yasson.internal.model.ClassModel;
import org.eclipse.yasson.internal.model.JsonBindingModel;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.AbstractContainerDeserializer;
import org.eclipse.yasson.internal.serializer.CurrentItem;

public class AdaptedObjectDeserializer<A, T>
implements CurrentItem<T>,
JsonbDeserializer<T> {
    private JsonbDeserializer<A> adaptedItem;
    private final AdapterBinding adapterInfo;
    private final AbstractContainerDeserializer<?> wrapperItem;

    public AdaptedObjectDeserializer(AdapterBinding adapterInfo, AbstractContainerDeserializer<?> wrapperItem) {
        this.adapterInfo = adapterInfo;
        this.wrapperItem = wrapperItem;
    }

    @Override
    public ClassModel getClassModel() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CurrentItem<?> getWrapper() {
        return this.wrapperItem;
    }

    @Override
    public JsonBindingModel getWrapperModel() {
        return ((AbstractContainerDeserializer)this.adaptedItem).getWrapperModel();
    }

    @Override
    public Type getRuntimeType() {
        if (this.adaptedItem instanceof AbstractContainerDeserializer) {
            return ((AbstractContainerDeserializer)this.adaptedItem).getRuntimeType();
        }
        throw new JsonbException(Messages.getMessage(MessageKeys.INTERNAL_ERROR, "Deserialization propagation is not allowed for:" + this.adaptedItem));
    }

    public void setAdaptedItem(JsonbDeserializer<A> adaptedItem) {
        this.adaptedItem = adaptedItem;
    }

    public T deserialize(JsonParser parser, DeserializationContext context, Type rtType) {
        Unmarshaller unmarshaller = (Unmarshaller)context;
        unmarshaller.setCurrent(this);
        try {
            unmarshaller.getJsonbContext().addProcessedType(this.adapterInfo.getBindingType());
            Object result = this.adaptedItem.deserialize(parser, context, rtType);
            Object adapted = this.adapterInfo.getAdapter().adaptFromJson(result);
            unmarshaller.setCurrent(this.wrapperItem);
            Object object = adapted;
            return (T)object;
        }
        catch (Exception e) {
            throw new JsonbException(Messages.getMessage(MessageKeys.ADAPTER_EXCEPTION, this.adapterInfo.getBindingType(), this.adapterInfo.getToType(), this.adapterInfo.getAdapter().getClass()), (Throwable)e);
        }
        finally {
            unmarshaller.getJsonbContext().removeProcessedType(this.adapterInfo.getBindingType());
        }
    }
}

