/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal;

import jakarta.json.bind.JsonbException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.model.ClassModel;
import org.eclipse.yasson.internal.model.CreatorModel;
import org.eclipse.yasson.internal.model.JsonbAnnotatedElement;
import org.eclipse.yasson.internal.model.JsonbCreator;
import org.eclipse.yasson.internal.model.Property;
import org.eclipse.yasson.internal.model.PropertyModel;
import org.eclipse.yasson.internal.model.ReflectionPropagation;
import org.eclipse.yasson.internal.model.customization.CreatorCustomization;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;

class ClassParser {
    private static final String IS_PREFIX = "is";
    private static final String GET_PREFIX = "get";
    private static final String SET_PREFIX = "set";
    private final JsonbContext jsonbContext;

    ClassParser(JsonbContext jsonbContext) {
        this.jsonbContext = jsonbContext;
    }

    void parseProperties(ClassModel classModel, JsonbAnnotatedElement<Class<?>> classElement) {
        HashMap<String, Property> classProperties = new HashMap<String, Property>();
        this.parseFields(classElement, classProperties);
        this.parseClassAndInterfaceMethods(classElement, classProperties);
        List<PropertyModel> sortedParentProperties = this.getSortedParentProperties(classModel, classElement, classProperties);
        List<PropertyModel> classPropertyModels = classProperties.values().stream().map(property -> new PropertyModel(classModel, (Property)property, this.jsonbContext)).collect(Collectors.toList());
        ArrayList<PropertyModel> unsortedMerged = new ArrayList<PropertyModel>(sortedParentProperties.size() + classPropertyModels.size());
        unsortedMerged.addAll(sortedParentProperties);
        unsortedMerged.addAll(classPropertyModels);
        this.checkPropertyNameClash(unsortedMerged, classModel.getType());
        this.mergePropertyModels(classPropertyModels);
        ArrayList<PropertyModel> sortedPropertyModels = new ArrayList<PropertyModel>(sortedParentProperties.size() + classPropertyModels.size());
        sortedPropertyModels.addAll(sortedParentProperties);
        sortedPropertyModels.addAll(this.jsonbContext.getConfigProperties().getPropertyOrdering().orderProperties(classPropertyModels, classModel));
        JsonbCreator creator = classModel.getClassCustomization().getCreator();
        if (creator != null) {
            sortedPropertyModels.forEach(propertyModel -> {
                for (CreatorModel creatorModel : creator.getParams()) {
                    if (!creatorModel.getName().equals(propertyModel.getPropertyName())) continue;
                    CreatorCustomization customization = creatorModel.getCustomization();
                    customization.setPropertyModel((PropertyModel)propertyModel);
                }
            });
        }
        classModel.setProperties(sortedPropertyModels);
    }

    private void mergePropertyModels(List<PropertyModel> unsortedMerged) {
        PropertyModel[] clone = unsortedMerged.toArray(new PropertyModel[unsortedMerged.size()]);
        for (int i = 0; i < clone.length; ++i) {
            for (int j = i + 1; j < clone.length; ++j) {
                if (!clone[i].equals(clone[j])) continue;
                unsortedMerged.remove(clone[i]);
                unsortedMerged.remove(clone[j]);
                unsortedMerged.add(new PropertyModel(clone[i], clone[j]));
            }
        }
    }

    private void parseClassAndInterfaceMethods(JsonbAnnotatedElement<Class<?>> classElement, Map<String, Property> classProperties) {
        Class<?> concreteClass = classElement.getElement();
        this.parseMethods(concreteClass, classElement, classProperties);
        for (Class<?> ifc : this.jsonbContext.getAnnotationIntrospector().collectInterfaces(concreteClass)) {
            this.parseIfaceMethodAnnotations(ifc, classElement, classProperties);
        }
    }

    private void parseIfaceMethodAnnotations(Class<?> ifc, JsonbAnnotatedElement<Class<?>> classElement, Map<String, Property> classProperties) {
        Method[] declaredMethods;
        for (Method method : declaredMethods = AccessController.doPrivileged(ifc::getDeclaredMethods)) {
            String methodName = method.getName();
            if (!this.isPropertyMethod(method)) continue;
            String propertyName = this.toPropertyMethod(methodName);
            Property property = classProperties.get(propertyName);
            if (method.isDefault()) {
                if (property == null) {
                    property = this.registerMethod(propertyName, method, classElement, classProperties);
                } else if (this.isSetter(method)) {
                    if (property.getSetter() == null) {
                        property.setSetter(method);
                    }
                } else if (property.getGetter() == null) {
                    property.setGetter(method);
                }
            }
            if (property == null) continue;
            JsonbAnnotatedElement<Method> methodElement = this.isGetter(method) ? property.getGetterElement() : property.getSetterElement();
            for (Annotation ann : method.getDeclaredAnnotations()) {
                if (methodElement.getAnnotation(ann.annotationType()) != null) continue;
                methodElement.putAnnotation(ann);
            }
        }
    }

    private Property registerMethod(String propertyName, Method method, JsonbAnnotatedElement<Class<?>> classElement, Map<String, Property> classProperties) {
        Property property = classProperties.computeIfAbsent(propertyName, n -> new Property((String)n, classElement));
        if (this.isSetter(method)) {
            property.setSetter(method);
        } else {
            property.setGetter(method);
        }
        return property;
    }

    private void parseMethods(Class<?> clazz, JsonbAnnotatedElement<Class<?>> classElement, Map<String, Property> classProperties) {
        Method[] declaredMethods;
        for (Method method : declaredMethods = AccessController.doPrivileged(clazz::getDeclaredMethods)) {
            String name = method.getName();
            if (!this.isPropertyMethod(method) || method.isBridge() || this.isSpecialCaseMethod(clazz, method)) continue;
            String propertyName = this.toPropertyMethod(name);
            this.registerMethod(propertyName, method, classElement, classProperties);
        }
    }

    private boolean isSpecialCaseMethod(Class<?> clazz, Method m) {
        if (!Modifier.isPublic(m.getModifiers()) || Modifier.isStatic(m.getModifiers()) || m.isSynthetic()) {
            return false;
        }
        if (m.getName().equals("getMetaClass") && m.getReturnType().getCanonicalName().equals("groovy.lang.MetaClass")) {
            return true;
        }
        return m.getName().equals("getMetadata") && m.getReturnType().getCanonicalName().equals("org.jboss.weld.proxy.WeldClientProxy$Metadata");
    }

    private boolean isGetter(Method m) {
        return (m.getName().startsWith(GET_PREFIX) || m.getName().startsWith(IS_PREFIX)) && m.getParameterCount() == 0;
    }

    private boolean isSetter(Method m) {
        return m.getName().startsWith(SET_PREFIX) && m.getParameterCount() == 1;
    }

    private String toPropertyMethod(String name) {
        return this.lowerFirstLetter(name.substring(name.startsWith(IS_PREFIX) ? 2 : 3, name.length()));
    }

    private String lowerFirstLetter(String name) {
        Objects.requireNonNull(name);
        if (name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private boolean isPropertyMethod(Method m) {
        return this.isGetter(m) || this.isSetter(m);
    }

    private void parseFields(JsonbAnnotatedElement<Class<?>> classElement, Map<String, Property> classProperties) {
        Field[] declaredFields;
        for (Field field : declaredFields = AccessController.doPrivileged(() -> ((Class)classElement.getElement()).getDeclaredFields())) {
            String name = field.getName();
            if (field.isSynthetic()) continue;
            Property property = new Property(name, classElement);
            property.setField(field);
            classProperties.put(name, property);
        }
    }

    private void checkPropertyNameClash(List<PropertyModel> collectedProperties, Class<?> cls) {
        ArrayList<PropertyModel> checkedProperties = new ArrayList<PropertyModel>();
        for (PropertyModel collectedPropertyModel : collectedProperties) {
            for (PropertyModel checkedPropertyModel : checkedProperties) {
                if ((!checkedPropertyModel.getReadName().equals(collectedPropertyModel.getReadName()) || !checkedPropertyModel.isReadable() || !collectedPropertyModel.isReadable()) && (!checkedPropertyModel.getWriteName().equals(collectedPropertyModel.getWriteName()) || !checkedPropertyModel.isWritable() || !collectedPropertyModel.isWritable())) continue;
                throw new JsonbException(Messages.getMessage(MessageKeys.PROPERTY_NAME_CLASH, checkedPropertyModel.getPropertyName(), collectedPropertyModel.getPropertyName(), cls.getName()));
            }
            checkedProperties.add(collectedPropertyModel);
        }
    }

    private List<PropertyModel> getSortedParentProperties(ClassModel classModel, JsonbAnnotatedElement<Class<?>> classElement, Map<String, Property> classProperties) {
        ArrayList<PropertyModel> sortedProperties = new ArrayList<PropertyModel>();
        if (classModel.getParentClassModel() != null) {
            for (PropertyModel parentProp : classModel.getParentClassModel().getSortedProperties()) {
                Property current = classProperties.get(parentProp.getPropertyName());
                if (current == null) {
                    sortedProperties.add(parentProp);
                    continue;
                }
                Property merged = this.mergeProperty(current, parentProp, classElement);
                ReflectionPropagation propagation = new ReflectionPropagation(current, classModel.getClassCustomization().getPropertyVisibilityStrategy());
                if (propagation.isReadable()) {
                    classProperties.replace(current.getName(), merged);
                    continue;
                }
                sortedProperties.add(new PropertyModel(classModel, merged, this.jsonbContext));
                classProperties.remove(current.getName());
            }
        }
        return sortedProperties;
    }

    private Method selectMostSpecificNonDefaultMethod(Method current, Method parent) {
        return current != null ? (parent != null && current.isDefault() && !parent.isDefault() ? parent : current) : parent;
    }

    private Property mergeProperty(Property current, PropertyModel parentProp, JsonbAnnotatedElement<Class<?>> classElement) {
        Field field = current.getField() != null ? current.getField() : parentProp.getPropagation().getField();
        Method getter = this.selectMostSpecificNonDefaultMethod(current.getGetter(), parentProp.getPropagation().getGetter());
        Method setter = this.selectMostSpecificNonDefaultMethod(current.getSetter(), parentProp.getPropagation().getSetter());
        Property merged = new Property(parentProp.getPropertyName(), classElement);
        if (field != null) {
            merged.setField(field);
        }
        if (getter != null) {
            merged.setGetter(getter);
        }
        if (setter != null) {
            merged.setSetter(setter);
        }
        return merged;
    }
}

