/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import jakarta.json.bind.serializer.JsonbSerializer;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.eclipse.yasson.internal.ComponentMatcher;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.components.AdapterBinding;
import org.eclipse.yasson.internal.components.SerializerBinding;
import org.eclipse.yasson.internal.model.customization.ComponentBoundCustomization;
import org.eclipse.yasson.internal.serializer.AbstractSerializerBuilder;
import org.eclipse.yasson.internal.serializer.AbstractValueTypeSerializer;
import org.eclipse.yasson.internal.serializer.AdaptedObjectSerializer;
import org.eclipse.yasson.internal.serializer.BooleanArraySerializer;
import org.eclipse.yasson.internal.serializer.ByteArrayBase64Serializer;
import org.eclipse.yasson.internal.serializer.ByteArraySerializer;
import org.eclipse.yasson.internal.serializer.CharArraySerializer;
import org.eclipse.yasson.internal.serializer.CollectionSerializer;
import org.eclipse.yasson.internal.serializer.DefaultSerializers;
import org.eclipse.yasson.internal.serializer.DoubleArraySerializer;
import org.eclipse.yasson.internal.serializer.FloatArraySerializer;
import org.eclipse.yasson.internal.serializer.IntArraySerializer;
import org.eclipse.yasson.internal.serializer.JsonArraySerializer;
import org.eclipse.yasson.internal.serializer.JsonObjectSerializer;
import org.eclipse.yasson.internal.serializer.LongArraySerializer;
import org.eclipse.yasson.internal.serializer.MapSerializer;
import org.eclipse.yasson.internal.serializer.ObjectArraySerializer;
import org.eclipse.yasson.internal.serializer.ObjectSerializer;
import org.eclipse.yasson.internal.serializer.ObjectSerializerProvider;
import org.eclipse.yasson.internal.serializer.OptionalObjectSerializer;
import org.eclipse.yasson.internal.serializer.SerializerProviderWrapper;
import org.eclipse.yasson.internal.serializer.ShortArraySerializer;
import org.eclipse.yasson.internal.serializer.UserSerializerSerializer;

public class SerializerBuilder
extends AbstractSerializerBuilder<SerializerBuilder> {
    private Class<?> objectClass;

    public SerializerBuilder(JsonbContext jsonbContext) {
        super(jsonbContext);
    }

    public SerializerBuilder withObjectClass(Class<?> objectClass) {
        this.objectClass = objectClass;
        return this;
    }

    public JsonbSerializer<?> build() {
        Optional<AbstractValueTypeSerializer<?>> supportedTypeSerializer;
        this.withRuntimeType(this.resolveRuntimeType());
        if (this.getCustomization() instanceof ComponentBoundCustomization) {
            ComponentBoundCustomization customization = (ComponentBoundCustomization)((Object)this.getCustomization());
            ComponentMatcher componentMatcher = this.getJsonbContext().getComponentMatcher();
            Optional<SerializerBinding<?>> userSerializer = componentMatcher.getSerializerBinding(this.getRuntimeType(), customization);
            if (userSerializer.isPresent()) {
                return new UserSerializerSerializer(this.getClassModel(), userSerializer.get().getJsonbSerializer());
            }
            Optional<AdapterBinding> adapterInfoOptional = componentMatcher.getSerializeAdapterBinding(this.getRuntimeType(), customization);
            if (adapterInfoOptional.isPresent()) {
                return new AdaptedObjectSerializer(this.getClassModel(), adapterInfoOptional.get());
            }
        }
        if ((supportedTypeSerializer = this.getSupportedTypeSerializer(this.objectClass)).isPresent()) {
            return supportedTypeSerializer.get();
        }
        if (Collection.class.isAssignableFrom(this.objectClass)) {
            return new CollectionSerializer(this);
        }
        if (Map.class.isAssignableFrom(this.objectClass)) {
            return new MapSerializer(this);
        }
        if (this.isByteArray(this.objectClass)) {
            String strategy;
            switch (strategy = this.getJsonbContext().getConfigProperties().getBinaryDataStrategy()) {
                case "BYTE": {
                    return new ByteArraySerializer(this);
                }
            }
            return new ByteArrayBase64Serializer(this.getCustomization());
        }
        if (this.objectClass.isArray() || this.getRuntimeType() instanceof GenericArrayType) {
            return this.createArrayItem(this.objectClass.getComponentType());
        }
        if (JsonValue.class.isAssignableFrom(this.objectClass)) {
            if (JsonObject.class.isAssignableFrom(this.objectClass)) {
                return new JsonObjectSerializer(this);
            }
            return new JsonArraySerializer(this);
        }
        if (Optional.class.isAssignableFrom(this.objectClass)) {
            return new OptionalObjectSerializer(this);
        }
        this.getJsonbContext().getMappingContext().addSerializerProvider(this.objectClass, new ObjectSerializerProvider());
        return new ObjectSerializer(this);
    }

    private boolean isByteArray(Class<?> rawType) {
        return rawType.isArray() && rawType.getComponentType() == Byte.TYPE;
    }

    private JsonbSerializer<?> createArrayItem(Class<?> componentType) {
        if (componentType == Byte.TYPE) {
            return new ByteArraySerializer(this);
        }
        if (componentType == Short.TYPE) {
            return new ShortArraySerializer(this);
        }
        if (componentType == Character.TYPE) {
            return new CharArraySerializer(this);
        }
        if (componentType == Integer.TYPE) {
            return new IntArraySerializer(this);
        }
        if (componentType == Long.TYPE) {
            return new LongArraySerializer(this);
        }
        if (componentType == Float.TYPE) {
            return new FloatArraySerializer(this);
        }
        if (componentType == Double.TYPE) {
            return new DoubleArraySerializer(this);
        }
        if (componentType == Boolean.TYPE) {
            return new BooleanArraySerializer(this);
        }
        return new ObjectArraySerializer(this);
    }

    private Optional<AbstractValueTypeSerializer<?>> getSupportedTypeSerializer(Class<?> rawType) {
        Optional<SerializerProviderWrapper> supportedTypeSerializerOptional = DefaultSerializers.getInstance().findValueSerializerProvider(rawType);
        if (supportedTypeSerializerOptional.isPresent()) {
            return Optional.of(supportedTypeSerializerOptional.get().getSerializerProvider().provideSerializer(this.getCustomization()));
        }
        return Optional.empty();
    }

    private Type resolveRuntimeType() {
        Type genericType = this.getGenericType();
        if (genericType != null && genericType != Object.class) {
            return genericType;
        }
        return this.objectClass;
    }
}

