/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.deserializer;

import jakarta.json.bind.JsonbException;
import jakarta.json.stream.JsonParser;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.yasson.internal.DeserializationContextImpl;
import org.eclipse.yasson.internal.deserializer.ModelDeserializer;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;

class ObjectDeserializer
implements ModelDeserializer<JsonParser> {
    private final Map<String, ModelDeserializer<JsonParser>> propertyDeserializerChains;
    private final Function<String, String> renamer;
    private final Class<?> rawClass;
    private final boolean failOnUnknownProperty;
    private final Set<String> ignoredProperties;

    ObjectDeserializer(Map<String, ModelDeserializer<JsonParser>> propertyDeserializerChains, Function<String, String> renamer, Class<?> rawClass, boolean failOnUnknownProperty, Set<String> ignoredProperties) {
        this.propertyDeserializerChains = Map.copyOf(propertyDeserializerChains);
        this.renamer = renamer;
        this.rawClass = rawClass;
        this.failOnUnknownProperty = failOnUnknownProperty;
        this.ignoredProperties = Set.copyOf(ignoredProperties);
    }

    @Override
    public Object deserialize(JsonParser parser, DeserializationContextImpl context) {
        String key = null;
        block8: while (parser.hasNext()) {
            JsonParser.Event next = parser.next();
            context.setLastValueEvent(next);
            switch (next) {
                case KEY_NAME: {
                    key = this.renamer.apply(parser.getString());
                    continue block8;
                }
                case VALUE_NULL: 
                case START_OBJECT: 
                case START_ARRAY: 
                case VALUE_STRING: 
                case VALUE_NUMBER: 
                case VALUE_FALSE: 
                case VALUE_TRUE: {
                    if (this.propertyDeserializerChains.containsKey(key)) {
                        try {
                            this.propertyDeserializerChains.get(key).deserialize(parser, context);
                            continue block8;
                        }
                        catch (JsonbException e) {
                            throw new JsonbException("Unable to deserialize property '" + key + "' because of: " + e.getMessage(), (Throwable)e);
                        }
                    }
                    if (!this.failOnUnknownProperty || this.ignoredProperties.contains(key)) continue block8;
                    throw new JsonbException(Messages.getMessage(MessageKeys.UNKNOWN_JSON_PROPERTY, key, this.rawClass));
                }
                case END_ARRAY: {
                    continue block8;
                }
                case END_OBJECT: {
                    return context.getInstance();
                }
            }
            throw new JsonbException("Unexpected state: " + next);
        }
        return context.getInstance();
    }
}

