/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.aql.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.ehrbase.openehr.sdk.aql.dto.condition.ComparisonOperatorCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.ComparisonOperatorSymbol;
import org.ehrbase.openehr.sdk.aql.dto.condition.ExistsCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.LikeCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.LogicalOperatorCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.MatchesCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.NotCondition;
import org.ehrbase.openehr.sdk.aql.dto.condition.WhereCondition;
import org.ehrbase.openehr.sdk.aql.dto.containment.AbstractContainmentExpression;
import org.ehrbase.openehr.sdk.aql.dto.containment.Containment;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentClassExpression;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentNotOperator;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentSetOperator;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentSetOperatorSymbol;
import org.ehrbase.openehr.sdk.aql.dto.containment.ContainmentVersionExpression;
import org.ehrbase.openehr.sdk.aql.dto.operand.AggregateFunction;
import org.ehrbase.openehr.sdk.aql.dto.operand.BooleanPrimitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.ColumnExpression;
import org.ehrbase.openehr.sdk.aql.dto.operand.ComparisonLeftOperand;
import org.ehrbase.openehr.sdk.aql.dto.operand.CountDistinctAggregateFunction;
import org.ehrbase.openehr.sdk.aql.dto.operand.DoublePrimitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.FunctionCall;
import org.ehrbase.openehr.sdk.aql.dto.operand.IdentifiedPath;
import org.ehrbase.openehr.sdk.aql.dto.operand.LikeOperand;
import org.ehrbase.openehr.sdk.aql.dto.operand.LongPrimitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.MatchesOperand;
import org.ehrbase.openehr.sdk.aql.dto.operand.NullPrimitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.Operand;
import org.ehrbase.openehr.sdk.aql.dto.operand.PathPredicateOperand;
import org.ehrbase.openehr.sdk.aql.dto.operand.Primitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.QueryParameter;
import org.ehrbase.openehr.sdk.aql.dto.operand.SingleRowFunction;
import org.ehrbase.openehr.sdk.aql.dto.operand.StringPrimitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.TemporalPrimitive;
import org.ehrbase.openehr.sdk.aql.dto.operand.TerminologyFunction;
import org.ehrbase.openehr.sdk.aql.dto.orderby.OrderByExpression;
import org.ehrbase.openehr.sdk.aql.dto.path.AdlRegex;
import org.ehrbase.openehr.sdk.aql.dto.path.AndOperatorPredicate;
import org.ehrbase.openehr.sdk.aql.dto.path.AqlObjectPath;
import org.ehrbase.openehr.sdk.aql.dto.path.AqlObjectPathUtil;
import org.ehrbase.openehr.sdk.aql.dto.path.ComparisonOperatorPredicate;
import org.ehrbase.openehr.sdk.aql.dto.select.SelectClause;
import org.ehrbase.openehr.sdk.aql.dto.select.SelectExpression;
import org.ehrbase.openehr.sdk.aql.parser.AqlParseException;
import org.ehrbase.openehr.sdk.aql.parser.antlr.AqlParser;
import org.ehrbase.openehr.sdk.aql.parser.antlr.AqlParserBaseVisitor;
import org.ehrbase.openehr.sdk.util.exception.SdkException;

class AqlQueryVisitor
extends AqlParserBaseVisitor<Object> {
    private final Map<String, AbstractContainmentExpression> containmentByAlias = new HashMap<String, AbstractContainmentExpression>();
    private final MultiValuedMap<String, IdentifiedPath> identifiedPathByContainmentAlias = new ArrayListValuedHashMap();
    private final List<String> errors = new ArrayList<String>();

    AqlQueryVisitor() {
    }

    @Override
    public AqlQuery visitSelectQuery(AqlParser.SelectQueryContext ctx) {
        AqlQuery aqlQuery = new AqlQuery();
        aqlQuery.setSelect(this.visitSelectClause(ctx.selectClause()));
        aqlQuery.setFrom(this.visitFromClause(ctx.fromClause()));
        if (ctx.whereClause() != null) {
            aqlQuery.setWhere((WhereCondition)this.visitWhereClause(ctx.whereClause()));
        }
        if (ctx.orderByClause() != null) {
            aqlQuery.setOrderBy((List<OrderByExpression>)this.visitOrderByClause(ctx.orderByClause()));
        }
        if (ctx.limitClause() != null) {
            AqlParser.LimitClauseContext limitClauseContext = ctx.limitClause();
            aqlQuery.setLimit(Long.parseLong(limitClauseContext.limit.getText()));
            if (limitClauseContext.offset != null) {
                aqlQuery.setOffset(Long.parseLong(limitClauseContext.offset.getText()));
            }
        }
        this.identifiedPathByContainmentAlias.entries().forEach(e -> {
            if (this.containmentByAlias.containsKey(e.getKey())) {
                ((IdentifiedPath)e.getValue()).setRoot(this.containmentByAlias.get(e.getKey()));
            } else {
                this.errors.add("unknown FROM alias '%s'".formatted(e.getKey()));
            }
        });
        return aqlQuery;
    }

    @Override
    public SelectClause visitSelectClause(AqlParser.SelectClauseContext ctx) {
        SelectClause selectClause = new SelectClause();
        selectClause.setDistinct(ctx.DISTINCT() != null);
        if (ctx.top() != null) {
            this.errors.add("Deprecated keyword 'TOP' not implemented. Use 'LIMIT'.");
        }
        selectClause.setStatement(ctx.selectExpr().stream().map(this::visitSelectExpr).collect(Collectors.toList()));
        return selectClause;
    }

    @Override
    public SelectExpression visitSelectExpr(AqlParser.SelectExprContext ctx) {
        SelectExpression selectExpression = new SelectExpression();
        selectExpression.setColumnExpression(this.visitColumnExpr(ctx.columnExpr()));
        if (ctx.aliasName != null) {
            selectExpression.setAlias(ctx.aliasName.getText());
        }
        return selectExpression;
    }

    @Override
    public ColumnExpression visitColumnExpr(AqlParser.ColumnExprContext ctx) {
        return (ColumnExpression)super.visitColumnExpr(ctx);
    }

    @Override
    public AggregateFunction visitAggregateFunctionCall(AqlParser.AggregateFunctionCallContext ctx) {
        AggregateFunction dto;
        AggregateFunction.AggregateFunctionName aqlFunction = AqlQueryVisitor.findFunctionName(ctx.name, AggregateFunction.AggregateFunctionName::valueOf);
        if (AggregateFunction.AggregateFunctionName.COUNT.equals((Object)aqlFunction) && ctx.DISTINCT() != null) {
            dto = new CountDistinctAggregateFunction();
        } else {
            dto = new AggregateFunction();
            dto.setFunctionName(aqlFunction);
        }
        AqlParser.IdentifiedPathContext identifiedPath = ctx.identifiedPath();
        if (identifiedPath != null) {
            dto.setIdentifiedPath(this.visitIdentifiedPath(identifiedPath));
        }
        return dto;
    }

    private static <F> F findFunctionName(Token name, Function<String, F> toNameNumFunc) {
        try {
            return toNameNumFunc.apply(name.getText().toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new SdkException(String.format("Unknown function %s ", name.getText()));
        }
    }

    @Override
    public Primitive visitPrimitive(AqlParser.PrimitiveContext ctx) {
        Primitive selectPrimitiveDto;
        if (ctx.BOOLEAN() != null) {
            selectPrimitiveDto = new BooleanPrimitive(Boolean.parseBoolean(ctx.getText()));
        } else if (ctx.DATE() != null || ctx.DATETIME() != null || ctx.TIME() != null) {
            selectPrimitiveDto = new TemporalPrimitive(AqlQueryVisitor.unescapeText((ParseTree)ctx));
        } else if (ctx.numericPrimitive() != null) {
            AqlParser.NumericPrimitiveContext numericPrimitiveContext = ctx.numericPrimitive();
            selectPrimitiveDto = this.visitNumericPrimitive(numericPrimitiveContext);
        } else if (ctx.STRING() != null) {
            selectPrimitiveDto = new StringPrimitive(AqlQueryVisitor.unescapeText((ParseTree)ctx));
        } else if (ctx.NULL() != null) {
            selectPrimitiveDto = NullPrimitive.INSTANCE;
        } else {
            throw new AqlParseException("Cannot handle value " + ctx.getText());
        }
        return selectPrimitiveDto;
    }

    @Override
    public Primitive visitNumericPrimitive(AqlParser.NumericPrimitiveContext ctx) {
        if (ctx.REAL() != null || ctx.SCI_REAL() != null || ctx.SCI_INTEGER() != null) {
            try {
                return new DoublePrimitive(ctx.getText());
            }
            catch (NumberFormatException e) {
                throw new AqlParseException("Precision of %s not supported".formatted(ctx.getText()), e);
            }
        }
        if (ctx.INTEGER() != null) {
            try {
                return new LongPrimitive(Long.valueOf(ctx.getText()));
            }
            catch (NumberFormatException e) {
                throw new AqlParseException("Precision of %s not supported".formatted(ctx.getText()), e);
            }
        }
        throw new AqlParseException("Cannot handle value " + ctx.getText());
    }

    @Override
    public IdentifiedPath visitIdentifiedPath(AqlParser.IdentifiedPathContext ctx) {
        IdentifiedPath selectFieldDto = new IdentifiedPath();
        String containsAlias = ctx.IDENTIFIER().getText();
        this.identifiedPathByContainmentAlias.put((Object)containsAlias, (Object)selectFieldDto);
        Optional.of(ctx).map(AqlParser.IdentifiedPathContext::pathPredicate).map(pathPredicateContext -> this.visitPathPredicate((AqlParser.PathPredicateContext)((Object)pathPredicateContext))).ifPresent(selectFieldDto::setRootPredicate);
        selectFieldDto.setPath(Optional.of(ctx).map(AqlParser.IdentifiedPathContext::objectPath).map(this::visitObjectPath).orElse(null));
        return selectFieldDto;
    }

    @Override
    public FunctionCall visitFunctionCall(AqlParser.FunctionCallContext ctx) {
        if (ctx.terminologyFunction() != null) {
            return this.visitTerminologyFunction(ctx.terminologyFunction());
        }
        SingleRowFunction dto = new SingleRowFunction();
        if (ctx.IDENTIFIER() == null) {
            dto.setFunctionName(AqlQueryVisitor.findFunctionName(ctx.name, SingleRowFunction.KnownFunctionName::valueOf));
        } else {
            dto.setFunctionName(new SingleRowFunction.CustomFunctionName(ctx.IDENTIFIER().getText()));
        }
        dto.setOperandList(ctx.terminal().stream().map(this::visitTerminal).collect(Collectors.toList()));
        return dto;
    }

    @Override
    public Operand visitTerminal(AqlParser.TerminalContext ctx) {
        if (ctx.identifiedPath() != null) {
            return this.visitIdentifiedPath(ctx.identifiedPath());
        }
        if (ctx.functionCall() != null) {
            return this.visitFunctionCall(ctx.functionCall());
        }
        if (ctx.PARAMETER() != null) {
            return this.createParameter(ctx.PARAMETER());
        }
        if (ctx.primitive() != null) {
            return this.visitPrimitive(ctx.primitive());
        }
        throw new UnsupportedOperationException("Cannot parse %s".formatted(ctx.getText()));
    }

    private QueryParameter createParameter(TerminalNode node) {
        QueryParameter queryParameter = new QueryParameter();
        queryParameter.setName(StringUtils.removeStart((String)node.getText(), (String)"$"));
        return queryParameter;
    }

    @Override
    public Containment visitFromClause(AqlParser.FromClauseContext ctx) {
        return this.visitFromExpr(ctx.fromExpr());
    }

    @Override
    public Containment visitFromExpr(AqlParser.FromExprContext ctx) {
        if (ctx.SYM_LEFT_PAREN() != null) {
            return this.visitFromExpr(ctx.fromExpr());
        }
        return this.handleContainsChain(ctx.classExprOperand(), ctx.NOT(), ctx.CONTAINS(), ctx.containsExpr());
    }

    private Containment handleContainsChain(AqlParser.ClassExprOperandContext classExprOperandContext, TerminalNode notNode, TerminalNode containsNode, AqlParser.ContainsExprContext containsExprContext) {
        AbstractContainmentExpression containmentDto;
        if (classExprOperandContext instanceof AqlParser.ClassExpressionContext) {
            AqlParser.ClassExpressionContext clc = (AqlParser.ClassExpressionContext)classExprOperandContext;
            containmentDto = this.visitClassExpression(clc);
        } else {
            containmentDto = this.visitVersionClassExpr((AqlParser.VersionClassExprContext)classExprOperandContext);
        }
        if (containsNode != null) {
            Containment contains = this.visitContainsExpr(containsExprContext);
            if (notNode != null) {
                ContainmentNotOperator not = new ContainmentNotOperator();
                not.setContainmentExpression(contains);
                containmentDto.setContains(not);
            } else {
                containmentDto.setContains(contains);
            }
        }
        return containmentDto;
    }

    @Override
    public Containment visitContainsExpr(AqlParser.ContainsExprContext ctx) {
        ContainmentSetOperatorSymbol setOperatorSymbol = this.extractSymbol(ctx);
        if (setOperatorSymbol != null) {
            ContainmentSetOperator result = new ContainmentSetOperator();
            result.setSymbol(setOperatorSymbol);
            result.setValues(this.getOperands(ctx, setOperatorSymbol));
            return result;
        }
        if (ctx.SYM_LEFT_PAREN() != null) {
            return this.visitContainsExpr(ctx.containsExpr(0));
        }
        return this.handleContainsChain(ctx.classExprOperand(), ctx.NOT(), ctx.CONTAINS(), ctx.containsExpr(0));
    }

    private List<Containment> getOperands(AqlParser.ContainsExprContext ctx, ContainmentSetOperatorSymbol symbol) {
        return IntStream.of(0, 1).mapToObj(ctx::containsExpr).map(this::visitContainsExpr).flatMap(e -> {
            ContainmentSetOperator s;
            return e instanceof ContainmentSetOperator && (s = (ContainmentSetOperator)e).getSymbol() == symbol ? s.getValues().stream() : Stream.of(e);
        }).collect(Collectors.toList());
    }

    @Override
    public ContainmentClassExpression visitClassExpression(AqlParser.ClassExpressionContext ctx) {
        ContainmentClassExpression containmentDto = new ContainmentClassExpression();
        containmentDto.setType(ctx.IDENTIFIER(0).getText());
        if (ctx.variable != null) {
            containmentDto.setIdentifier(ctx.variable.getText());
            this.containmentByAlias.put(containmentDto.getIdentifier(), containmentDto);
        }
        if (ctx.pathPredicate() != null) {
            containmentDto.setPredicates((List<AndOperatorPredicate>)this.visitPathPredicate(ctx.pathPredicate()));
        }
        return containmentDto;
    }

    @Override
    public List<AndOperatorPredicate> visitPathPredicate(AqlParser.PathPredicateContext ctx) {
        if (ctx == null) {
            return new ArrayList<AndOperatorPredicate>();
        }
        return ctx.pathPredicateAnd().stream().map(this::visitPathPredicateAnd).collect(Collectors.toList());
    }

    @Override
    public AndOperatorPredicate visitPathPredicateAnd(AqlParser.PathPredicateAndContext ctx) {
        Stream<Object> predicates = ctx.PARAMETER() != null ? Stream.of(new ComparisonOperatorPredicate(AqlObjectPathUtil.ARCHETYPE_NODE_ID, ComparisonOperatorPredicate.PredicateComparisonOperator.EQ, this.createParameter(ctx.PARAMETER()))) : (ctx.nodeConstraint() != null ? Stream.concat(Stream.of(this.visitNodeConstraint(ctx.nodeConstraint())), this.visitNameConstraint(ctx.nameConstraint()).stream()) : Stream.empty());
        predicates = Stream.concat(predicates, ctx.terminalPredicate().stream().map(this::visitTerminalPredicate));
        return new AndOperatorPredicate(predicates.collect(Collectors.toList()));
    }

    @Override
    public ComparisonOperatorPredicate visitStandardPredicate(AqlParser.StandardPredicateContext ctx) {
        String operatorSymbol = ctx.COMPARISON_OPERATOR().getText();
        ComparisonOperatorPredicate.PredicateComparisonOperator operator = ComparisonOperatorPredicate.PredicateComparisonOperator.findBySymbol(operatorSymbol).orElseThrow(() -> new AqlParseException("Unknown comparison operator %s".formatted(operatorSymbol)));
        return new ComparisonOperatorPredicate(this.visitObjectPath(ctx.objectPath()), operator, this.visitPathPredicateOperand(ctx.pathPredicateOperand()));
    }

    @Override
    public ComparisonOperatorPredicate visitTerminalPredicate(AqlParser.TerminalPredicateContext ctx) {
        if (ctx.standardPredicate() != null) {
            return this.visitStandardPredicate(ctx.standardPredicate());
        }
        if (ctx.MATCHES() != null) {
            return ComparisonOperatorPredicate.matches(this.visitObjectPath(ctx.objectPath()), new AdlRegex(AqlQueryVisitor.getFullText(ctx.CONTAINED_REGEX().getSymbol())));
        }
        throw new AqlParseException("Cannot parse nodePredicate %s".formatted(AqlQueryVisitor.getFullText(ctx)));
    }

    @Override
    public ComparisonOperatorPredicate visitNodeConstraint(AqlParser.NodeConstraintContext ctx) {
        return new ComparisonOperatorPredicate(AqlObjectPathUtil.ARCHETYPE_NODE_ID, ComparisonOperatorPredicate.PredicateComparisonOperator.EQ, new StringPrimitive(ctx.getText()));
    }

    @Override
    public List<ComparisonOperatorPredicate> visitNameConstraint(AqlParser.NameConstraintContext ctx) {
        String code;
        String termId;
        if (ctx == null) {
            return List.of();
        }
        if (ctx.PARAMETER() != null) {
            return List.of(new ComparisonOperatorPredicate(AqlObjectPathUtil.NAME_VALUE, ComparisonOperatorPredicate.PredicateComparisonOperator.EQ, this.createParameter(ctx.PARAMETER())));
        }
        if (ctx.STRING() != null) {
            return List.of(new ComparisonOperatorPredicate(AqlObjectPathUtil.NAME_VALUE, ComparisonOperatorPredicate.PredicateComparisonOperator.EQ, new StringPrimitive(AqlQueryVisitor.unescapeText((ParseTree)ctx))));
        }
        String text = AqlQueryVisitor.getFullText(ctx);
        if (ObjectUtils.anyNotNull((Object[])new Object[]{ctx.ID_CODE(), ctx.AT_CODE()})) {
            termId = "local";
            code = text;
        } else if (ctx.TERM_CODE() != null) {
            int termIdEnd = text.indexOf("::");
            int commentStart = text.indexOf(124, termIdEnd + 2);
            termId = text.substring(0, termIdEnd);
            code = text.substring(termIdEnd + 2, commentStart > 0 ? commentStart : text.length());
        } else {
            throw new AqlParseException("Cannot parse name constraint %s".formatted(text));
        }
        return List.of(new ComparisonOperatorPredicate(AqlObjectPathUtil.NAME_CODE_STRING, ComparisonOperatorPredicate.PredicateComparisonOperator.EQ, new StringPrimitive(code)), new ComparisonOperatorPredicate(AqlObjectPathUtil.NAME_TERMINOLOGY, ComparisonOperatorPredicate.PredicateComparisonOperator.EQ, new StringPrimitive(termId)));
    }

    @Override
    public PathPredicateOperand visitPathPredicateOperand(AqlParser.PathPredicateOperandContext ctx) {
        if (ctx.PARAMETER() != null) {
            return this.createParameter(ctx.PARAMETER());
        }
        if (ctx.primitive() != null) {
            return this.visitPrimitive(ctx.primitive());
        }
        if (ctx.AT_CODE() != null || ctx.ID_CODE() != null) {
            return new StringPrimitive(ctx.getText());
        }
        if (ctx.objectPath() != null) {
            return this.visitObjectPath(ctx.objectPath());
        }
        throw new AqlParseException("Failed to parse PathPredicateOperand: %s".formatted(AqlQueryVisitor.getFullText(ctx)));
    }

    @Override
    public AqlObjectPath visitObjectPath(AqlParser.ObjectPathContext ctx) {
        return new AqlObjectPath(ctx.pathPart().stream().map(this::visitPathPart).toList());
    }

    @Override
    public AqlObjectPath.PathNode visitPathPart(AqlParser.PathPartContext ctx) {
        return new AqlObjectPath.PathNode(ctx.IDENTIFIER().getText(), (List<AndOperatorPredicate>)this.visitPathPredicate(ctx.pathPredicate()));
    }

    @Override
    public ContainmentVersionExpression visitVersionClassExpr(AqlParser.VersionClassExprContext ctx) {
        AqlParser.VersionPredicateContext versionPredicateContext;
        ContainmentVersionExpression containmentVersionExpression = new ContainmentVersionExpression();
        if (ctx.variable != null) {
            containmentVersionExpression.setIdentifier(ctx.variable.getText());
            this.containmentByAlias.put(containmentVersionExpression.getIdentifier(), containmentVersionExpression);
        }
        if ((versionPredicateContext = ctx.versionPredicate()) == null) {
            containmentVersionExpression.setVersionPredicateType(ContainmentVersionExpression.VersionPredicateType.NONE);
        } else if (versionPredicateContext.ALL_VERSIONS() != null) {
            containmentVersionExpression.setVersionPredicateType(ContainmentVersionExpression.VersionPredicateType.ALL_VERSIONS);
        } else if (versionPredicateContext.LATEST_VERSION() != null) {
            containmentVersionExpression.setVersionPredicateType(ContainmentVersionExpression.VersionPredicateType.LATEST_VERSION);
        } else if (versionPredicateContext.standardPredicate() != null) {
            ComparisonOperatorPredicate comparisonOperatorPredicate = this.visitStandardPredicate(versionPredicateContext.standardPredicate());
            containmentVersionExpression.setPredicate(comparisonOperatorPredicate);
        }
        return containmentVersionExpression;
    }

    @Override
    public WhereCondition visitWhereExpr(AqlParser.WhereExprContext ctx) {
        if (ctx.identifiedExpr() != null) {
            return this.visitIdentifiedExpr(ctx.identifiedExpr());
        }
        if (ctx.NOT() != null) {
            NotCondition notCondition = new NotCondition();
            notCondition.setConditionDto(this.visitWhereExpr(ctx.whereExpr(0)));
            return notCondition;
        }
        if (ctx.SYM_RIGHT_PAREN() != null) {
            return this.visitWhereExpr(ctx.whereExpr(0));
        }
        LogicalOperatorCondition result = new LogicalOperatorCondition();
        LogicalOperatorCondition.ConditionLogicalOperatorSymbol symbol = this.extractSymbol(ctx);
        result.setSymbol(symbol);
        result.setValues(this.getOperands(ctx, symbol));
        return result;
    }

    private List<WhereCondition> getOperands(AqlParser.WhereExprContext ctx, LogicalOperatorCondition.ConditionLogicalOperatorSymbol symbol) {
        return IntStream.of(0, 1).mapToObj(ctx::whereExpr).map(this::visitWhereExpr).flatMap(e -> {
            LogicalOperatorCondition s;
            return e instanceof LogicalOperatorCondition && (s = (LogicalOperatorCondition)e).getSymbol() == symbol ? s.getValues().stream() : Stream.of(e);
        }).collect(Collectors.toList());
    }

    @Override
    public WhereCondition visitIdentifiedExpr(AqlParser.IdentifiedExprContext ctx) {
        if (ctx.COMPARISON_OPERATOR() != null) {
            ComparisonOperatorCondition comparisonOperatorCondition = new ComparisonOperatorCondition();
            comparisonOperatorCondition.setSymbol(ComparisonOperatorSymbol.fromSymbol(ctx.COMPARISON_OPERATOR().getText()));
            Operand statement = ctx.functionCall() != null ? this.visitFunctionCall(ctx.functionCall()) : this.visitIdentifiedPath(ctx.identifiedPath());
            comparisonOperatorCondition.setStatement((ComparisonLeftOperand)((Object)statement));
            comparisonOperatorCondition.setValue(this.visitTerminal(ctx.terminal()));
            return comparisonOperatorCondition;
        }
        if (ctx.likeOperand() != null) {
            LikeCondition likeCondition = new LikeCondition();
            likeCondition.setStatement(this.visitIdentifiedPath(ctx.identifiedPath()));
            likeCondition.setValue(this.visitLikeOperand(ctx.likeOperand()));
            return likeCondition;
        }
        if (ctx.SYM_LEFT_PAREN() != null) {
            return this.visitIdentifiedExpr(ctx.identifiedExpr());
        }
        if (ctx.EXISTS() != null) {
            ExistsCondition existsCondition = new ExistsCondition();
            existsCondition.setValue(this.visitIdentifiedPath(ctx.identifiedPath()));
            return existsCondition;
        }
        if (ctx.MATCHES() != null) {
            MatchesCondition matchesCondition = new MatchesCondition();
            matchesCondition.setStatement(this.visitIdentifiedPath(ctx.identifiedPath()));
            matchesCondition.setValues((List<MatchesOperand>)this.visitMatchesOperand(ctx.matchesOperand()));
            return matchesCondition;
        }
        this.errors.add("Cannot handle %s".formatted(ctx.getText()));
        return null;
    }

    @Override
    public List<MatchesOperand> visitMatchesOperand(AqlParser.MatchesOperandContext ctx) {
        if (CollectionUtils.isNotEmpty(ctx.valueListItem())) {
            return ctx.valueListItem().stream().map(this::visitValueListItem).collect(Collectors.toList());
        }
        if (ctx.terminologyFunction() != null) {
            return new ArrayList<MatchesOperand>(Collections.singletonList(this.visitTerminologyFunction(ctx.terminologyFunction())));
        }
        this.errors.add("Not implemented: MATCHES URI not yet supported");
        return new ArrayList<MatchesOperand>();
    }

    @Override
    public MatchesOperand visitValueListItem(AqlParser.ValueListItemContext ctx) {
        if (ctx.primitive() != null) {
            return this.visitPrimitive(ctx.primitive());
        }
        if (ctx.PARAMETER() != null) {
            return this.createParameter(ctx.PARAMETER());
        }
        if (ctx.terminologyFunction() != null) {
            return this.visitTerminologyFunction(ctx.terminologyFunction());
        }
        throw new IllegalArgumentException("Invalid ValueListItem");
    }

    @Override
    public LikeOperand visitLikeOperand(AqlParser.LikeOperandContext ctx) {
        if (ctx.PARAMETER() != null) {
            return this.createParameter(ctx.PARAMETER());
        }
        return new StringPrimitive(AqlQueryVisitor.unescapeText((ParseTree)ctx));
    }

    @Override
    public List<OrderByExpression> visitOrderByClause(AqlParser.OrderByClauseContext ctx) {
        return ctx.orderByExpr().stream().map(this::visitOrderByExpr).collect(Collectors.toList());
    }

    public List<String> getErrors() {
        return this.errors;
    }

    private static String getFullText(ParserRuleContext context) {
        if (context.start == null || context.stop == null || context.start.getStartIndex() < 0 || context.stop.getStopIndex() < 0) {
            return context.getText();
        }
        return context.start.getInputStream().getText(Interval.of((int)context.start.getStartIndex(), (int)context.stop.getStopIndex()));
    }

    private static String getFullText(Token token) {
        return token.getInputStream().getText(Interval.of((int)token.getStartIndex(), (int)token.getStopIndex()));
    }

    @Override
    public OrderByExpression visitOrderByExpr(AqlParser.OrderByExprContext ctx) {
        OrderByExpression orderByExpression = new OrderByExpression();
        orderByExpression.setStatement(this.visitIdentifiedPath(ctx.identifiedPath()));
        orderByExpression.setSymbol(this.extractSymbol(ctx));
        return orderByExpression;
    }

    @Override
    public TerminologyFunction visitTerminologyFunction(AqlParser.TerminologyFunctionContext ctx) {
        TerminologyFunction terminologyFunction = new TerminologyFunction();
        terminologyFunction.setOperation(AqlQueryVisitor.unescapeText((ParseTree)ctx.STRING(0)));
        terminologyFunction.setServiceApi(AqlQueryVisitor.unescapeText((ParseTree)ctx.STRING(1)));
        terminologyFunction.setUriParameters(AqlQueryVisitor.unescapeText((ParseTree)ctx.STRING(2)));
        return terminologyFunction;
    }

    private static String unescapeText(ParseTree ctxText) {
        String text = ctxText.getText();
        StringBuilder sb = new StringBuilder(text.length() - 2);
        int end = text.length() - 1;
        int pos = 1;
        while (pos < end) {
            char ch = text.charAt(pos);
            if (ch == '\\') {
                ch = text.charAt(++pos);
                switch (ch) {
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        sb.append(ch);
                        break;
                    }
                    case 'a': {
                        sb.append('\u0007');
                        break;
                    }
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'v': {
                        sb.append('\u000b');
                        break;
                    }
                    case 'u': {
                        sb.append(AqlQueryVisitor.decodeUtf(16, text.substring(pos + 1, pos + 5)));
                        pos += 4;
                        break;
                    }
                    default: {
                        if (AqlQueryVisitor.isOctal(ch)) {
                            int oCount = AqlQueryVisitor.countOctals(text, pos + 1, ch <= '3' ? 2 : 1);
                            sb.append(AqlQueryVisitor.decodeUtf(8, text.substring(pos, pos + 1 + oCount)));
                            pos += oCount;
                            break;
                        }
                        throw new IllegalArgumentException("Unsupported escaped character %s in %s".formatted(Character.valueOf(ch), text));
                    }
                }
                ++pos;
                continue;
            }
            ++pos;
            sb.append(ch);
        }
        return sb.toString();
    }

    static boolean isOctal(char ch) {
        return switch (ch) {
            case '0', '1', '2', '3', '4', '5', '6', '7' -> true;
            default -> false;
        };
    }

    static int countOctals(String text, int pos, int max) {
        int maxPos = Math.min(text.length(), pos + max);
        int count = 0;
        for (int p = pos; p < maxPos; ++p) {
            if (AqlQueryVisitor.isOctal(text.charAt(p))) {
                ++count;
                continue;
            }
            return count;
        }
        return maxPos - pos;
    }

    static String decodeUtf(int radix, String hex) {
        int codePoint = Integer.parseInt(hex, radix);
        if (Character.isISOControl(codePoint) || !Character.isValidCodePoint(codePoint)) {
            throw new IllegalArgumentException("Unsupported unicode character u%s".formatted(hex));
        }
        String string = Character.toString(codePoint);
        if (string.length() != 1 || string.codePointAt(0) != codePoint) {
            throw new IllegalArgumentException("Unsupported unicode character u%s".formatted(hex));
        }
        return string;
    }

    private OrderByExpression.OrderByDirection extractSymbol(AqlParser.OrderByExprContext ctx) {
        if (ctx.DESC() != null || ctx.DESCENDING() != null) {
            return OrderByExpression.OrderByDirection.DESC;
        }
        return OrderByExpression.OrderByDirection.ASC;
    }

    private ContainmentSetOperatorSymbol extractSymbol(AqlParser.ContainsExprContext ctx) {
        if (ctx == null) {
            return null;
        }
        if (ctx.OR() != null) {
            return ContainmentSetOperatorSymbol.OR;
        }
        if (ctx.AND() != null) {
            return ContainmentSetOperatorSymbol.AND;
        }
        return null;
    }

    private LogicalOperatorCondition.ConditionLogicalOperatorSymbol extractSymbol(AqlParser.WhereExprContext ctx) {
        if (ctx.OR() != null) {
            return LogicalOperatorCondition.ConditionLogicalOperatorSymbol.OR;
        }
        if (ctx.AND() != null) {
            return LogicalOperatorCondition.ConditionLogicalOperatorSymbol.AND;
        }
        return null;
    }
}

