/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.terminology.openehr.implementation;

import java.util.HashMap;
import java.util.Map;
import org.ehrbase.openehr.sdk.terminology.openehr.TerminologyInterface;
import org.ehrbase.openehr.sdk.terminology.openehr.TerminologyResourceException;
import org.ehrbase.openehr.sdk.terminology.openehr.implementation.AttributeCodesetMapping;
import org.ehrbase.openehr.sdk.terminology.openehr.implementation.SimpleTerminologyInterface;

public class LocalizedTerminologies {
    private Map<String, TerminologyInterface> terminologies = new HashMap<String, TerminologyInterface>();
    private AttributeCodesetMapping codesetMapping;

    public LocalizedTerminologies() throws TerminologyResourceException {
        this.terminologies.put("en", new SimpleTerminologyInterface("en"));
        this.terminologies.put("ja", new SimpleTerminologyInterface("ja"));
        this.terminologies.put("pt", new SimpleTerminologyInterface("pt"));
        this.codesetMapping = AttributeCodesetMapping.getInstance();
    }

    public TerminologyInterface locale(String language) {
        if (!this.terminologies.containsKey(language)) {
            return this.getDefault();
        }
        return this.terminologies.get(language);
    }

    public TerminologyInterface getDefault() {
        return this.terminologies.get("en");
    }

    public AttributeCodesetMapping codesetMapping() {
        return this.codesetMapping;
    }
}

