/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.terminology.openehr.implementation;

import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.support.identification.TerminologyId;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ehrbase.openehr.sdk.terminology.openehr.TerminologyAccess;

public class SimpleTerminologyAccess
implements TerminologyAccess {
    private final String id;
    private final Map<String, Set<CodePhrase>> groups;
    private final Map<String, Map<String, String>> groupLangNameToId;
    private final Map<String, Map<String, String>> codeRubrics;

    SimpleTerminologyAccess(String id) {
        this.id = id;
        this.groups = new HashMap<String, Set<CodePhrase>>();
        this.groupLangNameToId = new HashMap<String, Map<String, String>>();
        this.codeRubrics = new HashMap<String, Map<String, String>>();
    }

    static SimpleTerminologyAccess getInstance(String id) {
        return new SimpleTerminologyAccess(id);
    }

    void addGroup(String groupId, Collection<String> codes, Map<String, String> names) {
        HashSet<CodePhrase> group = new HashSet<CodePhrase>();
        for (String string : codes) {
            CodePhrase code = new CodePhrase(new TerminologyId(this.id), string);
            group.add(code);
        }
        this.groups.put(groupId, group);
        for (Map.Entry entry : names.entrySet()) {
            String lang = (String)entry.getKey();
            Map<String, String> nameToId = this.groupLangNameToId.get(lang);
            if (nameToId == null) {
                nameToId = new HashMap<String, String>();
            }
            String name = (String)entry.getValue();
            nameToId.put(name, groupId);
            this.groupLangNameToId.put(lang, nameToId);
        }
    }

    void addRubric(String lang, String code, String rubric) {
        Map<String, String> map = this.codeRubrics.get(lang);
        if (map == null) {
            map = new HashMap<String, String>();
            this.codeRubrics.put(lang, map);
        }
        map.put(code, rubric);
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public Set<CodePhrase> allCodes() {
        HashSet<CodePhrase> allCodes = new HashSet<CodePhrase>();
        for (Set<CodePhrase> codes : this.groups.values()) {
            allCodes.addAll(codes);
        }
        return allCodes;
    }

    @Override
    public Set<CodePhrase> codesForGroupId(String groupID) {
        return this.groups.get(groupID);
    }

    @Override
    public Set<CodePhrase> codesForGroupName(String name, String language) {
        Map<String, String> map = this.groupLangNameToId.get(language);
        if (map == null) {
            map = this.codeRubrics.get("en");
        }
        String groupId = map.get(name);
        return this.groups.get(groupId);
    }

    @Override
    public String rubricForCode(String code, String language) {
        Map<String, String> map = this.codeRubrics.get(language);
        if (map == null) {
            map = this.codeRubrics.get("en");
        }
        return map.get(code);
    }

    @Override
    public boolean hasCodeForGroupId(String groupId, CodePhrase code) {
        Set<CodePhrase> group = this.groups.get(groupId);
        if (group == null) {
            return false;
        }
        return group.contains(code);
    }
}

