/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.util;

import com.nedap.archie.datetime.DateTimeFormatters;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.function.Predicate;

public final class OpenEHRDateTimeParseUtils {
    public static final DateTimeFormatter ISO_8601_DATE_PARSER = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4).optionalStart().appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).optionalStart().appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).optionalEnd().optionalEnd().toFormatter().withResolverStyle(ResolverStyle.STRICT);
    public static final DateTimeFormatter ISO_8601_TIME_PARSER = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.HOUR_OF_DAY, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).append(DateTimeFormatters.ISO8601_OPTIONAL_NANOSECONDS).optionalEnd().optionalEnd().append(DateTimeFormatters.ISO8601_TIME_ZONE).toFormatter().withResolverStyle(ResolverStyle.STRICT);
    public static final DateTimeFormatter ISO_8601_DATE_TIME_PARSER = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4).optionalStart().appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).optionalStart().appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).optionalStart().appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).append(DateTimeFormatters.ISO8601_OPTIONAL_NANOSECONDS).optionalEnd().optionalEnd().append(DateTimeFormatters.ISO8601_TIME_ZONE).optionalEnd().optionalEnd().optionalEnd().toFormatter().withResolverStyle(ResolverStyle.STRICT);
    public static final DateTimeFormatter ISO_8601_DATE_COMPACT_PARSER = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4).optionalStart().appendValue(ChronoField.MONTH_OF_YEAR, 2).optionalStart().appendValue(ChronoField.DAY_OF_MONTH, 2).optionalEnd().optionalEnd().toFormatter().withResolverStyle(ResolverStyle.STRICT);
    public static final DateTimeFormatter ISO_8601_TIME_COMPACT_PARSER = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.HOUR_OF_DAY, 2).optionalStart().appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendValue(ChronoField.SECOND_OF_MINUTE, 2).append(DateTimeFormatters.ISO8601_OPTIONAL_NANOSECONDS).optionalEnd().optionalEnd().append(DateTimeFormatters.ISO8601_TIME_ZONE).toFormatter().withResolverStyle(ResolverStyle.STRICT);
    public static final DateTimeFormatter ISO_8601_DATE_TIME_COMPACT_PARSER = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4).optionalStart().appendValue(ChronoField.MONTH_OF_YEAR, 2).optionalStart().appendValue(ChronoField.DAY_OF_MONTH, 2).optionalStart().appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).optionalStart().appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendValue(ChronoField.SECOND_OF_MINUTE, 2).append(DateTimeFormatters.ISO8601_OPTIONAL_NANOSECONDS).optionalEnd().optionalEnd().append(DateTimeFormatters.ISO8601_TIME_ZONE).optionalEnd().optionalEnd().optionalEnd().toFormatter().withResolverStyle(ResolverStyle.STRICT);
    private static final Predicate<String> COMPACT_DATE_PREDICATE = s -> s.length() > 4 && s.charAt(4) != '-';
    private static final Predicate<String> COMPACT_TIME_PREDICATE = s -> s.length() > 2 && s.charAt(2) != ':';

    private OpenEHRDateTimeParseUtils() {
    }

    public static Temporal parseDate(String isoDate) {
        if (isoDate == null) {
            return null;
        }
        try {
            TemporalAccessor parsed = COMPACT_DATE_PREDICATE.test(isoDate) ? ISO_8601_DATE_COMPACT_PARSER.parse(isoDate) : ISO_8601_DATE_PARSER.parse(isoDate);
            if (parsed.isSupported(ChronoField.DAY_OF_MONTH)) {
                return LocalDate.from(parsed);
            }
            if (parsed.isSupported(ChronoField.MONTH_OF_YEAR)) {
                return YearMonth.from(parsed);
            }
            if (parsed.isSupported(ChronoField.YEAR)) {
                return Year.from(parsed);
            }
            throw new DateTimeException(isoDate + " does not provide any field required for the possible precisions:" + isoDate);
        }
        catch (DateTimeException e) {
            throw new IllegalArgumentException(e.getMessage() + ":" + isoDate, e);
        }
    }

    public static TemporalAccessor parseTime(String isoTime) {
        if (isoTime == null) {
            return null;
        }
        try {
            TemporalAccessor parsed = COMPACT_TIME_PREDICATE.test(isoTime) ? ISO_8601_TIME_COMPACT_PARSER.parse(isoTime) : ISO_8601_TIME_PARSER.parse(isoTime);
            if (parsed.isSupported(ChronoField.HOUR_OF_DAY) && parsed.isSupported(ChronoField.OFFSET_SECONDS)) {
                return OffsetTime.of(LocalTime.from(parsed), ZoneOffset.from(parsed));
            }
            if (parsed.isSupported(ChronoField.HOUR_OF_DAY)) {
                return LocalTime.from(parsed);
            }
            throw new DateTimeException(isoTime + " does not provide any field required for the possible precisions:" + isoTime);
        }
        catch (DateTimeException e) {
            throw new IllegalArgumentException(e.getMessage() + ":" + isoTime, e);
        }
    }

    public static TemporalAccessor parseDateTime(String isoDateTime) {
        if (isoDateTime == null) {
            return null;
        }
        try {
            TemporalAccessor parsed = COMPACT_DATE_PREDICATE.test(isoDateTime) ? ISO_8601_DATE_TIME_COMPACT_PARSER.parse(isoDateTime) : ISO_8601_DATE_TIME_PARSER.parse(isoDateTime);
            if (parsed.isSupported(ChronoField.HOUR_OF_DAY)) {
                if (parsed.isSupported(ChronoField.OFFSET_SECONDS)) {
                    return OffsetDateTime.of(LocalDate.from(parsed), LocalTime.from(parsed), ZoneOffset.from(parsed));
                }
                return LocalDateTime.of(LocalDate.from(parsed), LocalTime.from(parsed));
            }
            if (parsed.isSupported(ChronoField.DAY_OF_MONTH)) {
                return LocalDate.from(parsed);
            }
            if (parsed.isSupported(ChronoField.MONTH_OF_YEAR)) {
                return YearMonth.from(parsed);
            }
            if (parsed.isSupported(ChronoField.YEAR)) {
                return Year.from(parsed);
            }
            throw new DateTimeException(isoDateTime + " does not provide any field required for the possible precisions:" + isoDateTime);
        }
        catch (DateTimeException e) {
            throw new IllegalArgumentException(e.getMessage() + ":" + isoDateTime, e);
        }
    }
}

