/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.util;

import com.nedap.archie.rm.datavalues.quantity.datetime.DvDate;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvTime;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DecimalStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;

public final class OpenEHRDateTimeSerializationUtils {
    public static final DateTimeFormatter ISO_8601_DATE_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4).optionalStart().appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).optionalStart().appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).optionalEnd().optionalEnd().toFormatter();
    public static final DateTimeFormatter ISO_8601_TIME_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalEnd().optionalEnd().optionalEnd().optionalStart().appendOffsetId().optionalEnd().toFormatter().withDecimalStyle(DecimalStyle.STANDARD.withDecimalSeparator('.'));
    public static final DateTimeFormatter ISO_8601_DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4).optionalStart().appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).optionalStart().appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).optionalStart().appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalEnd().optionalEnd().optionalEnd().optionalStart().appendOffsetId().optionalEnd().optionalEnd().optionalEnd().optionalEnd().toFormatter().withDecimalStyle(DecimalStyle.STANDARD.withDecimalSeparator('.'));
    private static final LocalTime DEFAULT_TIME = LocalTime.of(0, 0);

    private OpenEHRDateTimeSerializationUtils() {
    }

    public static String formatDate(TemporalAccessor date) {
        return OpenEHRDateTimeSerializationUtils.format(date, ISO_8601_DATE_FORMATTER, ChronoField.YEAR);
    }

    public static String formatTime(TemporalAccessor time) {
        return OpenEHRDateTimeSerializationUtils.format(time, ISO_8601_TIME_FORMATTER, ChronoField.HOUR_OF_DAY);
    }

    public static String formatDateTime(TemporalAccessor dateTime) {
        return OpenEHRDateTimeSerializationUtils.format(dateTime, ISO_8601_DATE_TIME_FORMATTER, ChronoField.YEAR);
    }

    private static String format(TemporalAccessor temporal, DateTimeFormatter formatter, ChronoField lowestResolution) {
        if (temporal == null) {
            return null;
        }
        if (!temporal.isSupported(lowestResolution)) {
            throw new IllegalArgumentException("The given TemporalAccessor does not support the minimal resolution defined by openEHR: " + lowestResolution.name());
        }
        return formatter.format(temporal);
    }

    public static Long toMagnitude(DvDate date) {
        if (date == null || date.getValue() == null) {
            return null;
        }
        return OpenEHRDateTimeSerializationUtils.toLocalDate(date.getValue()).toEpochDay() + 719162L;
    }

    public static Long toMagnitude(DvDateTime dateTime) {
        Long epochSecond;
        if (dateTime == null || dateTime.getValue() == null) {
            return null;
        }
        TemporalAccessor value = dateTime.getValue();
        LocalDate date = OpenEHRDateTimeSerializationUtils.toLocalDate(value);
        if (value.isSupported(ChronoField.HOUR_OF_DAY)) {
            Pair<LocalTime, ZoneOffset> localTimeWithTz = OpenEHRDateTimeSerializationUtils.toLocalTimeAndTz(value);
            epochSecond = date.toEpochSecond((LocalTime)localTimeWithTz.getLeft(), (ZoneOffset)localTimeWithTz.getRight());
        } else {
            epochSecond = date.toEpochSecond(DEFAULT_TIME, ZoneOffset.UTC);
        }
        return epochSecond + 62135596800L;
    }

    public static Double toMagnitude(DvTime time) {
        if (time == null || time.getValue() == null) {
            return null;
        }
        TemporalAccessor value = time.getValue();
        return ((LocalTime)OpenEHRDateTimeSerializationUtils.toLocalTimeAndTz(value).getLeft()).toSecondOfDay();
    }

    private static LocalDate toLocalDate(TemporalAccessor value) {
        if (value instanceof OffsetDateTime) {
            return ((OffsetDateTime)value).toLocalDate();
        }
        if (value instanceof LocalDateTime) {
            return ((LocalDateTime)value).toLocalDate();
        }
        if (value instanceof LocalDate) {
            return (LocalDate)value;
        }
        int year = value.get(ChronoField.YEAR);
        int month = value.isSupported(ChronoField.MONTH_OF_YEAR) ? value.get(ChronoField.MONTH_OF_YEAR) : 1;
        int day = value.isSupported(ChronoField.DAY_OF_MONTH) && value.isSupported(ChronoField.MONTH_OF_YEAR) ? value.get(ChronoField.DAY_OF_MONTH) : 1;
        return LocalDate.of(year, month, day);
    }

    private static Pair<LocalTime, ZoneOffset> toLocalTimeAndTz(TemporalAccessor value) {
        if (value instanceof OffsetTime) {
            return Pair.of((Object)((OffsetTime)value).toLocalTime(), (Object)((OffsetTime)value).getOffset());
        }
        if (value instanceof LocalTime) {
            return Pair.of((Object)((LocalTime)value), (Object)ZoneOffset.UTC);
        }
        if (value instanceof OffsetDateTime) {
            return Pair.of((Object)((OffsetDateTime)value).toLocalTime(), (Object)((OffsetDateTime)value).getOffset());
        }
        if (value instanceof LocalDateTime) {
            return Pair.of((Object)((LocalDateTime)value).toLocalTime(), (Object)ZoneOffset.UTC);
        }
        int hour = value.get(ChronoField.HOUR_OF_DAY);
        int minute = value.isSupported(ChronoField.MINUTE_OF_HOUR) ? value.get(ChronoField.MINUTE_OF_HOUR) : 0;
        int second = value.isSupported(ChronoField.SECOND_OF_MINUTE) && value.isSupported(ChronoField.MINUTE_OF_HOUR) ? value.get(ChronoField.SECOND_OF_MINUTE) : 0;
        int nanoSecond = value.isSupported(ChronoField.NANO_OF_SECOND) && value.isSupported(ChronoField.SECOND_OF_MINUTE) && value.isSupported(ChronoField.MINUTE_OF_HOUR) ? value.get(ChronoField.NANO_OF_SECOND) : 0;
        return Pair.of((Object)LocalTime.of(hour, minute, second, nanoSecond), (Object)Optional.of(TemporalQueries.offset()).map(value::query).orElse(ZoneOffset.UTC));
    }
}

