/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.util.functional;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.ehrbase.openehr.sdk.util.functional.Either;

public abstract class Try<S, E extends Exception>
extends Either<S, E> {
    public static <S1, E1 extends Exception> Success<S1, E1> success(S1 result) {
        return new Success(result);
    }

    public static <S1, E1 extends Exception> Failure<S1, E1> failure(E1 failure) {
        return new Failure(failure);
    }

    protected Try(Object result) {
        super(result);
    }

    @Override
    public boolean isLeft() {
        return this.isSuccess();
    }

    @Override
    public boolean isRight() {
        return this.isFailure();
    }

    public abstract boolean isSuccess();

    public abstract boolean isFailure();

    @Override
    public abstract Object get();

    public abstract S getOrThrow() throws E;

    public abstract Success<S, E> getAsSuccess();

    public abstract Failure<S, E> getAsFailure();

    @Override
    public abstract <T> T map(BiFunction<S, E, T> var1);

    @Override
    public abstract void consume(BiConsumer<S, E> var1);

    public static class Success<S0, E0 extends Exception>
    extends Try<S0, E0> {
        private Success(S0 success) {
            super(success);
        }

        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        public boolean isFailure() {
            return false;
        }

        @Override
        public S0 get() {
            return (S0)this.value;
        }

        @Override
        public S0 getOrThrow() throws E0 {
            return this.get();
        }

        @Override
        public Success<S0, E0> getAsSuccess() {
            return this;
        }

        @Override
        public Failure<S0, E0> getAsFailure() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T map(BiFunction<S0, E0, T> map) {
            return map.apply(this.get(), null);
        }

        @Override
        public void consume(BiConsumer<S0, E0> con) {
            con.accept(this.get(), null);
        }

        @Override
        public S0 getAsLeft() {
            return this.get();
        }

        @Override
        public E0 getAsRight() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Failure<S0, E0 extends Exception>
    extends Try<S0, E0> {
        private Failure(E0 failure) {
            super(failure);
        }

        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @Override
        public E0 get() {
            return (E0)((Exception)this.value);
        }

        @Override
        public S0 getOrThrow() throws E0 {
            throw this.get();
        }

        @Override
        public Success<S0, E0> getAsSuccess() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Failure<S0, E0> getAsFailure() {
            return this;
        }

        @Override
        public <T> T map(BiFunction<S0, E0, T> map) {
            return map.apply(null, this.get());
        }

        @Override
        public void consume(BiConsumer<S0, E0> con) {
            con.accept(null, this.get());
        }

        @Override
        public S0 getAsLeft() {
            throw new UnsupportedOperationException();
        }

        @Override
        public E0 getAsRight() {
            return (E0)this.get();
        }
    }
}

