/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.util.reflection;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ehrbase.openehr.sdk.util.exception.SdkException;
import org.ehrbase.openehr.sdk.util.reflection.ClassDependent;

public class ReflectionHelper {
    private static final Map<Class<?>, Map> cache = new HashMap();

    private ReflectionHelper() {
    }

    public static <T, S extends ClassDependent<T>> Map<Class<? extends T>, S> buildMap(Class<S> root) {
        Map<Class<T>, S> classSMap = cache.get(root);
        if (classSMap == null) {
            classSMap = ReflectionHelper.buildInternal(root);
            cache.put(root, classSMap);
        }
        return classSMap;
    }

    public static List<Class<?>> findAll(String packageName) {
        try (ScanResult result = new ClassGraph().enableClassInfo().enableAnnotationInfo().acceptPackages(new String[]{packageName}).scan();){
            List list = result.getAllClasses().loadClasses();
            return list;
        }
    }

    public static Class<?> findRootClass(Class<?> clazz) {
        Class<?> rootC = clazz;
        while (!rootC.getSuperclass().equals(Object.class)) {
            rootC = rootC.getSuperclass();
        }
        return rootC;
    }

    private static <T, S extends ClassDependent<T>> Map<Class<? extends T>, S> buildInternal(Class<?> root) {
        Map<Class, ClassDependent> classSMap;
        try (ScanResult result = new ClassGraph().enableClassInfo().enableAnnotationInfo().acceptPackages(new String[]{root.getPackage().getName()}).scan();){
            classSMap = result.getClassesImplementing(root.getName()).stream().filter(c -> !c.isAbstract()).map(c -> {
                try {
                    return c.loadClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new SdkException(e.getMessage(), e);
                }
            }).map(o -> (ClassDependent)o).collect(Collectors.toMap(ClassDependent::getAssociatedClass, c -> c));
            cache.put(root, classSMap);
        }
        return classSMap;
    }
}

