/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.validation.terminology;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.archetyped.Pathable;
import com.nedap.archie.rm.composition.Action;
import com.nedap.archie.rm.composition.Activity;
import com.nedap.archie.rm.composition.AdminEntry;
import com.nedap.archie.rm.composition.ContentItem;
import com.nedap.archie.rm.composition.Entry;
import com.nedap.archie.rm.composition.Evaluation;
import com.nedap.archie.rm.composition.Instruction;
import com.nedap.archie.rm.composition.Observation;
import com.nedap.archie.rm.composition.Section;
import com.nedap.archie.rm.datastructures.Cluster;
import com.nedap.archie.rm.datastructures.Element;
import com.nedap.archie.rm.datastructures.Event;
import com.nedap.archie.rm.datastructures.History;
import com.nedap.archie.rm.datastructures.Item;
import com.nedap.archie.rm.datastructures.ItemList;
import com.nedap.archie.rm.datastructures.ItemSingle;
import com.nedap.archie.rm.datastructures.ItemStructure;
import com.nedap.archie.rm.datastructures.ItemTable;
import com.nedap.archie.rm.datastructures.ItemTree;
import com.nedap.archie.rm.ehr.EhrStatus;
import com.nedap.archie.rm.integration.GenericEntry;
import org.ehrbase.openehr.sdk.terminology.openehr.TerminologyService;
import org.ehrbase.openehr.sdk.terminology.openehr.implementation.AttributeCodesetMapping;
import org.ehrbase.openehr.sdk.terminology.openehr.implementation.LocalizedTerminologies;
import org.ehrbase.openehr.sdk.validation.terminology.I_ItemStructureVisitor;
import org.ehrbase.openehr.sdk.validation.terminology.ItemValidator;
import org.ehrbase.openehr.sdk.validation.terminology.Pathables;
import org.ehrbase.openehr.sdk.validation.terminology.validator.Composition;
import org.ehrbase.openehr.sdk.validation.terminology.validator.DvCodedText;
import org.ehrbase.openehr.sdk.validation.terminology.validator.DvMultimedia;
import org.ehrbase.openehr.sdk.validation.terminology.validator.DvOrdered;
import org.ehrbase.openehr.sdk.validation.terminology.validator.DvOrdinal;
import org.ehrbase.openehr.sdk.validation.terminology.validator.DvText;
import org.ehrbase.openehr.sdk.validation.terminology.validator.EventContext;
import org.ehrbase.openehr.sdk.validation.terminology.validator.IntervalEvent;
import org.ehrbase.openehr.sdk.validation.terminology.validator.IsmTransition;
import org.ehrbase.openehr.sdk.validation.terminology.validator.OriginalVersion;
import org.ehrbase.openehr.sdk.validation.terminology.validator.Participation;
import org.ehrbase.openehr.sdk.validation.terminology.validator.PartyRelationship;
import org.ehrbase.openehr.sdk.validation.terminology.validator.TermMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemStructureVisitor
implements I_ItemStructureVisitor {
    protected static Logger log = LoggerFactory.getLogger(ItemStructureVisitor.class);
    private int elementOccurrences = 0;
    private ItemValidator itemValidator = new ItemValidator();
    private LocalizedTerminologies localizedTerminologies;
    private AttributeCodesetMapping codesetMapping;
    private String itemStructureLanguage = "en";

    public ItemStructureVisitor(LocalizedTerminologies localizedTerminologies) throws NoSuchMethodException, IllegalAccessException {
        this.localizedTerminologies = localizedTerminologies;
        this.codesetMapping = localizedTerminologies.codesetMapping();
        this.itemValidator.add(new Composition()).add(new DvCodedText()).add(new DvText()).add(new IsmTransition()).add(new DvOrdered()).add(new EventContext()).add(new IntervalEvent()).add(new IsmTransition()).add(new OriginalVersion()).add(new Participation()).add(new PartyRelationship()).add(new TermMapping()).add(new DvMultimedia()).add(new DvOrdinal());
    }

    public ItemStructureVisitor(TerminologyService terminologyService) throws NoSuchMethodException, IllegalAccessException {
        this(terminologyService.localizedTerminologies());
    }

    @Override
    public void validate(com.nedap.archie.rm.composition.Composition composition) throws IllegalArgumentException, InternalError {
        if (composition == null || composition.getContent() == null || composition.getContent().isEmpty()) {
            return;
        }
        this.itemStructureLanguage = composition.getLanguage().getCodeString();
        this.itemValidator.validate(this.localizedTerminologies.locale(this.itemStructureLanguage), this.codesetMapping, "composition", (RMObject)composition, this.itemStructureLanguage);
        new Pathables(this.localizedTerminologies.locale(this.itemStructureLanguage), this.codesetMapping, this.itemValidator, this.itemStructureLanguage).traverse((Pathable)composition, "content");
        for (ContentItem item : composition.getContent()) {
            this.traverse(item);
        }
        if (composition.getContext() != null && composition.getContext().getOtherContext() != null) {
            this.validate(composition.getContext().getOtherContext());
        }
    }

    @Override
    public void validate(ItemStructure itemStructure) throws IllegalArgumentException, InternalError {
        this.traverse(itemStructure);
    }

    @Override
    public void validate(Locatable locatable) throws IllegalArgumentException, InternalError {
        if (locatable instanceof Item) {
            this.traverse((Item)locatable);
        } else if (locatable instanceof ItemStructure) {
            this.traverse((ItemStructure)locatable);
        } else if (locatable instanceof EhrStatus && ((EhrStatus)locatable).getOtherDetails() != null) {
            this.traverse(((EhrStatus)locatable).getOtherDetails());
        } else {
            throw new IllegalStateException("pathable is not an Item or ItemStructure instance...");
        }
    }

    private void validate(Entry entry) throws IllegalArgumentException, InternalError {
        this.traverse((ContentItem)entry);
    }

    private void validate(Evaluation entry) throws IllegalArgumentException, InternalError {
        if (entry == null || entry.getData() == null) {
            return;
        }
        this.traverse((ContentItem)entry);
    }

    private void validate(Observation entry) throws IllegalArgumentException, InternalError {
        if (entry == null || entry.getData() == null) {
            return;
        }
        this.traverse((ContentItem)entry);
    }

    private void validate(Instruction entry) throws IllegalArgumentException, InternalError {
        if (entry == null || entry.getActivities() == null) {
            return;
        }
        this.traverse((ContentItem)entry);
    }

    private void validate(Action entry) throws IllegalArgumentException, InternalError {
        if (entry == null || entry.getDescription() == null) {
            return;
        }
        this.traverse((ContentItem)entry);
    }

    private void validate(Activity entry) throws IllegalArgumentException, InternalError {
        if (entry == null || entry.getDescription() == null) {
            return;
        }
        this.traverse(entry);
    }

    private void traverse(ContentItem item) throws IllegalArgumentException, InternalError {
        Object retmap = null;
        if (item == null) {
            return;
        }
        log.debug("traverse element of class:" + item.getClass() + ", nodeid:" + item.getArchetypeNodeId());
        if (item instanceof Observation) {
            Observation observation = (Observation)item;
            new Pathables(this.localizedTerminologies.locale(this.itemStructureLanguage), this.codesetMapping, this.itemValidator, this.itemStructureLanguage).traverse((Pathable)observation, "protocol", "data", "state");
            if (observation.getProtocol() != null) {
                this.traverse(observation.getProtocol());
            }
            if (observation.getData() != null) {
                this.traverse(observation.getData());
            }
            if (observation.getState() != null) {
                this.traverse(observation.getState());
            }
        } else if (item instanceof Evaluation) {
            Evaluation evaluation = (Evaluation)item;
            new Pathables(this.localizedTerminologies.locale(this.itemStructureLanguage), this.codesetMapping, this.itemValidator, this.itemStructureLanguage).traverse((Pathable)evaluation, "protocol", "data");
            if (evaluation.getProtocol() != null) {
                this.traverse(evaluation.getProtocol());
            }
            if (evaluation.getData() != null) {
                this.traverse(evaluation.getData());
            }
        } else if (item instanceof Instruction) {
            Instruction instruction = (Instruction)item;
            new Pathables(this.localizedTerminologies.locale(this.itemStructureLanguage), this.codesetMapping, this.itemValidator, this.itemStructureLanguage).traverse((Pathable)instruction, "protocol", "activities");
            if (instruction.getProtocol() != null) {
                this.traverse(instruction.getProtocol());
            }
            if (instruction.getActivities() != null) {
                for (Activity activity : instruction.getActivities()) {
                    this.traverse(activity);
                }
            }
        } else if (item instanceof Action) {
            Action action = (Action)item;
            new Pathables(this.localizedTerminologies.locale(this.itemStructureLanguage), this.codesetMapping, this.itemValidator, this.itemStructureLanguage).traverse((Pathable)action, "protocol", "description");
            if (action.getProtocol() != null) {
                this.traverse(action.getProtocol());
            }
            if (action.getDescription() != null) {
                this.traverse(action.getDescription());
            }
        } else if (item instanceof Section) {
            for (ContentItem contentItem : ((Section)item).getItems()) {
                this.traverse(contentItem);
            }
        } else if (item instanceof AdminEntry) {
            AdminEntry adminEntry = (AdminEntry)item;
            new Pathables(this.localizedTerminologies.locale(this.itemStructureLanguage), this.codesetMapping, this.itemValidator, this.itemStructureLanguage).traverse((Pathable)adminEntry, "data");
            if (adminEntry.getData() != null) {
                this.traverse(adminEntry.getData());
            }
        } else if (item instanceof GenericEntry) {
            GenericEntry genericEntry = (GenericEntry)item;
            new Pathables(this.localizedTerminologies.locale(this.itemStructureLanguage), this.codesetMapping, this.itemValidator, this.itemStructureLanguage).traverse((Pathable)genericEntry, "data");
            this.traverse((ItemStructure)genericEntry.getData());
        } else {
            log.warn("This item is not handled!" + item.getName());
        }
    }

    private void traverse(Activity activity) throws IllegalArgumentException, InternalError {
        if (activity == null) {
            return;
        }
        log.debug("traverse activity:" + activity);
        this.traverse(activity.getDescription());
    }

    private void traverse(History<?> item) throws IllegalArgumentException, InternalError {
        if (item == null) {
            return;
        }
        log.debug("traverse history:" + item);
        if (item.getSummary() != null) {
            this.traverse(item.getSummary());
        }
        if (item.getEvents() != null) {
            for (Event event : item.getEvents()) {
                this.itemValidator.validate(this.localizedTerminologies.locale(this.itemStructureLanguage), this.codesetMapping, "event", (RMObject)event, this.itemStructureLanguage);
                if (event.getData() != null) {
                    this.traverse(event.getData());
                }
                if (event.getState() == null) continue;
                this.traverse(event.getState());
            }
        }
    }

    private void traverse(ItemStructure item) throws IllegalArgumentException, InternalError {
        block6: {
            ItemTable table;
            block8: {
                block7: {
                    block5: {
                        log.debug("traverse itemstructure:" + item);
                        if (item == null) {
                            return;
                        }
                        if (!(item instanceof ItemSingle)) break block5;
                        ItemSingle itemSingle = (ItemSingle)item;
                        if (itemSingle.getItem() == null) break block6;
                        this.traverse((Item)itemSingle.getItem());
                        break block6;
                    }
                    if (!(item instanceof ItemList)) break block7;
                    ItemList list = (ItemList)item;
                    if (list.getItems() == null) break block6;
                    for (Element element : list.getItems()) {
                        this.traverse((Item)element);
                    }
                    break block6;
                }
                if (!(item instanceof ItemTree)) break block8;
                ItemTree tree = (ItemTree)item;
                if (tree.getItems() == null) break block6;
                for (Item subItem : tree.getItems()) {
                    this.traverse(subItem);
                }
                break block6;
            }
            if (item instanceof ItemTable && (table = (ItemTable)item).getRows() != null) {
                for (Item subItem : table.getRows()) {
                    this.traverse(subItem);
                }
            }
        }
    }

    private void validateElement(Element element) throws IllegalArgumentException, InternalError {
        log.debug("should validate this element:" + element);
        ++this.elementOccurrences;
        if (element.getNullFlavour() != null && this.itemValidator.isValidatedRmObjectType((RMObject)element.getNullFlavour())) {
            this.itemValidator.validate(this.localizedTerminologies.locale(this.itemStructureLanguage), this.codesetMapping, "null_flavour", (RMObject)element.getNullFlavour(), this.itemStructureLanguage);
        }
        if (element.getValue() != null && this.itemValidator.isValidatedRmObjectType((RMObject)element.getValue())) {
            this.itemValidator.validate(this.localizedTerminologies.locale(this.itemStructureLanguage), this.codesetMapping, null, (RMObject)element.getValue(), this.itemStructureLanguage);
        }
        if (element.getName() != null && element.getName() instanceof com.nedap.archie.rm.datavalues.DvCodedText) {
            this.itemValidator.validate(this.localizedTerminologies.locale(this.itemStructureLanguage), this.codesetMapping, null, (RMObject)element.getName(), this.itemStructureLanguage);
        }
    }

    private void traverse(Item item) throws IllegalArgumentException, InternalError {
        Cluster c;
        log.debug("traverse item:" + item);
        if (item == null) {
            return;
        }
        if (item instanceof Element) {
            this.validateElement((Element)item);
        } else if (item instanceof Cluster && (c = (Cluster)item).getItems() != null) {
            for (Object clusterItem : c.getItems()) {
                if (clusterItem instanceof Item) {
                    this.traverse((Item)clusterItem);
                    continue;
                }
                throw new IllegalStateException("Cannot handle cluster item:" + clusterItem);
            }
        }
    }

    public int getElementOccurrences() {
        return this.elementOccurrences;
    }
}

