/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.validation.terminology.validator;

import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import org.ehrbase.openehr.sdk.terminology.openehr.TerminologyInterface;
import org.ehrbase.openehr.sdk.terminology.openehr.implementation.AttributeCodesetMapping;
import org.ehrbase.openehr.sdk.terminology.openehr.implementation.ContainerType;
import org.ehrbase.openehr.sdk.validation.terminology.validator.I_TerminologyCheck;

public class TerminologyCheck
implements I_TerminologyCheck {
    protected Class RM_CLASS;

    public static void validate(TerminologyInterface terminologyInterface, AttributeCodesetMapping codesetMapping, String context, CodePhrase codePhrase, String language) {
        String terminologyId = codePhrase.getTerminologyId().getValue();
        if (terminologyId.equals("local") || !terminologyInterface.codeSetIdentifiers().contains(terminologyId)) {
            return;
        }
        if (!codesetMapping.isLocalizedAttribute(terminologyId, context, language)) {
            language = "en";
        }
        String attribute = codesetMapping.actualAttributeId(terminologyId, context, language);
        ContainerType containerType = codesetMapping.containerType(terminologyId, context);
        switch (containerType) {
            case GROUP: {
                boolean valid = terminologyInterface.terminology(terminologyId).hasCodeForGroupId(attribute, codePhrase);
                if (valid) break;
                throw new IllegalArgumentException("supplied code string [" + codePhrase.getCodeString() + "] is not found in group:" + attribute);
            }
            case CODESET: {
                boolean valid = terminologyInterface.codeSet(terminologyId).hasCode(codePhrase);
                if (valid) break;
                throw new IllegalArgumentException("supplied code string [" + codePhrase.getCodeString() + "] is not found in codeset:" + attribute);
            }
            case UNDEFINED: {
                break;
            }
            default: {
                throw new IllegalArgumentException("undefined container type");
            }
        }
    }

    public static void validate(TerminologyInterface terminologyInterface, AttributeCodesetMapping codesetMapping, String context, CodePhrase codePhrase) throws IllegalArgumentException {
        TerminologyCheck.validate(terminologyInterface, codesetMapping, context, codePhrase, "en");
    }

    public static void validate(TerminologyInterface terminologyInterface, AttributeCodesetMapping codesetMapping, String context, DvCodedText dvCodedText, String language) throws IllegalArgumentException {
        String rubric;
        boolean valid;
        TerminologyCheck.validate(terminologyInterface, codesetMapping, context, dvCodedText.getDefiningCode(), language);
        if (terminologyInterface.terminology(dvCodedText.getDefiningCode().getTerminologyId().getValue()) == null) {
            return;
        }
        if (!codesetMapping.isLocalizedAttribute(dvCodedText.getDefiningCode().getTerminologyId().getValue(), context, language)) {
            language = "en";
        }
        if (!(valid = (rubric = terminologyInterface.terminology(dvCodedText.getDefiningCode().getTerminologyId().getValue()).rubricForCode(dvCodedText.getDefiningCode().getCodeString(), language)).equals(dvCodedText.getValue()))) {
            throw new IllegalArgumentException("supplied value [" + dvCodedText.getValue() + "] doesn't match code string:" + dvCodedText.getDefiningCode().getCodeString() + " (language:" + language + ", terminology:" + dvCodedText.getDefiningCode().getTerminologyId().getValue() + "), expected:" + rubric);
        }
    }

    public static void validate(TerminologyInterface terminologyInterface, AttributeCodesetMapping codesetMapping, String context, DvCodedText dvCodedText) throws IllegalArgumentException {
        TerminologyCheck.validate(terminologyInterface, codesetMapping, context, dvCodedText, "en");
    }

    @Override
    public Class rmClass() {
        return this.RM_CLASS;
    }
}

