/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.validation.webtemplate;

import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.ehrbase.openehr.sdk.util.functional.Try;
import org.ehrbase.openehr.sdk.validation.ConstraintViolation;
import org.ehrbase.openehr.sdk.validation.ConstraintViolationException;
import org.ehrbase.openehr.sdk.validation.terminology.ExternalTerminologyValidation;
import org.ehrbase.openehr.sdk.validation.terminology.TerminologyParam;
import org.ehrbase.openehr.sdk.validation.webtemplate.ConstraintValidator;
import org.ehrbase.openehr.sdk.validation.webtemplate.WebTemplateValidationUtils;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateInput;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateInputValue;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateNode;

public class DvCodedTextValidator
implements ConstraintValidator<DvCodedText> {
    private ExternalTerminologyValidation externalTerminologyValidation;

    public DvCodedTextValidator() {
    }

    public DvCodedTextValidator(ExternalTerminologyValidation externalTerminologyValidation) {
        this.externalTerminologyValidation = externalTerminologyValidation;
    }

    public Class<DvCodedText> getAssociatedClass() {
        return DvCodedText.class;
    }

    @Override
    public List<ConstraintViolation> validate(DvCodedText dvCodedText, WebTemplateNode node) {
        List codedText = WebTemplateValidationUtils.findInputWithType(node, "CODED_TEXT").map(input -> this.validateInternalCode(node.getAqlPath(), dvCodedText, (WebTemplateInput)input)).orElse(List.of());
        List text = WebTemplateValidationUtils.findInputWithType(node, "TEXT").map(input1 -> this.validateExternalTerminology(node.getAqlPath(), dvCodedText, (WebTemplateInput)input1)).orElse(List.of());
        return ConstraintValidator.concat(codedText, text);
    }

    private List<ConstraintViolation> validateInternalCode(String aqlPath, DvCodedText dvCodedText, WebTemplateInput input) {
        CodePhrase definingCode = dvCodedText.getDefiningCode();
        Optional<ConstraintViolation> terminologyViolation = Optional.of(input).filter(i -> i.getTerminology() != null && !Objects.equals(i.getTerminology(), definingCode.getTerminologyId().getValue())).map(i -> new ConstraintViolation(aqlPath, MessageFormat.format("CodePhrase terminology does not match, expected: {0}, found: {1}", input.getTerminology(), definingCode.getTerminologyId().getValue())));
        Optional<ConstraintViolation> otherViolation = Optional.of(input).filter(WebTemplateValidationUtils::hasList).map(i -> {
            Optional<WebTemplateInputValue> matching = input.getList().stream().filter(inputValue -> Objects.equals(inputValue.getValue(), definingCode.getCodeString())).findFirst();
            if (matching.isEmpty()) {
                return new ConstraintViolation(aqlPath, MessageFormat.format("CodePhrase codeString does not match any option, found: {0}", definingCode.getCodeString()));
            }
            if (!matching.get().getLabel().equals(dvCodedText.getValue())) {
                return new ConstraintViolation(aqlPath, MessageFormat.format("Dv_Coded_Text value does not match. found: {0} expected: {1}", dvCodedText.getValue(), matching.get().getLabel()));
            }
            return null;
        });
        return ConstraintValidator.concat(terminologyViolation, otherViolation);
    }

    private List<ConstraintViolation> validateExternalTerminology(String aqlPath, DvCodedText dvCodedText, WebTemplateInput input) {
        Try<Boolean, ConstraintViolationException> validationResult;
        if (this.externalTerminologyValidation == null) {
            return List.of();
        }
        TerminologyParam tp = TerminologyParam.ofFhir(input.getTerminology());
        tp.setCodePhrase(dvCodedText.getDefiningCode());
        if (this.externalTerminologyValidation.supports(tp) && (validationResult = this.externalTerminologyValidation.validate(tp)).isFailure()) {
            ConstraintViolationException ex = (ConstraintViolationException)validationResult.getAsFailure().get();
            return ConstraintValidator.concat(List.of(new ConstraintViolation(aqlPath, "Failed to validate " + dvCodedText)), ex.getConstraintViolations());
        }
        return List.of();
    }
}

