/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.validation.webtemplate;

import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.quantity.DvOrdinal;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import org.ehrbase.openehr.sdk.validation.ConstraintViolation;
import org.ehrbase.openehr.sdk.validation.webtemplate.ConstraintValidator;
import org.ehrbase.openehr.sdk.validation.webtemplate.DvCodedTextValidator;
import org.ehrbase.openehr.sdk.validation.webtemplate.WebTemplateValidationUtils;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateNode;

public class DvOrdinalValidator
implements ConstraintValidator<DvOrdinal> {
    private static final DvCodedTextValidator DV_CODED_TEXT_VALIDATOR = new DvCodedTextValidator();

    public Class<DvOrdinal> getAssociatedClass() {
        return DvOrdinal.class;
    }

    @Override
    public List<ConstraintViolation> validate(DvOrdinal dvOrdinal, WebTemplateNode node) {
        if (!WebTemplateValidationUtils.hasInputs(node)) {
            return List.of();
        }
        DvCodedText symbol = dvOrdinal.getSymbol();
        List<ConstraintViolation> violations = DV_CODED_TEXT_VALIDATOR.validate(symbol, node);
        if (!violations.isEmpty()) {
            return violations;
        }
        List inputs = WebTemplateValidationUtils.getInputWithType(node, "CODED_TEXT").getList();
        if (inputs.isEmpty()) {
            return List.of();
        }
        return inputs.stream().filter(inputValue -> Objects.equals(inputValue.getValue(), symbol.getDefiningCode().getCodeString())).findFirst().filter(inputValue -> dvOrdinal.getValue().longValue() != inputValue.getOrdinal().longValue()).map(inputValue -> new ConstraintViolation(node.getAqlPath(), MessageFormat.format("The value {0} must be {1}", dvOrdinal.getValue(), inputValue.getOrdinal().longValue()))).map(List::of).orElse(List.of());
    }
}

