/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.validation.webtemplate;

import com.nedap.archie.rm.datavalues.DvText;
import java.util.List;
import org.ehrbase.openehr.sdk.validation.ConstraintViolation;
import org.ehrbase.openehr.sdk.validation.webtemplate.ConstraintValidator;
import org.ehrbase.openehr.sdk.validation.webtemplate.PrimitiveConstraintValidator;
import org.ehrbase.openehr.sdk.validation.webtemplate.WebTemplateValidationUtils;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateInput;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateNode;

public class DvTextValidator
implements ConstraintValidator<DvText> {
    public Class<DvText> getAssociatedClass() {
        return DvText.class;
    }

    @Override
    public List<ConstraintViolation> validate(DvText dvText, WebTemplateNode node) {
        if (!WebTemplateValidationUtils.hasInputs(node)) {
            return List.of();
        }
        if ("DV_CODED_TEXT".equals(node.getRmType())) {
            return List.of(new ConstraintViolation(node.getAqlPath(), "Expected a DV_CODED_TEXT but got DV_TEXT"));
        }
        WebTemplateInput input = WebTemplateValidationUtils.getInputWithType(node, "TEXT");
        return PrimitiveConstraintValidator.validate(node.getAqlPath(), (Object)dvText.getValue(), input);
    }
}

