/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.validation.webtemplate;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.nedap.archie.ValidationConfiguration;
import com.nedap.archie.adlparser.modelconstraints.ModelConstraintImposer;
import com.nedap.archie.adlparser.modelconstraints.ReflectionConstraintImposer;
import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.ArchetypeConstraint;
import com.nedap.archie.aom.ArchetypeSlot;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CAttributeTuple;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.aom.CPrimitiveTuple;
import com.nedap.archie.aom.OperationalTemplate;
import com.nedap.archie.aom.primitives.COrdered;
import com.nedap.archie.aom.primitives.CString;
import com.nedap.archie.aom.primitives.CTemporal;
import com.nedap.archie.aom.primitives.CTerminologyCode;
import com.nedap.archie.aom.terminology.ArchetypeTerm;
import com.nedap.archie.aom.terminology.ArchetypeTerminology;
import com.nedap.archie.aom.utils.AOMUtils;
import com.nedap.archie.base.Cardinality;
import com.nedap.archie.base.Interval;
import com.nedap.archie.base.MultiplicityInterval;
import com.nedap.archie.base.terminology.TerminologyCode;
import com.nedap.archie.flattener.OperationalTemplateProvider;
import com.nedap.archie.query.RMObjectAttributes;
import com.nedap.archie.query.RMObjectWithPath;
import com.nedap.archie.query.RMPathQuery;
import com.nedap.archie.rminfo.InvariantMethod;
import com.nedap.archie.rminfo.MetaModel;
import com.nedap.archie.rminfo.ModelInfoLookup;
import com.nedap.archie.rminfo.RMAttributeInfo;
import com.nedap.archie.rminfo.RMTypeInfo;
import com.nedap.archie.rmobjectvalidator.APathQueryCache;
import com.nedap.archie.rmobjectvalidator.ConstraintToStringUtil;
import com.nedap.archie.rmobjectvalidator.RMObjectValidationMessage;
import com.nedap.archie.rmobjectvalidator.RMObjectValidationMessageIds;
import com.nedap.archie.rmobjectvalidator.RMObjectValidationMessageType;
import com.nedap.archie.rmobjectvalidator.RMObjectValidator;
import com.nedap.archie.rmobjectvalidator.ValidationConfiguration;
import com.nedap.archie.terminology.OpenEHRTerminologyAccess;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.openehr.utils.message.I18n;

public class FastRMObjectValidator
extends RMObjectValidator {
    private final MetaModel metaModel;
    private final OperationalTemplateProvider operationalTemplateProvider;
    private APathQueryCache queryCache = new APathQueryCache();
    private ModelInfoLookup lookup;
    private ReflectionConstraintImposer constraintImposer;
    private final com.nedap.archie.rmobjectvalidator.ValidationConfiguration validationConfiguration;
    private boolean validateInvariants = true;
    private final RmOccurrenceValidator rmOccurrenceValidator;
    private final RmPrimitiveObjectValidator rmPrimitiveObjectValidator;
    private final RmTupleValidator rmTupleValidator;
    private final RmMultiplicityValidator rmMultiplicityValidator;

    @Deprecated
    public FastRMObjectValidator(ModelInfoLookup lookup, OperationalTemplateProvider provider) {
        super(null, null, new ValidationConfiguration.Builder().build());
        this.lookup = lookup;
        this.metaModel = new MetaModel(lookup, null);
        this.constraintImposer = new ReflectionConstraintImposer(lookup);
        this.operationalTemplateProvider = provider;
        this.validationConfiguration = null;
        com.nedap.archie.rmobjectvalidator.ValidationConfiguration dummyValidationConfiguration = new ValidationConfiguration.Builder().failOnUnknownTerminologyId(ValidationConfiguration.isFailOnUnknownTerminologyId()).build();
        ValidationHelper validationHelper = new ValidationHelper(this.lookup, dummyValidationConfiguration);
        this.rmOccurrenceValidator = new RmOccurrenceValidator();
        this.rmPrimitiveObjectValidator = new RmPrimitiveObjectValidator(validationHelper);
        this.rmTupleValidator = new RmTupleValidator(this.lookup, validationHelper, this.rmPrimitiveObjectValidator);
        this.rmMultiplicityValidator = new RmMultiplicityValidator();
    }

    public FastRMObjectValidator(ModelInfoLookup lookup, OperationalTemplateProvider provider, com.nedap.archie.rmobjectvalidator.ValidationConfiguration validationConfiguration) {
        super(null, null, new ValidationConfiguration.Builder().build());
        this.lookup = lookup;
        this.metaModel = new MetaModel(lookup, null);
        this.constraintImposer = new ReflectionConstraintImposer(lookup);
        this.operationalTemplateProvider = provider;
        this.validationConfiguration = validationConfiguration;
        ValidationHelper validationHelper = new ValidationHelper(this.lookup, validationConfiguration);
        this.validateInvariants = validationConfiguration.isValidateInvariants();
        this.rmOccurrenceValidator = new RmOccurrenceValidator();
        this.rmPrimitiveObjectValidator = new RmPrimitiveObjectValidator(validationHelper);
        this.rmTupleValidator = new RmTupleValidator(this.lookup, validationHelper, this.rmPrimitiveObjectValidator);
        this.rmMultiplicityValidator = new RmMultiplicityValidator();
    }

    public APathQueryCache getQueryCache() {
        return this.queryCache;
    }

    public void setQueryCache(APathQueryCache queryCache) {
        this.queryCache = queryCache;
    }

    @Deprecated
    public void setRunInvariantChecks(boolean validateInvariants) {
        if (this.validationConfiguration != null) {
            throw new IllegalStateException("validateInvariants is already set via validationConfiguration, cannot set it again via setRunInvariantChecks");
        }
        this.validateInvariants = validateInvariants;
    }

    public List<RMObjectValidationMessage> validate(OperationalTemplate template, Object rmObject) {
        this.clearMessages();
        List<RMObjectWithPath> objects = List.of(new RMObjectWithPath(rmObject, ""));
        this.addAllMessages(this.runArchetypeValidations(objects, LazyPath.of(""), (CObject)template.getDefinition()));
        return this.getMessages();
    }

    public List<RMObjectValidationMessage> validate(Object rmObject) {
        this.clearMessages();
        List<RMObjectWithPath> objects = List.of(new RMObjectWithPath(rmObject, "/"));
        this.addAllMessages(this.runArchetypeValidations(objects, LazyPath.of(""), null));
        return this.getMessages();
    }

    public static <T> void addAll(List<T> target, Collection<T> source) {
        if (!source.isEmpty()) {
            target.addAll(source);
        }
    }

    protected void addAllMessages(Collection<RMObjectValidationMessage> messages) {
        if (!messages.isEmpty()) {
            super.addAllMessages(messages);
        }
    }

    private List<RMObjectValidationMessage> runArchetypeValidations(List<RMObjectWithPath> rmObjects, LazyPath path, CObject cobject) {
        List<RMObjectValidationMessage> result = this.rmOccurrenceValidator.validate(this.metaModel, rmObjects, path, cobject);
        if (rmObjects.isEmpty()) {
            return result;
        }
        for (RMObjectWithPath rMObjectWithPath : rmObjects) {
            List<RMObjectValidationMessage> messages = this.validateInvariants(rMObjectWithPath, path);
            FastRMObjectValidator.addAll(result, messages);
        }
        if (cobject == null) {
            for (RMObjectWithPath rMObjectWithPath : rmObjects) {
                this.validateUnconstrainedObjectWithPath(result, path, rMObjectWithPath);
            }
        } else if (cobject instanceof CPrimitiveObject) {
            FastRMObjectValidator.addAll(result, this.rmPrimitiveObjectValidator.validate(rmObjects, path, (CPrimitiveObject)cobject));
        } else if (cobject instanceof ArchetypeSlot) {
            this.validateArchetypeSlot(rmObjects, path, cobject, result);
        } else {
            if (cobject instanceof CComplexObject) {
                CComplexObject cComplexObject = (CComplexObject)cobject;
                for (CAttributeTuple tuple : cComplexObject.getAttributeTuples()) {
                    FastRMObjectValidator.addAll(result, this.rmTupleValidator.validate(cobject, path, rmObjects, tuple));
                }
            }
            for (RMObjectWithPath rMObjectWithPath : rmObjects) {
                this.validateConstrainedObjectWithPath(result, cobject, path, rMObjectWithPath);
            }
        }
        return result;
    }

    private List<RMObjectValidationMessage> validateInvariants(RMObjectWithPath objectWithPath, LazyPath pathSoFar) {
        if (!this.validateInvariants) {
            return Collections.emptyList();
        }
        pathSoFar = pathSoFar.stripLastPathSegment();
        Object rmObject = objectWithPath.getObject();
        if (rmObject != null) {
            ArrayList<RMObjectValidationMessage> result = new ArrayList<RMObjectValidationMessage>();
            RMTypeInfo typeInfo = this.lookup.getTypeInfo(rmObject.getClass());
            if (typeInfo != null) {
                for (InvariantMethod invariantMethod : typeInfo.getInvariants()) {
                    if (invariantMethod.getAnnotation().ignored()) continue;
                    try {
                        boolean passed = (Boolean)invariantMethod.getMethod().invoke(rmObject, new Object[0]);
                        if (passed) continue;
                        result.add(new RMObjectValidationMessage(null, pathSoFar.joinPaths(objectWithPath.getPath(), false).toString(), I18n.t((String)("Invariant {0} failed on type " + typeInfo.getRmName()), (Object[])new Object[]{invariantMethod.getAnnotation().value()}), RMObjectValidationMessageType.INVARIANT_ERROR));
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        result.add(new RMObjectValidationMessage(null, pathSoFar.joinPaths(objectWithPath.getPath(), false).toString(), I18n.t((String)"Exception {0} invoking invariant {1} on {2}: {3}\n{4}", (Object[])new Object[]{e.getCause() == null ? e.getClass().getSimpleName() : e.getCause().getClass().getSimpleName(), invariantMethod.getAnnotation().value(), typeInfo.getRmName(), e.getCause() == null ? e.getMessage() : e.getCause().getMessage(), Joiner.on((String)"\n\t").join((Object[])e.getStackTrace())}), RMObjectValidationMessageType.EXCEPTION));
                    }
                }
            }
            return result;
        }
        return Collections.emptyList();
    }

    private void validateUnconstrainedObjectWithPath(List<RMObjectValidationMessage> result, LazyPath path, RMObjectWithPath objectWithPath) {
        Object rmObject = objectWithPath.getObject();
        String archetypeId = this.lookup.getArchetypeIdFromArchetypedRmObject(rmObject);
        if (archetypeId != null) {
            this.validateArchetypedObject(result, null, path, objectWithPath, archetypeId);
        } else {
            this.validateObjectAttributes(result, null, path, objectWithPath);
        }
    }

    private void validateArchetypeSlot(List<RMObjectWithPath> rmObjects, LazyPath path, CObject cobject, List<RMObjectValidationMessage> result) {
        ArchetypeSlot slot = (ArchetypeSlot)cobject;
        for (RMObjectWithPath objectWithPath : rmObjects) {
            Object object = objectWithPath.getObject();
            String archetypeId = this.metaModel.getSelectedModel().getArchetypeIdFromArchetypedRmObject(object);
            if (archetypeId != null) {
                if (!AOMUtils.archetypeRefMatchesSlotExpression((String)archetypeId, (ArchetypeSlot)slot)) {
                    this.addMessage((CObject)slot, objectWithPath.getPath(), RMObjectValidationMessageIds.rm_ARCHETYPE_ID_SLOT_MISMATCH.getMessage(new Object[]{archetypeId}), RMObjectValidationMessageType.ARCHETYPE_SLOT_ID_MISMATCH);
                }
                this.validateArchetypedObject(result, cobject, path, objectWithPath, archetypeId);
                continue;
            }
            this.addMessage((CObject)slot, objectWithPath.getPath(), RMObjectValidationMessageIds.rm_SLOT_WITHOUT_ARCHETYPE_ID.getMessage(new Object[0]), RMObjectValidationMessageType.ARCHETYPE_SLOT_ID_MISMATCH);
            this.validateConstrainedObjectWithPath(result, cobject, path, objectWithPath);
        }
    }

    private void validateArchetypedObject(List<RMObjectValidationMessage> result, CObject cobject, LazyPath path, RMObjectWithPath objectWithPath, String archetypeId) {
        OperationalTemplate operationalTemplate = this.operationalTemplateProvider.getOperationalTemplate(archetypeId);
        if (operationalTemplate != null) {
            CComplexObject newRoot = operationalTemplate.getDefinition();
            this.validateConstrainedObjectWithPath(result, (CObject)newRoot, path, objectWithPath);
        } else {
            this.addMessage(cobject, objectWithPath.getPath(), RMObjectValidationMessageIds.rm_ARCHETYPE_NOT_FOUND.getMessage(new Object[]{archetypeId}), RMObjectValidationMessageType.ARCHETYPE_NOT_FOUND);
            if (cobject != null) {
                this.validateConstrainedObjectWithPath(result, cobject, path, objectWithPath);
            } else {
                this.validateObjectAttributes(result, null, path, objectWithPath);
            }
        }
    }

    private void validateConstrainedObjectWithPath(List<RMObjectValidationMessage> result, CObject cobject, LazyPath path, RMObjectWithPath objectWithPath) {
        Class classInConstraint = this.lookup.getClass(cobject.getRmTypeName());
        if (!classInConstraint.isAssignableFrom(objectWithPath.getObject().getClass())) {
            result.add(new RMObjectValidationMessage((ArchetypeConstraint)cobject, objectWithPath.getPath(), RMObjectValidationMessageIds.rm_INCORRECT_TYPE.getMessage(new Object[]{cobject.getRmTypeName(), objectWithPath.getObject().getClass().getSimpleName()}), RMObjectValidationMessageType.WRONG_TYPE));
        } else {
            this.validateObjectAttributes(result, cobject, path, objectWithPath);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateObjectAttributes(List<RMObjectValidationMessage> result, CObject cobject, LazyPath path, RMObjectWithPath objectWithPath) {
        List<CAttribute> attributes;
        Object rmObject = objectWithPath.getObject();
        if (cobject == null) {
            RMTypeInfo typeInfo = this.lookup.getTypeInfo(rmObject.getClass());
            if (typeInfo == null) return;
            attributes = RMObjectValidationUtil.getDefaultAttributeConstraints(typeInfo.getRmName(), List.of(), this.lookup, (ModelConstraintImposer)this.constraintImposer);
        } else {
            List<CAttribute> cobjectAttributes = cobject.getAttributes();
            List<CAttribute> defaultAttributeConstraints = RMObjectValidationUtil.getDefaultAttributeConstraints(cobject, cobjectAttributes, this.lookup, (ModelConstraintImposer)this.constraintImposer);
            if (defaultAttributeConstraints.isEmpty()) {
                attributes = cobjectAttributes;
            } else if (cobjectAttributes.isEmpty()) {
                attributes = defaultAttributeConstraints;
            } else {
                attributes = new ArrayList<CAttribute>();
                attributes.addAll(cobjectAttributes);
                attributes.addAll(defaultAttributeConstraints);
            }
        }
        this.validateCAttributes(result, path, objectWithPath, rmObject, cobject, attributes);
    }

    private void validateCAttributes(List<RMObjectValidationMessage> result, LazyPath path, RMObjectWithPath objectWithPath, Object rmObject, CObject cObject, List<CAttribute> attributes) {
        LazyPath pathSoFar = path.stripLastPathSegment().joinPaths(objectWithPath.getPath(), false);
        for (CAttribute attribute : attributes) {
            this.validateAttributes(result, attribute, cObject, rmObject, pathSoFar);
        }
    }

    private void validateAttributes(List<RMObjectValidationMessage> result, CAttribute attribute, CObject cobject, Object rmObject, LazyPath pathSoFar) {
        String rmAttributeName = attribute.getRmAttributeName();
        RMPathQuery aPathQuery = this.queryCache.getApathQuery("/" + attribute.getRmAttributeName());
        Object attributeValue = aPathQuery.find(this.lookup, rmObject);
        List<RMObjectValidationMessage> emptyObservationErrors = this.isObservationEmpty(attribute, rmAttributeName, attributeValue, pathSoFar, cobject);
        FastRMObjectValidator.addAll(result, emptyObservationErrors);
        if (emptyObservationErrors.isEmpty()) {
            FastRMObjectValidator.addAll(result, this.rmMultiplicityValidator.validate(attribute, pathSoFar.joinPaths(rmAttributeName, true), attributeValue));
            if (attribute.getChildren() == null || attribute.getChildren().isEmpty()) {
                String query = "/" + rmAttributeName;
                aPathQuery = this.queryCache.getApathQuery(query);
                List childRmObjects = aPathQuery.findList(this.lookup, rmObject);
                FastRMObjectValidator.addAll(result, this.runArchetypeValidations(childRmObjects, pathSoFar.joinPaths(query, false), null));
            } else if (attribute.isSingle()) {
                this.validateSingleAttribute(result, attribute, rmObject, pathSoFar);
            } else {
                for (CObject childCObject : attribute.getChildren()) {
                    String query = "/" + rmAttributeName + "[" + childCObject.getNodeId() + "]";
                    aPathQuery = this.queryCache.getApathQuery(query);
                    List childRmObjects = aPathQuery.findList(this.lookup, rmObject);
                    FastRMObjectValidator.addAll(result, this.runArchetypeValidations(childRmObjects, pathSoFar.joinPaths(query, false), childCObject));
                }
            }
        }
    }

    private void validateSingleAttribute(List<RMObjectValidationMessage> result, CAttribute attribute, Object rmObject, LazyPath pathSoFar) {
        ArrayList<List<RMObjectValidationMessage>> subResults = new ArrayList<List<RMObjectValidationMessage>>();
        for (CObject childCObject : attribute.getChildren()) {
            String string = "/" + attribute.getRmAttributeName() + "[" + childCObject.getNodeId() + "]";
            RMPathQuery aPathQuery = this.queryCache.getApathQuery(string);
            List childNodes = aPathQuery.findList(this.lookup, rmObject);
            List<RMObjectValidationMessage> subResult = this.runArchetypeValidations(childNodes, pathSoFar.joinPaths(string, false), childCObject);
            if (subResult.isEmpty()) {
                return;
            }
            subResults.add(subResult);
        }
        boolean atLeastOneWithoutWrongTypeFound = subResults.stream().anyMatch(RMObjectValidationUtil::hasNoneWithWrongType);
        if (atLeastOneWithoutWrongTypeFound) {
            for (List list : subResults) {
                list.stream().filter(message -> message.getType() != RMObjectValidationMessageType.WRONG_TYPE).forEach(result::add);
            }
        } else {
            subResults.forEach(result::addAll);
        }
    }

    private List<RMObjectValidationMessage> isObservationEmpty(CAttribute attribute, String rmAttributeName, Object attributeValue, LazyPath pathSoFar, CObject cobject) {
        boolean attributeShouldNotBeEmpty;
        ArrayList<RMObjectValidationMessage> result = new ArrayList<RMObjectValidationMessage>();
        CObject parent = attribute.getParent();
        boolean parentIsEvent = parent != null && parent.getRmTypeName().contains("EVENT");
        boolean attributeIsData = rmAttributeName.equals("data");
        boolean attributeIsEmpty = attributeValue == null;
        boolean bl = attributeShouldNotBeEmpty = attribute.getExistence() != null && !attribute.getExistence().has((Object)0);
        if (parentIsEvent && attributeIsData && attributeIsEmpty && attributeShouldNotBeEmpty) {
            String message = "Observation " + RMObjectValidationUtil.getParentObservationTerm(attribute) + " contains no results";
            result.add(new RMObjectValidationMessage((ArchetypeConstraint)(cobject == null ? null : cobject.getParent().getParent()), pathSoFar.toString(), message, RMObjectValidationMessageType.EMPTY_OBSERVATION));
        }
        return result;
    }

    private static String joinPaths(String ... pathElements) {
        StringBuilder result = new StringBuilder();
        boolean lastCharacterWasSlash = false;
        for (String pathElement : pathElements) {
            if (lastCharacterWasSlash && pathElement.startsWith("/")) {
                result.append(pathElement.substring(1));
            } else {
                result.append(pathElement);
            }
            if (pathElement.isEmpty()) continue;
            lastCharacterWasSlash = pathElement.charAt(pathElement.length() - 1) == '/';
        }
        return result.toString();
    }

    static class ValidationHelper {
        private final ModelInfoLookup lookup;
        private final PrimitiveObjectConstraintHelper primitiveObjectConstraintHelper;

        public ValidationHelper(ModelInfoLookup lookup, com.nedap.archie.rmobjectvalidator.ValidationConfiguration validationConfiguration) {
            this.lookup = lookup;
            this.primitiveObjectConstraintHelper = new PrimitiveObjectConstraintHelper(validationConfiguration);
        }

        public <ValueType> boolean isValidValue(CPrimitiveObject<?, ValueType> cPrimitiveObject, Object value) {
            Object convertedValue = this.lookup.convertToConstraintObject(value, cPrimitiveObject);
            return this.primitiveObjectConstraintHelper.isValidValue(cPrimitiveObject, convertedValue);
        }

        boolean isValid(CAttributeTuple cAttributeTuple, HashMap<String, Object> values) {
            for (CAttribute attribute : cAttributeTuple.getMembers()) {
                if (values.containsKey(attribute.getRmAttributeName())) continue;
                return false;
            }
            for (CPrimitiveTuple tuple : cAttributeTuple.getTuples()) {
                if (!this.isValid(cAttributeTuple, tuple, values)) continue;
                return true;
            }
            return false;
        }

        private boolean isValid(CAttributeTuple cAttributeTuple, CPrimitiveTuple tuple, HashMap<String, Object> values) {
            int index = 0;
            for (CAttribute attribute : cAttributeTuple.getMembers()) {
                String attributeName = attribute.getRmAttributeName();
                CPrimitiveObject cPrimitiveObject = (CPrimitiveObject)tuple.getMembers().get(index);
                Object value = values.get(attributeName);
                if (value == null) {
                    return false;
                }
                if (!this.isValidValue(cPrimitiveObject, value)) {
                    return false;
                }
                ++index;
            }
            return true;
        }

        boolean isValid(CAttributeTuple cAttributeTuple, Object value) {
            HashMap<String, Object> members = new HashMap<String, Object>();
            for (CAttribute attribute : cAttributeTuple.getMembers()) {
                RMAttributeInfo attributeInfo = this.lookup.getAttributeInfo(value.getClass(), attribute.getRmAttributeName());
                try {
                    if (attributeInfo == null || attributeInfo.getGetMethod() == null) continue;
                    members.put(attribute.getRmAttributeName(), attributeInfo.getGetMethod().invoke(value, new Object[0]));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.isValid(cAttributeTuple, members);
        }
    }

    static class RmOccurrenceValidator {
        RmOccurrenceValidator() {
        }

        List<RMObjectValidationMessage> validate(MetaModel metaModel, List<RMObjectWithPath> rmObjects, LazyPath pathSoFar, CObject cobject) {
            if (cobject != null) {
                MultiplicityInterval occurrences = cobject.effectiveOccurrences((arg_0, arg_1) -> ((MetaModel)metaModel).referenceModelPropMultiplicity(arg_0, arg_1));
                if (occurrences != null && !occurrences.has((Object)rmObjects.size())) {
                    String message = RMObjectValidationMessageIds.rm_OCCURRENCE_MISMATCH.getMessage(new Object[]{rmObjects.size(), occurrences.toString()});
                    RMObjectValidationMessageType messageType = occurrences.isMandatory() ? RMObjectValidationMessageType.REQUIRED : RMObjectValidationMessageType.DEFAULT;
                    return Lists.newArrayList((Object[])new RMObjectValidationMessage[]{new RMObjectValidationMessage((ArchetypeConstraint)cobject, pathSoFar.toString(), message, messageType)});
                }
            }
            return new ArrayList<RMObjectValidationMessage>();
        }
    }

    static class RmPrimitiveObjectValidator {
        private final ValidationHelper validationHelper;

        public RmPrimitiveObjectValidator(ValidationHelper validationHelper) {
            this.validationHelper = validationHelper;
        }

        public List<RMObjectValidationMessage> validate(List<RMObjectWithPath> rmObjects, LazyPath pathSoFar, CPrimitiveObject<?, ?> cobject) {
            if (cobject == null) {
                return new ArrayList<RMObjectValidationMessage>();
            }
            if (cobject.getSocParent() != null) {
                return Collections.emptyList();
            }
            if (rmObjects.size() != 1) {
                ArrayList<RMObjectValidationMessage> result = new ArrayList<RMObjectValidationMessage>();
                result.add(this.createValidationMessage(rmObjects, pathSoFar, cobject));
                return result;
            }
            Object rmObject = rmObjects.get(0).getObject();
            return this.validate_inner(rmObject, pathSoFar, cobject);
        }

        List<RMObjectValidationMessage> validate_inner(Object rmObject, LazyPath pathSoFar, CPrimitiveObject<?, ?> cobject) {
            ArrayList<RMObjectValidationMessage> result = new ArrayList<RMObjectValidationMessage>();
            if (!this.validationHelper.isValidValue(cobject, rmObject)) {
                result.add(this.createValidationMessage(rmObject, pathSoFar, cobject));
            }
            return result;
        }

        private RMObjectValidationMessage createValidationMessage(Object value, LazyPath pathSoFar, CPrimitiveObject<?, ?> cobject) {
            Object message;
            List constraint = cobject.getConstraint();
            if (constraint.size() == 1) {
                String constraintStr = ConstraintToStringUtil.constraintElementToString(constraint.get(0));
                message = RMObjectValidationMessageIds.rm_INVALID_FOR_CONSTRAINT.getMessage(new Object[]{this.getValueString(value), constraintStr});
            } else {
                String constraintStr = ConstraintToStringUtil.constraintListToString((List)constraint);
                message = RMObjectValidationMessageIds.rm_INVALID_FOR_CONSTRAINT_MULTIPLE.getMessage(new Object[]{this.getValueString(value)}) + "\n" + constraintStr;
            }
            return new RMObjectValidationMessage(cobject, pathSoFar.toString(), (String)message);
        }

        private String getValueString(Object value) {
            if (value == null) {
                return I18n.t((String)"empty", (Object[])new Object[0]);
            }
            return value instanceof String ? "\"" + value.toString() + "\"" : value.toString();
        }
    }

    static class RmTupleValidator {
        private final ModelInfoLookup lookup;
        private final ValidationHelper validationHelper;
        private final RmPrimitiveObjectValidator rmPrimitiveObjectValidator;

        RmTupleValidator(ModelInfoLookup lookup, ValidationHelper validationHelper, RmPrimitiveObjectValidator rmPrimitiveObjectValidator) {
            this.lookup = lookup;
            this.validationHelper = validationHelper;
            this.rmPrimitiveObjectValidator = rmPrimitiveObjectValidator;
        }

        List<RMObjectValidationMessage> validate(CObject cobject, LazyPath pathSoFar, List<RMObjectWithPath> rmObjects, CAttributeTuple tuple) {
            ArrayList<RMObjectValidationMessage> result = new ArrayList<RMObjectValidationMessage>();
            if (rmObjects.size() != 1) {
                String message = RMObjectValidationMessageIds.rm_TUPLE_CONSTRAINT.getMessage(new Object[]{cobject.toString(), rmObjects.toString()});
                result.add(new RMObjectValidationMessage((ArchetypeConstraint)cobject, pathSoFar.toString(), message));
                return result;
            }
            Object rmObject = rmObjects.get(0).getObject();
            if (!this.validationHelper.isValid(tuple, rmObject)) {
                if (tuple.getTuples().size() == 1) {
                    result.addAll(this.validateSingleTuple(pathSoFar, rmObject, tuple));
                }
                if (result.isEmpty()) {
                    String message = RMObjectValidationMessageIds.rm_TUPLE_MISMATCH.getMessage(new Object[]{tuple.toString()});
                    result.add(new RMObjectValidationMessage((ArchetypeConstraint)cobject, pathSoFar.toString(), message));
                }
            }
            return result;
        }

        private List<RMObjectValidationMessage> validateSingleTuple(LazyPath pathSoFar, Object rmObject, CAttributeTuple attributeTuple) {
            ArrayList<RMObjectValidationMessage> result = new ArrayList<RMObjectValidationMessage>();
            CPrimitiveTuple tuple = (CPrimitiveTuple)attributeTuple.getTuples().get(0);
            int index = 0;
            for (CAttribute attribute : attributeTuple.getMembers()) {
                String attributeName = attribute.getRmAttributeName();
                CPrimitiveObject cPrimitiveObject = (CPrimitiveObject)tuple.getMembers().get(index);
                Object value = RMObjectAttributes.getAttributeValueFromRMObject((Object)rmObject, (String)attributeName, (ModelInfoLookup)this.lookup);
                LazyPath path = pathSoFar.add(attributeName, cPrimitiveObject);
                result.addAll(this.rmPrimitiveObjectValidator.validate_inner(value, path, cPrimitiveObject));
                ++index;
            }
            return result;
        }
    }

    static class RmMultiplicityValidator {
        RmMultiplicityValidator() {
        }

        List<RMObjectValidationMessage> validate(CAttribute attribute, LazyPath pathSoFar, Object attributeValue) {
            if (attributeValue instanceof Collection) {
                Collection collectionValue = (Collection)attributeValue;
                Cardinality cardinality = attribute.getCardinality();
                if (cardinality != null && !cardinality.getInterval().has((Object)collectionValue.size())) {
                    String message = RMObjectValidationMessageIds.rm_CARDINALITY_MISMATCH.getMessage(new Object[]{cardinality.getInterval().toString()});
                    return Lists.newArrayList((Object[])new RMObjectValidationMessage[]{new RMObjectValidationMessage((ArchetypeConstraint)attribute, pathSoFar.toString(), message, RMObjectValidationMessageType.CARDINALITY_MISMATCH)});
                }
            } else {
                MultiplicityInterval existence = attribute.getExistence();
                if (existence != null && !existence.has((Object)(attributeValue == null ? 0 : 1))) {
                    String message = RMObjectValidationMessageIds.rm_EXISTENCE_MISMATCH.getMessage(new Object[]{attribute.getRmAttributeName(), attribute.getParent() == null ? "Unknown type" : attribute.getParent().getRmTypeName(), existence.toString()});
                    return Lists.newArrayList((Object[])new RMObjectValidationMessage[]{new RMObjectValidationMessage((ArchetypeConstraint)attribute, pathSoFar.toString(), message, RMObjectValidationMessageType.REQUIRED)});
                }
            }
            return new ArrayList<RMObjectValidationMessage>();
        }
    }

    static interface LazyPath {
        public static LazyPath of(String path) {
            return new SimpleLazyPath(null, path, null);
        }

        default public LazyPath add(String rmAttributeName) {
            return new SimpleLazyPath(this, rmAttributeName, null);
        }

        default public LazyPath add(String attributeName, CPrimitiveObject<?, ?> cPrimitiveObject) {
            return new SimpleLazyPath(this, attributeName, cPrimitiveObject.getNodeId());
        }

        default public LazyPath joinPaths(String other, boolean enforceSlash) {
            return new LazyPathJoin(this, enforceSlash, other);
        }

        default public LazyPath stripLastPathSegment() {
            return new LazyStripLastPathSegment(this);
        }

        public String toString();

        public static final class SimpleLazyPath
        implements LazyPath {
            private final LazyPath parent;
            private final String path;
            private final String nodeId;

            public SimpleLazyPath(LazyPath parent, String path, String nodeId) {
                this.parent = parent;
                this.path = path;
                this.nodeId = nodeId;
            }

            @Override
            public String toString() {
                Object p = this.path;
                if (this.nodeId != null) {
                    p = (String)p + "[" + this.nodeId + "]";
                }
                if (this.parent == null) {
                    return p;
                }
                return this.parent + "/" + (String)p;
            }
        }

        public static final class LazyPathJoin
        implements LazyPath {
            private final LazyPath parent;
            private final String path;
            private final boolean enforceSlash;

            public LazyPathJoin(LazyPath parent, boolean enforceSlash, String path) {
                this.parent = parent;
                this.enforceSlash = enforceSlash;
                this.path = path;
            }

            @Override
            public String toString() {
                if (this.enforceSlash) {
                    return FastRMObjectValidator.joinPaths(this.parent.toString(), "/", this.path);
                }
                return FastRMObjectValidator.joinPaths(this.parent.toString(), this.path);
            }
        }

        public static final class LazyStripLastPathSegment
        implements LazyPath {
            private final LazyPath child;

            public LazyStripLastPathSegment(LazyPath child) {
                this.child = child;
            }

            @Override
            public String toString() {
                return RMObjectValidationUtil.stripLastPathSegment(this.child.toString());
            }
        }
    }

    static class RMObjectValidationUtil {
        RMObjectValidationUtil() {
        }

        public static String getParentObservationTerm(CAttribute attribute) {
            String result = "";
            CObject parent = attribute.getParent();
            CAttribute attributeParent = parent.getParent();
            while (result.equals("") && parent != null && attributeParent != null) {
                ArchetypeTerm parentTerm;
                parent = attributeParent.getParent();
                if (parent != null && parent.getRmTypeName().equals("OBSERVATION") && (parentTerm = parent.getTerm()) != null) {
                    result = parentTerm.getText();
                }
                attributeParent = parent == null ? null : parent.getParent();
            }
            return result;
        }

        public static boolean hasNoneWithWrongType(List<RMObjectValidationMessage> subResult) {
            return subResult.stream().noneMatch(message -> message.getType() == RMObjectValidationMessageType.WRONG_TYPE);
        }

        public static List<CAttribute> getDefaultAttributeConstraints(CObject cObject, List<CAttribute> attributes, ModelInfoLookup lookup, ModelConstraintImposer constraintImposer) {
            ArrayList<CAttribute> result = new ArrayList<CAttribute>();
            Set alreadyConstrainedAttributes = attributes.isEmpty() ? Set.of() : attributes.stream().map(CAttribute::getRmAttributeName).collect(Collectors.toSet());
            RMTypeInfo typeInfo = lookup.getTypeInfo(cObject.getRmTypeName());
            if (typeInfo != null) {
                for (RMAttributeInfo defaultAttribute : typeInfo.getAttributes().values()) {
                    if (defaultAttribute.isComputed() || alreadyConstrainedAttributes.contains(defaultAttribute.getRmName())) continue;
                    CAttribute attribute = constraintImposer.getDefaultAttribute(cObject.getRmTypeName(), defaultAttribute.getRmName());
                    attribute.setParent((ArchetypeConstraint)cObject);
                    result.add(attribute);
                }
            }
            return result;
        }

        public static List<CAttribute> getDefaultAttributeConstraints(String rmTypeName, List<CAttribute> attributes, ModelInfoLookup lookup, ModelConstraintImposer constraintImposer) {
            CComplexObject fakeParent = new CComplexObject();
            fakeParent.setRmTypeName(rmTypeName);
            return RMObjectValidationUtil.getDefaultAttributeConstraints((CObject)fakeParent, attributes, lookup, constraintImposer);
        }

        public static String stripLastPathSegment(String path) {
            if (path.equals("/")) {
                return "";
            }
            int lastSlashIndex = path.lastIndexOf(47);
            if (lastSlashIndex == -1) {
                return path;
            }
            return path.substring(0, lastSlashIndex);
        }
    }

    static class PrimitiveObjectConstraintHelper {
        private final boolean failOnUnknownTerminologyId;

        PrimitiveObjectConstraintHelper(com.nedap.archie.rmobjectvalidator.ValidationConfiguration validationConfiguration) {
            this.failOnUnknownTerminologyId = validationConfiguration.isFailOnUnknownTerminologyId();
        }

        <ValueType> boolean isValidValue(CPrimitiveObject<?, ValueType> cPrimitiveObject, ValueType value) {
            if (cPrimitiveObject instanceof COrdered) {
                return this.isValidValue((COrdered)cPrimitiveObject, value);
            }
            if (cPrimitiveObject instanceof CString) {
                return this.isValidValue((CString)cPrimitiveObject, (String)value);
            }
            if (cPrimitiveObject instanceof CTerminologyCode) {
                return this.isValidValue((CTerminologyCode)cPrimitiveObject, (TerminologyCode)value);
            }
            return this.isValidValue_inner(cPrimitiveObject, value);
        }

        private <ValueType> boolean isValidValue_inner(CPrimitiveObject<?, ValueType> cPrimitiveObject, ValueType value) {
            if (cPrimitiveObject.getConstraint().isEmpty()) {
                return true;
            }
            for (Object constraint : cPrimitiveObject.getConstraint()) {
                if (!Objects.equals(constraint, value)) continue;
                return true;
            }
            return false;
        }

        private <T> boolean isValidValue(COrdered<T> cOrdered, T value) {
            if (cOrdered instanceof CTemporal) {
                return this.isValidValue((CTemporal)cOrdered, value);
            }
            return this.isValidValue_inner(cOrdered, value);
        }

        private <T> boolean isValidValue_inner(COrdered<T> cOrdered, T value) {
            if (cOrdered.getConstraint().isEmpty()) {
                return true;
            }
            for (Interval constraint : cOrdered.getConstraint()) {
                if (!constraint.has(value)) continue;
                return true;
            }
            return false;
        }

        private boolean isValidValue(CString cString, String value) {
            if (cString.getConstraint().isEmpty()) {
                return true;
            }
            for (String constraint : cString.getConstraint()) {
                if (!(constraint.length() > 1 && CString.isRegexConstraint((String)constraint) ? this.matchesRegexp(value, constraint) : Objects.equals(value, constraint))) continue;
                return true;
            }
            return false;
        }

        private boolean matchesRegexp(String value, String constraint) {
            return value.matches(constraint.substring(1).substring(0, constraint.length() - 2));
        }

        private <T> boolean isValidValue(CTemporal<T> cTemporal, T value) {
            if (cTemporal.getConstraint().isEmpty() && cTemporal.getPatternConstraint() == null) {
                return true;
            }
            if (cTemporal.getPatternConstraint() == null) {
                return this.isValidValue_inner((COrdered<T>)cTemporal, value);
            }
            return true;
        }

        private boolean isValidValue(CTerminologyCode terminologyCode, TerminologyCode value) {
            if (terminologyCode.getConstraint().isEmpty()) {
                return true;
            }
            if (terminologyCode.isConstraintRequired()) {
                List<String> values;
                if (value == null) {
                    return false;
                }
                String terminologyId = value.getTerminologyId();
                if (terminologyId == null || terminologyId.equalsIgnoreCase("local") || AOMUtils.isValueSetCode((String)value.getTerminologyId())) {
                    values = terminologyCode.getValueSetExpanded();
                } else if (terminologyId.equalsIgnoreCase("openehr")) {
                    values = this.getOpenEHRValueSetExpanded(terminologyCode);
                } else {
                    return !this.failOnUnknownTerminologyId;
                }
                if (values != null && !values.isEmpty()) {
                    return value.getCodeString() != null && values.contains(value.getCodeString());
                }
            } else {
                return true;
            }
            return false;
        }

        private List<String> getOpenEHRValueSetExpanded(CTerminologyCode terminologyCode) {
            List atCodes = terminologyCode.getValueSetExpanded();
            ArchetypeTerminology terminology = this.getTerminology(terminologyCode);
            OpenEHRTerminologyAccess terminologyAccess = OpenEHRTerminologyAccess.getInstance();
            ArrayList<String> result = new ArrayList<String>();
            if (terminology == null) {
                return result;
            }
            for (String atCode : atCodes) {
                String code;
                URI termBinding = terminology.getTermBinding("openehr", atCode);
                if (termBinding == null || (code = terminologyAccess.parseTerminologyURI(termBinding.toString())) == null) continue;
                result.add(code);
            }
            return result;
        }

        private ArchetypeTerminology getTerminology(CTerminologyCode cTerminologyCode) {
            Archetype archetype = cTerminologyCode.getArchetype();
            if (archetype != null) {
                return archetype.getTerminology((CObject)cTerminologyCode);
            }
            return null;
        }
    }
}

