/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.validation.webtemplate;

import com.nedap.archie.base.MultiplicityInterval;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateInput;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateInputValue;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateNode;

public class WebTemplateValidationUtils {
    private WebTemplateValidationUtils() {
    }

    public static boolean hasInputs(WebTemplateNode node) {
        return node != null && !node.getInputs().isEmpty();
    }

    public static Optional<WebTemplateInput> findInputWithType(WebTemplateNode node, String type) {
        for (WebTemplateInput input : node.getInputs()) {
            if (!Objects.equals(input.getType(), type)) continue;
            return Optional.of(input);
        }
        return Optional.empty();
    }

    public static WebTemplateInput getInputWithType(WebTemplateNode node, String type) {
        return WebTemplateValidationUtils.findInputWithType(node, type).orElseThrow();
    }

    public static boolean hasInputWithType(WebTemplateNode node, String type) {
        return WebTemplateValidationUtils.findInputWithType(node, type).isPresent();
    }

    public static Optional<WebTemplateInput> findInputWithSuffix(WebTemplateNode node, String suffix) {
        return node.getInputs().stream().filter(input -> Objects.equals(input.getSuffix(), suffix)).findFirst();
    }

    public static WebTemplateInput getInputWithSuffix(WebTemplateNode node, String suffix) {
        return WebTemplateValidationUtils.findInputWithSuffix(node, suffix).orElseThrow();
    }

    public static Optional<WebTemplateInputValue> findInputValue(WebTemplateInput input, String value) {
        return input.getList().stream().filter(inputValue -> Objects.equals(inputValue.getValue(), value)).findFirst();
    }

    public static boolean hasValidationPattern(WebTemplateInput input) {
        return input.getValidation() != null && input.getValidation().getPattern() != null;
    }

    public static boolean hasValidationRange(WebTemplateInput input) {
        return input.getValidation() != null && input.getValidation().getRange() != null;
    }

    public static boolean hasList(WebTemplateInput input) {
        return !input.getList().isEmpty() && BooleanUtils.isNotTrue((Boolean)input.getListOpen());
    }

    public static boolean hasValidationRange(WebTemplateInputValue inputValue) {
        return inputValue.getValidation() != null && inputValue.getValidation().getRange() != null;
    }

    public static boolean hasValidationPrecision(WebTemplateInputValue inputValue) {
        return inputValue.getValidation() != null && inputValue.getValidation().getPrecision() != null;
    }

    public static MultiplicityInterval getMultiplicityInterval(WebTemplateNode node) {
        MultiplicityInterval interval = new MultiplicityInterval();
        if (node.getMin() != -1) {
            interval.setLower((Object)node.getMin());
        } else {
            interval.setLowerUnbounded(true);
        }
        if (node.getMax() != -1) {
            interval.setUpper((Object)node.getMax());
        } else {
            interval.setUpperUnbounded(true);
        }
        return interval;
    }
}

