/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.webtemplate.model;

import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Optional;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateComparisonSymbol;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateInterval;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateValidation;

public enum ProportionType {
    RATIO(0, "ratio"),
    UNITARY(1, "unitary"),
    PERCENT(2, "percent"),
    FRACTION(3, "fraction"),
    INTEGER_FRACTION(4, "integer_fraction");

    private final int id;
    private final String webTemplateName;

    private ProportionType(int id, String webTemplateName) {
        this.id = id;
        this.webTemplateName = webTemplateName;
    }

    public int getId() {
        return this.id;
    }

    @JsonValue
    public String getWebTemplateName() {
        return this.webTemplateName;
    }

    public Optional<WebTemplateValidation> getDenominatorValidator() {
        if (this.equals((Object)UNITARY)) {
            return Optional.of(this.buildConstantValidation(1));
        }
        if (this.equals((Object)PERCENT)) {
            return Optional.of(this.buildConstantValidation(100.0));
        }
        return Optional.empty();
    }

    private <T extends Serializable> WebTemplateValidation buildConstantValidation(T value) {
        WebTemplateValidation validation = new WebTemplateValidation();
        WebTemplateInterval<T> range = new WebTemplateInterval<T>();
        range.setMax(value);
        range.setMaxOp(WebTemplateComparisonSymbol.LT_EQ);
        range.setMin(value);
        range.setMinOp(WebTemplateComparisonSymbol.GT_EQ);
        validation.setRange(range);
        return validation;
    }

    public static ProportionType findById(int id) {
        return Arrays.stream(ProportionType.values()).filter(v -> v.getId() == id).findAny().orElse(null);
    }
}

