/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.webtemplate.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ehrbase.openehr.sdk.webtemplate.model.StringToNumberSerializer;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateInputValue;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateValidation;
import org.ehrbase.openehr.sdk.webtemplate.util.WebTemplateUtils;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class WebTemplateInput
implements Serializable {
    private String suffix;
    private String type;
    private final List<WebTemplateInputValue> list;
    private Boolean listOpen;
    private WebTemplateValidation validation;
    private String terminology;
    @JsonSerialize(using=StringToNumberSerializer.class)
    private String defaultValue;

    public WebTemplateInput() {
        this.list = new ArrayList<WebTemplateInputValue>();
    }

    public WebTemplateInput(WebTemplateInput other) {
        this.suffix = other.suffix;
        this.type = other.type;
        this.listOpen = other.listOpen;
        this.validation = other.validation != null ? new WebTemplateValidation(other.validation) : null;
        this.terminology = other.terminology;
        this.defaultValue = other.defaultValue;
        this.list = WebTemplateUtils.cloneList(other.list, WebTemplateInputValue::new);
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<WebTemplateInputValue> getList() {
        return this.list;
    }

    public Boolean getListOpen() {
        return this.listOpen;
    }

    public void setListOpen(Boolean listOpen) {
        this.listOpen = listOpen;
    }

    public WebTemplateValidation getValidation() {
        return this.validation;
    }

    public void setValidation(WebTemplateValidation validation) {
        this.validation = validation;
    }

    public String getTerminology() {
        return this.terminology;
    }

    public void setTerminology(String terminology) {
        this.terminology = terminology;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebTemplateInput input = (WebTemplateInput)o;
        return Objects.equals(this.suffix, input.suffix) && Objects.equals(this.type, input.type) && Objects.equals(this.list, input.list) && Objects.equals(this.listOpen, input.listOpen) && Objects.equals(this.validation, input.validation) && Objects.equals(this.terminology, input.terminology) && Objects.equals(this.defaultValue, input.defaultValue);
    }

    public int hashCode() {
        return Objects.hash(this.suffix, this.type, this.list, this.listOpen, this.validation, this.terminology, this.defaultValue);
    }
}

