/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.openehr.sdk.webtemplate.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateTerminology;
import org.ehrbase.openehr.sdk.webtemplate.model.WebTemplateValidation;
import org.ehrbase.openehr.sdk.webtemplate.util.WebTemplateUtils;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class WebTemplateInputValue
implements Serializable {
    private String value;
    private String label;
    private final Map<String, String> localizedLabels;
    private final Map<String, String> localizedDescriptions;
    private final Map<String, WebTemplateTerminology> termBindings;
    private Integer ordinal;
    private final List<String> currentStates;
    private WebTemplateValidation validation;

    public WebTemplateInputValue() {
        this.localizedLabels = new HashMap<String, String>();
        this.localizedDescriptions = new HashMap<String, String>();
        this.termBindings = new LinkedHashMap<String, WebTemplateTerminology>();
        this.currentStates = new ArrayList<String>();
    }

    public WebTemplateInputValue(WebTemplateInputValue other) {
        this.value = other.value;
        this.label = other.label;
        this.ordinal = other.ordinal;
        this.validation = other.validation != null ? new WebTemplateValidation(other.validation) : null;
        this.localizedLabels = new HashMap<String, String>(other.localizedLabels);
        this.localizedDescriptions = new HashMap<String, String>(other.localizedDescriptions);
        this.termBindings = WebTemplateUtils.cloneMap(other.termBindings, WebTemplateTerminology::new);
        this.currentStates = new ArrayList<String>(other.currentStates);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Map<String, String> getLocalizedLabels() {
        return this.localizedLabels;
    }

    public Map<String, String> getLocalizedDescriptions() {
        return this.localizedDescriptions;
    }

    public Map<String, WebTemplateTerminology> getTermBindings() {
        return this.termBindings;
    }

    public Integer getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(Integer ordinal) {
        this.ordinal = ordinal;
    }

    public List<String> getCurrentStates() {
        return this.currentStates;
    }

    public WebTemplateValidation getValidation() {
        return this.validation;
    }

    public void setValidation(WebTemplateValidation validation) {
        this.validation = validation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebTemplateInputValue value1 = (WebTemplateInputValue)o;
        return Objects.equals(this.value, value1.value) && Objects.equals(this.label, value1.label) && Objects.equals(this.ordinal, value1.ordinal) && Objects.equals(this.localizedLabels, value1.localizedLabels) && Objects.equals(this.localizedDescriptions, value1.localizedDescriptions) && Objects.equals(this.termBindings, value1.termBindings) && Objects.equals(this.currentStates, value1.currentStates) && Objects.equals(this.validation, value1.validation);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.label, this.localizedLabels, this.localizedDescriptions, this.termBindings, this.ordinal, this.currentStates, this.validation);
    }
}

