/*
 * Decompiled with CFR 0.152.
 */
package org.eiichiro.ash;

import com.google.common.base.Preconditions;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import jline.console.completer.Completer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.eiichiro.ash.Command;
import org.eiichiro.ash.CommandCompleter;
import org.eiichiro.ash.Console;
import org.eiichiro.ash.Line;
import org.eiichiro.ash.Usage;

public class Shell {
    private Console console = new Console();
    private Map<String, Command> commands = new ConcurrentHashMap<String, Command>();
    private Map<String, Options> options = new ConcurrentHashMap<String, Options>();
    private AtomicBoolean repl = new AtomicBoolean(false);

    public Shell() {
        this.console.reader().addCompleter((Completer)new CommandCompleter(this));
    }

    public void register(Command command) {
        Preconditions.checkArgument((command != null ? 1 : 0) != 0, (Object)("Parameter 'command' must not be [" + command + "]"));
        this.register(command.name(), command);
    }

    public void register(String name, Command command) {
        Preconditions.checkArgument((name != null && !name.isEmpty() ? 1 : 0) != 0, (Object)("Parameter 'name' must not be [" + name + "]"));
        Preconditions.checkArgument((command != null ? 1 : 0) != 0, (Object)("Parameter 'command' must not be [" + command + "]"));
        this.commands.put(name, command);
    }

    public void unregister(String name) {
        Preconditions.checkArgument((name != null && !name.isEmpty() ? 1 : 0) != 0, (Object)("Parameter 'name' must not be [" + name + "]"));
        this.commands.remove(name);
    }

    public Map<String, Command> commands() {
        return this.commands;
    }

    public void exec(String line) {
        Command command;
        String[] strings = line.split("\\s");
        if (strings.length == 0) {
            return;
        }
        String cmd = strings[0];
        if (strings[0] == null || strings[0].isEmpty()) {
            return;
        }
        String[] args = new String[]{};
        if (strings.length > 1) {
            args = new String[strings.length - 1];
            System.arraycopy(strings, 1, args, 0, args.length);
        }
        if ((command = this.commands.get(cmd)) == null) {
            this.console.println(cmd + ": command not found");
            return;
        }
        Usage usage = command.usage();
        Options opts = this.options.get(command.name());
        if (opts == null) {
            opts = new Options();
            for (Usage.Option option : usage.options()) {
                String arg = option.arg();
                Option opt = new Option(option.opt(), option.longOpt(), arg != null && !arg.isEmpty(), option.description());
                opt.setRequired(option.required());
                if (opt.hasArg()) {
                    opt.setArgName(arg);
                }
                opts.addOption(opt);
            }
            this.options.put(command.name(), opts);
        }
        GnuParser parser = new GnuParser();
        CommandLine commandLine = null;
        try {
            commandLine = parser.parse(opts, args);
        }
        catch (ParseException e) {
            this.console().println(usage.toString());
            return;
        }
        HashMap<String, String> options = new HashMap<String, String>();
        for (Option option : commandLine.getOptions()) {
            String longOpt;
            String opt = option.getOpt();
            if (opt != null && !opt.isEmpty()) {
                options.put(opt, option.getValue());
            }
            if ((longOpt = option.getLongOpt()) == null || longOpt.isEmpty()) continue;
            options.put(longOpt, option.getValue());
        }
        Line l = new Line(cmd, options, commandLine.getArgList());
        try {
            command.run(l);
        }
        catch (Exception e) {
            e.printStackTrace(new PrintWriter(this.console.reader().getOutput()));
        }
    }

    public void start() {
        this.repl.set(true);
        String line = null;
        while (this.repl.get() && (line = this.console.readLine()) != null) {
            this.exec(line);
        }
    }

    public void stop() {
        this.repl.set(false);
    }

    public boolean started() {
        return this.repl.get();
    }

    public Console console() {
        return this.console;
    }
}

